/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.StreamReadCapability;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.util.DurationUnitConverter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Duration;

public class DurationDeserializer
extends JSR310DeserializerBase<Duration>
implements ContextualDeserializer {
    public static final DurationDeserializer INSTANCE = new DurationDeserializer();
    protected final DurationUnitConverter _durationUnitConverter;

    public DurationDeserializer() {
        super(Duration.class);
        this._durationUnitConverter = null;
    }

    protected DurationDeserializer(DurationDeserializer durationDeserializer, Boolean bl2) {
        super(durationDeserializer, bl2);
        this._durationUnitConverter = durationDeserializer._durationUnitConverter;
    }

    protected DurationDeserializer(DurationDeserializer durationDeserializer, DurationUnitConverter durationUnitConverter) {
        super(durationDeserializer, (Boolean)durationDeserializer._isLenient);
        this._durationUnitConverter = durationUnitConverter;
    }

    protected DurationDeserializer withLeniency(Boolean bl2) {
        return new DurationDeserializer(this, bl2);
    }

    protected DurationDeserializer withConverter(DurationUnitConverter durationUnitConverter) {
        return new DurationDeserializer(this, durationUnitConverter);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        JsonFormat.Value value = this.findFormatOverrides(deserializationContext, beanProperty, this.handledType());
        DurationDeserializer durationDeserializer = this;
        if (value != null) {
            Object object;
            if (value.hasLenient() && (object = value.getLenient()) != null) {
                durationDeserializer = durationDeserializer.withLeniency((Boolean)object);
            }
            if (value.hasPattern()) {
                object = value.getPattern();
                DurationUnitConverter durationUnitConverter = DurationUnitConverter.from((String)object);
                if (durationUnitConverter == null) {
                    deserializationContext.reportBadDefinition(this.getValueType(deserializationContext), String.format("Bad 'pattern' definition (\"%s\") for `Duration`: expected one of [%s]", object, DurationUnitConverter.descForAllowed()));
                }
                durationDeserializer = durationDeserializer.withConverter(durationUnitConverter);
            }
        }
        return durationDeserializer;
    }

    @Override
    public Duration deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.currentTokenId()) {
            case 8: {
                BigDecimal bigDecimal = jsonParser.getDecimalValue();
                return DecimalUtils.extractSecondsAndNanos(bigDecimal, Duration::ofSeconds);
            }
            case 7: {
                return this._fromTimestamp(deserializationContext, jsonParser.getLongValue());
            }
            case 6: {
                return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
            }
            case 1: {
                return this._fromString(jsonParser, deserializationContext, deserializationContext.extractScalarFromObject(jsonParser, this, this.handledType()));
            }
            case 12: {
                return (Duration)jsonParser.getEmbeddedObject();
            }
            case 3: {
                return (Duration)this._deserializeFromArray(jsonParser, deserializationContext);
            }
        }
        return (Duration)this._handleUnexpectedToken(deserializationContext, jsonParser, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT);
    }

    protected Duration _fromString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return (Duration)this._fromEmptyString(jsonParser, deserializationContext, string2);
        }
        if (deserializationContext.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(string2)) {
            return this._fromTimestamp(deserializationContext, NumberInput.parseLong(string2));
        }
        try {
            return Duration.parse(string2);
        }
        catch (DateTimeException dateTimeException) {
            return (Duration)this._handleDateTimeException(deserializationContext, dateTimeException, string2);
        }
    }

    protected Duration _fromTimestamp(DeserializationContext deserializationContext, long l2) {
        if (this._durationUnitConverter != null) {
            return this._durationUnitConverter.convert(l2);
        }
        if (deserializationContext.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
            return Duration.ofSeconds(l2);
        }
        return Duration.ofMillis(l2);
    }
}

