/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.function;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.IOExceptionList;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.IOIndexedException;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.function.Erase;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.function.IOConsumer;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.function.IOStream;
import java.io.IOException;
import java.util.function.BiFunction;
import java.util.stream.Stream;

final class IOStreams {
    static final Object NONE = new Object();

    static <T> void forAll(Stream<T> stream, IOConsumer<T> iOConsumer) throws IOExceptionList {
        IOStreams.forAll(stream, iOConsumer, (n2, iOException) -> iOException);
    }

    static <T> void forAll(Stream<T> stream, IOConsumer<T> iOConsumer, BiFunction<Integer, IOException, IOException> biFunction) throws IOExceptionList {
        IOStream.adapt(stream).forAll(iOConsumer, IOIndexedException::new);
    }

    static <T> void forEach(Stream<T> stream, IOConsumer<T> iOConsumer) throws IOException {
        IOConsumer iOConsumer2 = IOStreams.toIOConsumer(iOConsumer);
        IOStreams.of(stream).forEach(object -> Erase.accept(iOConsumer2, object));
    }

    static <T> Stream<T> of(Stream<T> stream) {
        return stream == null ? Stream.empty() : stream;
    }

    @SafeVarargs
    static <T> Stream<T> of(T ... TArray) {
        return TArray == null ? Stream.empty() : Stream.of(TArray);
    }

    static <T> IOConsumer<T> toIOConsumer(IOConsumer<T> iOConsumer) {
        return iOConsumer != null ? iOConsumer : IOConsumer.noop();
    }
}

