/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpClient;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpConversation;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpDestination;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpRequest;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpResponseException;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.Origin;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.ProxyConfiguration;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Connection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Destination;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Request;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpMethod;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpScheme;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ClientConnectionFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.EndPoint;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Attachable;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Promise;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ssl.SslContextFactory;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpProxy
extends ProxyConfiguration.Proxy {
    private static final Logger LOG = Log.getLogger(HttpProxy.class);

    public HttpProxy(Origin.Address address, boolean bl2) {
        super(address, bl2);
    }

    @Override
    public ClientConnectionFactory newClientConnectionFactory(ClientConnectionFactory clientConnectionFactory) {
        return new HttpProxyClientConnectionFactory(clientConnectionFactory);
    }

    @Override
    public URI getURI() {
        String string = this.isSecure() ? HttpScheme.HTTPS.asString() : HttpScheme.HTTP.asString();
        return URI.create(new Origin(string, this.getAddress()).asString());
    }

    private static class TunnelPromise
    implements Promise<Connection> {
        private final Request request;
        private final Response.CompleteListener listener;
        private final Promise<Connection> promise;

        private TunnelPromise(Request request, Response.CompleteListener completeListener, Promise<Connection> promise) {
            this.request = request;
            this.listener = completeListener;
            this.promise = promise;
        }

        @Override
        public void succeeded(Connection connection) {
            connection.send(this.request, this.listener);
        }

        @Override
        public void failed(Throwable throwable) {
            this.promise.failed(throwable);
        }

        private void setEndPoint(EndPoint endPoint) {
            HttpConversation httpConversation = ((HttpRequest)this.request).getConversation();
            httpConversation.setAttribute(EndPoint.class.getName(), endPoint);
        }
    }

    private static class ProxyConnection
    implements Connection,
    Attachable {
        private final Destination destination;
        private final Connection connection;
        private final Promise<Connection> promise;
        private Object attachment;

        private ProxyConnection(Destination destination, Connection connection, Promise<Connection> promise) {
            this.destination = destination;
            this.connection = connection;
            this.promise = promise;
        }

        @Override
        public void send(Request request, Response.CompleteListener completeListener) {
            if (this.connection.isClosed()) {
                this.destination.newConnection(new TunnelPromise(request, completeListener, this.promise));
            } else {
                this.connection.send(request, completeListener);
            }
        }

        @Override
        public void close() {
            this.connection.close();
        }

        @Override
        public boolean isClosed() {
            return this.connection.isClosed();
        }

        @Override
        public void setAttachment(Object object) {
            this.attachment = object;
        }

        @Override
        public Object getAttachment() {
            return this.attachment;
        }
    }

    private static class CreateTunnelPromise
    implements Promise<Connection> {
        private final ClientConnectionFactory connectionFactory;
        private final EndPoint endPoint;
        private final Promise<Connection> promise;
        private final Map<String, Object> context;

        private CreateTunnelPromise(ClientConnectionFactory clientConnectionFactory, EndPoint endPoint, Promise<Connection> promise, Map<String, Object> map) {
            this.connectionFactory = clientConnectionFactory;
            this.endPoint = endPoint;
            this.promise = promise;
            this.context = map;
        }

        @Override
        public void succeeded(Connection connection) {
            HttpDestination httpDestination = (HttpDestination)this.context.get("http.destination");
            this.tunnel(httpDestination, connection);
        }

        @Override
        public void failed(Throwable throwable) {
            this.tunnelFailed(this.endPoint, throwable);
        }

        private void tunnel(HttpDestination httpDestination, Connection connection) {
            String string = httpDestination.getOrigin().getAddress().asString();
            Origin.Address address = httpDestination.getConnectAddress();
            HttpClient httpClient = httpDestination.getHttpClient();
            long l2 = httpClient.getConnectTimeout();
            Request request = httpClient.newRequest(address.getHost(), address.getPort()).method(HttpMethod.CONNECT).path(string).header(HttpHeader.HOST, string).idleTimeout(2L * l2, TimeUnit.MILLISECONDS).timeout(l2, TimeUnit.MILLISECONDS);
            ProxyConfiguration.Proxy proxy = httpDestination.getProxy();
            if (proxy != null && proxy.isSecure()) {
                request.scheme(HttpScheme.HTTPS.asString());
            }
            HttpConversation httpConversation = ((HttpRequest)request).getConversation();
            httpConversation.setAttribute(EndPoint.class.getName(), this.endPoint);
            request.attribute(Connection.class.getName(), new ProxyConnection(httpDestination, connection, this.promise));
            connection.send(request, result -> {
                EndPoint endPoint = (EndPoint)httpConversation.getAttribute(EndPoint.class.getName());
                if (result.isSucceeded()) {
                    Response response = result.getResponse();
                    if (response.getStatus() == 200) {
                        this.tunnelSucceeded(endPoint);
                    } else {
                        HttpResponseException httpResponseException = new HttpResponseException("Unexpected " + response + " for " + result.getRequest(), response);
                        this.tunnelFailed(endPoint, httpResponseException);
                    }
                } else {
                    this.tunnelFailed(endPoint, result.getFailure());
                }
            });
        }

        private void tunnelSucceeded(EndPoint endPoint) {
            try {
                this.context.put("http.connection.promise", this.promise);
                HttpDestination httpDestination = (HttpDestination)this.context.get("http.destination");
                ClientConnectionFactory clientConnectionFactory = httpDestination.newSslClientConnectionFactory(null, this.connectionFactory);
                HttpConnectionOverHTTP httpConnectionOverHTTP = (HttpConnectionOverHTTP)endPoint.getConnection();
                this.context.put("ssl.peer.host", httpDestination.getHost());
                this.context.put("ssl.peer.port", httpDestination.getPort());
                com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.Connection connection = clientConnectionFactory.newConnection(endPoint, this.context);
                endPoint.setConnection(httpConnectionOverHTTP);
                endPoint.upgrade(connection);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("HTTP tunnel established: {} over {}", httpConnectionOverHTTP, connection);
                }
            }
            catch (Throwable throwable) {
                this.tunnelFailed(endPoint, throwable);
            }
        }

        private void tunnelFailed(EndPoint endPoint, Throwable throwable) {
            endPoint.close();
            this.promise.failed(throwable);
        }
    }

    private static class HttpProxyClientConnectionFactory
    implements ClientConnectionFactory {
        private final ClientConnectionFactory connectionFactory;

        private HttpProxyClientConnectionFactory(ClientConnectionFactory clientConnectionFactory) {
            this.connectionFactory = clientConnectionFactory;
        }

        @Override
        public com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.Connection newConnection(EndPoint endPoint, Map<String, Object> map) throws IOException {
            HttpDestination httpDestination = (HttpDestination)map.get("http.destination");
            SslContextFactory sslContextFactory = httpDestination.getHttpClient().getSslContextFactory();
            if (httpDestination.isSecure()) {
                if (sslContextFactory != null) {
                    Promise promise;
                    Promise promise2 = promise = (Promise)map.get("http.connection.promise");
                    if (promise instanceof Promise.Wrapper) {
                        promise2 = ((Promise.Wrapper)promise).unwrap();
                    }
                    if (promise2 instanceof TunnelPromise) {
                        ((TunnelPromise)promise2).setEndPoint(endPoint);
                        return this.connectionFactory.newConnection(endPoint, map);
                    }
                    CreateTunnelPromise createTunnelPromise = new CreateTunnelPromise(this.connectionFactory, endPoint, promise, map);
                    map.put("http.connection.promise", createTunnelPromise);
                    return this.connectionFactory.newConnection(endPoint, map);
                }
                throw new IOException("Cannot tunnel request, missing " + SslContextFactory.class.getName() + " in " + HttpClient.class.getName());
            }
            return this.connectionFactory.newConnection(endPoint, map);
        }
    }
}

