/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpClient;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpConversation;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.Origin;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.ContentProvider;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.ContentResponse;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Request;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Result;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.util.FutureResponseListener;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpFields;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpMethod;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpVersion;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Callback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Fields;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class HttpRequest
implements Request {
    private static final URI NULL_URI = URI.create("null:0");
    private final HttpFields headers = new HttpFields();
    private final Fields params = new Fields(true);
    private final List<Response.ResponseListener> responseListeners = new ArrayList<Response.ResponseListener>();
    private final AtomicReference<Throwable> aborted = new AtomicReference();
    private final HttpClient client;
    private final HttpConversation conversation;
    private String scheme;
    private String host;
    private int port;
    private String path;
    private String query;
    private URI uri;
    private String method = HttpMethod.GET.asString();
    private HttpVersion version = HttpVersion.HTTP_1_1;
    private long idleTimeout = -1L;
    private long timeout;
    private long timeoutAt = Long.MAX_VALUE;
    private ContentProvider content;
    private boolean followRedirects;
    private List<HttpCookie> cookies;
    private Map<String, Object> attributes;
    private List<Request.RequestListener> requestListeners;
    private Supplier<HttpFields> trailers;
    private Object tag;
    private boolean normalized;

    protected HttpRequest(HttpClient httpClient, HttpConversation httpConversation, URI uRI) {
        HttpField httpField;
        this.client = httpClient;
        this.conversation = httpConversation;
        this.scheme = uRI.getScheme();
        this.host = uRI.getHost();
        this.port = HttpClient.normalizePort(this.scheme, uRI.getPort());
        this.path = uRI.getRawPath();
        this.query = uRI.getRawQuery();
        this.extractParams(this.query);
        this.followRedirects(httpClient.isFollowRedirects());
        HttpField httpField2 = httpClient.getAcceptEncodingField();
        if (httpField2 != null) {
            this.headers.put(httpField2);
        }
        if ((httpField = httpClient.getUserAgentField()) != null) {
            this.headers.put(httpField);
        }
    }

    public HttpConversation getConversation() {
        return this.conversation;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public Request scheme(String string) {
        this.scheme = string;
        this.uri = null;
        return this;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public Request method(HttpMethod httpMethod) {
        return this.method(httpMethod.asString());
    }

    @Override
    public Request method(String string) {
        this.method = Objects.requireNonNull(string).toUpperCase(Locale.ENGLISH);
        return this;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Request path(String string) {
        URI uRI = this.newURI(string);
        if (uRI == null) {
            this.path = string;
            this.query = null;
        } else {
            String string2 = uRI.getRawPath();
            if (string2 == null) {
                string2 = "";
            }
            if (!string2.startsWith("/")) {
                string2 = "/" + string2;
            }
            this.path = string2;
            String string3 = uRI.getRawQuery();
            if (string3 != null) {
                this.query = string3;
                this.params.clear();
                this.extractParams(string3);
            }
            if (uRI.isAbsolute()) {
                this.path = this.buildURI(false).toString();
            }
        }
        this.uri = null;
        return this;
    }

    public String getQuery() {
        return this.query;
    }

    @Override
    public URI getURI() {
        if (this.uri == null) {
            this.uri = this.buildURI(true);
        }
        boolean bl2 = this.uri == NULL_URI;
        return bl2 ? null : this.uri;
    }

    @Override
    public HttpVersion getVersion() {
        return this.version;
    }

    @Override
    public Request version(HttpVersion httpVersion) {
        this.version = Objects.requireNonNull(httpVersion);
        return this;
    }

    private Request param(String string, String string2, boolean bl2) {
        this.params.add(string, string2);
        if (!bl2) {
            this.query = this.query != null ? this.query + "&" + this.urlEncode(string) + "=" + this.urlEncode(string2) : this.buildQuery();
            this.uri = null;
        }
        return this;
    }

    @Override
    public Request accept(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        if (stringBuilder.length() > 0) {
            this.headers.put(HttpHeader.ACCEPT, stringBuilder.toString());
        }
        return this;
    }

    @Override
    public Request header(String string, String string2) {
        if (string2 == null) {
            this.headers.remove(string);
        } else {
            this.headers.add(string, string2);
        }
        return this;
    }

    @Override
    public Request header(HttpHeader httpHeader, String string) {
        if (string == null) {
            this.headers.remove(httpHeader);
        } else {
            this.headers.add(httpHeader, string);
        }
        return this;
    }

    @Override
    public List<HttpCookie> getCookies() {
        return this.cookies != null ? this.cookies : Collections.emptyList();
    }

    public Object getTag() {
        return this.tag;
    }

    @Override
    public Request attribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>(4);
        }
        this.attributes.put(string, object);
        return this;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes != null ? this.attributes : Collections.emptyMap();
    }

    @Override
    public HttpFields getHeaders() {
        return this.headers;
    }

    @Override
    public <T extends Request.RequestListener> List<T> getRequestListeners(Class<T> clazz) {
        if (clazz == null || this.requestListeners == null) {
            return this.requestListeners != null ? this.requestListeners : Collections.emptyList();
        }
        ArrayList<Request.RequestListener> arrayList = new ArrayList<Request.RequestListener>();
        for (Request.RequestListener requestListener : this.requestListeners) {
            if (!clazz.isInstance(requestListener)) continue;
            arrayList.add(requestListener);
        }
        return arrayList;
    }

    @Override
    public Request listener(Request.Listener listener) {
        return this.requestListener(listener);
    }

    @Override
    public Request onRequestBegin(final Request.BeginListener beginListener) {
        return this.requestListener(new Request.BeginListener(){

            @Override
            public void onBegin(Request request) {
                beginListener.onBegin(request);
            }
        });
    }

    private Request requestListener(Request.RequestListener requestListener) {
        if (this.requestListeners == null) {
            this.requestListeners = new ArrayList<Request.RequestListener>();
        }
        this.requestListeners.add(requestListener);
        return this;
    }

    public Request onResponseHeaders(final Response.HeadersListener headersListener) {
        this.responseListeners.add(new Response.HeadersListener(){

            @Override
            public void onHeaders(Response response) {
                headersListener.onHeaders(response);
            }
        });
        return this;
    }

    public Request onResponseContent(final Response.ContentListener contentListener) {
        this.responseListeners.add(new Response.ContentListener(){

            @Override
            public void onContent(Response response, ByteBuffer byteBuffer) {
                contentListener.onContent(response, byteBuffer);
            }
        });
        return this;
    }

    public Request onComplete(final Response.CompleteListener completeListener) {
        this.responseListeners.add(new Response.CompleteListener(){

            @Override
            public void onComplete(Result result) {
                completeListener.onComplete(result);
            }
        });
        return this;
    }

    @Override
    public ContentProvider getContent() {
        return this.content;
    }

    @Override
    public Request content(ContentProvider contentProvider) {
        return this.content(contentProvider, null);
    }

    @Override
    public Request content(ContentProvider contentProvider, String string) {
        if (string != null) {
            this.header(HttpHeader.CONTENT_TYPE, string);
        }
        this.content = contentProvider;
        return this;
    }

    @Override
    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    @Override
    public Request followRedirects(boolean bl2) {
        this.followRedirects = bl2;
        return this;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public Request idleTimeout(long l2, TimeUnit timeUnit) {
        this.idleTimeout = timeUnit.toMillis(l2);
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public Request timeout(long l2, TimeUnit timeUnit) {
        this.timeout = timeUnit.toMillis(l2);
        return this;
    }

    @Override
    public ContentResponse send() throws InterruptedException, TimeoutException, ExecutionException {
        FutureResponseListener futureResponseListener = new FutureResponseListener(this);
        this.send(futureResponseListener);
        try {
            return futureResponseListener.get();
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof TimeoutException) {
                TimeoutException timeoutException = (TimeoutException)executionException.getCause();
                this.abort(timeoutException);
                throw timeoutException;
            }
            this.abort(executionException);
            throw executionException;
        }
        catch (Throwable throwable) {
            this.abort(throwable);
            throw throwable;
        }
    }

    @Override
    public void send(Response.CompleteListener completeListener) {
        this.sendAsync(this.client::send, completeListener);
    }

    private void sendAsync(BiConsumer<HttpRequest, List<Response.ResponseListener>> biConsumer, Response.CompleteListener completeListener) {
        if (completeListener != null) {
            this.responseListeners.add(completeListener);
        }
        this.sent();
        biConsumer.accept(this, this.responseListeners);
    }

    void sent() {
        long l2 = this.getTimeout();
        if (l2 > 0L) {
            this.timeoutAt = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(l2);
        }
    }

    long getTimeoutAt() {
        return this.timeoutAt;
    }

    protected List<Response.ResponseListener> getResponseListeners() {
        return this.responseListeners;
    }

    public Supplier<HttpFields> getTrailers() {
        return this.trailers;
    }

    @Override
    public boolean abort(Throwable throwable) {
        if (this.aborted.compareAndSet(null, Objects.requireNonNull(throwable))) {
            if (this.content instanceof Callback) {
                ((Callback)((Object)this.content)).failed(throwable);
            }
            return this.conversation.abort(throwable);
        }
        return false;
    }

    @Override
    public Throwable getAbortCause() {
        return this.aborted.get();
    }

    boolean normalized() {
        boolean bl2 = this.normalized;
        this.normalized = true;
        return bl2;
    }

    private String buildQuery() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Fields.Field> iterator = this.params.iterator();
        while (iterator.hasNext()) {
            Fields.Field field = iterator.next();
            List<String> list = field.getValues();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (i2 > 0) {
                    stringBuilder.append("&");
                }
                stringBuilder.append(field.getName()).append("=");
                stringBuilder.append(this.urlEncode(list.get(i2)));
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append("&");
        }
        return stringBuilder.toString();
    }

    private String urlEncode(String string) {
        if (string == null) {
            return "";
        }
        String string2 = "utf-8";
        try {
            return URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedCharsetException(string2);
        }
    }

    private void extractParams(String string) {
        if (string != null) {
            for (String string2 : string.split("&")) {
                String string3;
                String[] stringArray = string2.split("=");
                if (stringArray.length <= 0 || (string3 = this.urlDecode(stringArray[0])).trim().length() == 0) continue;
                this.param(string3, stringArray.length < 2 ? "" : this.urlDecode(stringArray[1]), true);
            }
        }
    }

    private String urlDecode(String string) {
        String string2 = "utf-8";
        try {
            return URLDecoder.decode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedCharsetException(string2);
        }
    }

    private URI buildURI(boolean bl2) {
        URI uRI;
        String string = this.getPath();
        String string2 = this.getQuery();
        if (string2 != null && bl2) {
            string = string + "?" + string2;
        }
        if ((uRI = this.newURI(string)) == null) {
            return NULL_URI;
        }
        if (!uRI.isAbsolute()) {
            uRI = URI.create(new Origin(this.getScheme(), this.getHost(), this.getPort()).asString() + string);
        }
        return uRI;
    }

    private URI newURI(String string) {
        try {
            if ("*".equals(string)) {
                return null;
            }
            URI uRI = new URI(string);
            return uRI.isOpaque() ? null : uRI;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public String toString() {
        return String.format("%s[%s %s %s]@%x", new Object[]{this.getClass().getSimpleName(), this.getMethod(), this.getPath(), this.getVersion(), this.hashCode()});
    }
}

