/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

abstract class AbstractByteBufferPool
implements ByteBufferPool {
    private final int _factor;
    private final int _maxQueueLength;
    private final long _maxHeapMemory;
    private final long _maxDirectMemory;
    private final AtomicLong _heapMemory = new AtomicLong();
    private final AtomicLong _directMemory = new AtomicLong();

    protected AbstractByteBufferPool(int n2, int n3, long l2, long l3) {
        this._factor = n2 <= 0 ? 1024 : n2;
        this._maxQueueLength = n3;
        this._maxHeapMemory = l2 != 0L ? l2 : Runtime.getRuntime().maxMemory() / 4L;
        this._maxDirectMemory = l3 != 0L ? l3 : Runtime.getRuntime().maxMemory() / 4L;
    }

    protected int getCapacityFactor() {
        return this._factor;
    }

    protected int getMaxQueueLength() {
        return this._maxQueueLength;
    }

    protected void releaseExcessMemory(boolean bl2, Consumer<Boolean> consumer) {
        long l2;
        long l3 = l2 = bl2 ? this._maxDirectMemory : this._maxHeapMemory;
        if (l2 > 0L) {
            while (this.getMemory(bl2) > l2) {
                consumer.accept(bl2);
            }
        }
    }

    public long getDirectMemory() {
        return this.getMemory(true);
    }

    public long getHeapMemory() {
        return this.getMemory(false);
    }

    public long getMaxDirectMemory() {
        return this._maxDirectMemory;
    }

    public long getMaxHeapMemory() {
        return this._maxHeapMemory;
    }

    public long getMemory(boolean bl2) {
        AtomicLong atomicLong = bl2 ? this._directMemory : this._heapMemory;
        return atomicLong.get();
    }

    IntConsumer updateMemory(boolean bl2) {
        return bl2 ? this._directMemory::addAndGet : this._heapMemory::addAndGet;
    }
}

