/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.AbstractTrie;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.MathUtils;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.StringUtil;
import java.nio.ByteBuffer;

public class ArrayTernaryTrie<V>
extends AbstractTrie<V> {
    private static int LO = 1;
    private static int EQ = 2;
    private static int HI = 3;
    private final char[] _tree;
    private final String[] _key;
    private final V[] _value;
    private char _rows;

    public ArrayTernaryTrie() {
        this(128);
    }

    public ArrayTernaryTrie(int n2) {
        this(true, n2);
    }

    public ArrayTernaryTrie(boolean bl2, int n2) {
        super(bl2);
        if (n2 > 65534) {
            throw new IllegalArgumentException("Capacity " + n2 + " > " + 65534);
        }
        this._value = new Object[n2 + 1];
        this._tree = new char[(n2 + 1) * 4];
        this._key = new String[n2 + 1];
    }

    @Override
    public boolean put(String string, V v2) {
        char c2 = '\u0000';
        int n2 = string.length();
        if (n2 > 65534) {
            return false;
        }
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            char c3 = string.charAt(i2);
            if (this.isCaseInsensitive() && c3 < '\u0080') {
                c3 = StringUtil.lowercases[c3];
            }
            do {
                char c4;
                if (this._rows == '\ufffe') {
                    return false;
                }
                int n5 = 4 * c2;
                if (c2 == this._rows) {
                    this._rows = (char)MathUtils.cappedAdd(this._rows, 1, this._key.length);
                    if (this._rows == this._key.length) {
                        return false;
                    }
                    this._tree[n5] = c3;
                }
                if ((n4 = (c4 = this._tree[n5]) - c3) == 0) {
                    n3 = n5 + EQ;
                    c2 = this._tree[n3];
                } else if (n4 < 0) {
                    n3 = n5 + LO;
                    c2 = this._tree[n3];
                } else {
                    n3 = n5 + HI;
                    c2 = this._tree[n3];
                }
                if (c2 != '\u0000') continue;
                c2 = this._rows;
                this._tree[n3] = c2;
            } while (n4 != 0);
        }
        if (c2 == this._rows) {
            if (this._rows == this._key.length) {
                return false;
            }
            this._rows = (char)(this._rows + '\u0001');
        }
        this._key[c2] = v2 == null ? null : string;
        this._value[c2] = v2;
        return true;
    }

    @Override
    public V get(String string, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        block0: while (n5 < n3) {
            int n6;
            int n7;
            char c2 = string.charAt(n2 + n5++);
            if (this.isCaseInsensitive() && c2 < '\u0080') {
                c2 = StringUtil.lowercases[c2];
            }
            do {
                char c3;
                if ((n6 = (c3 = this._tree[n7 = 4 * n4]) - c2) != 0) continue;
                n4 = this._tree[n7 + EQ];
                if (n4 != 0) continue block0;
                return null;
            } while ((n4 = this._tree[n7 + ArrayTernaryTrie.hilo(n6)]) != 0);
            return null;
        }
        return this._value[n4];
    }

    @Override
    public V getBest(ByteBuffer byteBuffer, int n2, int n3) {
        if (byteBuffer.hasArray()) {
            return this.getBest(0, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position() + n2, n3);
        }
        return this.getBest(0, byteBuffer, n2, n3);
    }

    private V getBest(int n2, byte[] byArray, int n3, int n4) {
        int n5 = n2;
        int n6 = n3 + n4;
        block0: while (n3 < n6) {
            int n7;
            int n8;
            byte by2 = (byte)(byArray[n3++] & 0x7F);
            --n4;
            if (this.isCaseInsensitive()) {
                by2 = (byte)StringUtil.lowercases[by2];
            }
            do {
                char c2;
                if ((n7 = (c2 = this._tree[n8 = 4 * n2]) - by2) != 0) continue;
                n2 = this._tree[n8 + EQ];
                if (n2 == 0) break block0;
                if (this._key[n2] == null) continue block0;
                n5 = n2;
                V v2 = this.getBest(n2, byArray, n3, n4);
                if (v2 == null) continue block0;
                return v2;
            } while ((n2 = this._tree[n8 + ArrayTernaryTrie.hilo(n7)]) != 0);
            break;
        }
        return this._value[n5];
    }

    private V getBest(int n2, ByteBuffer byteBuffer, int n3, int n4) {
        int n5 = n2;
        int n6 = n3 + byteBuffer.position();
        block0: for (int i2 = 0; i2 < n4; ++i2) {
            int n7;
            int n8;
            if (n6 + i2 >= byteBuffer.limit()) {
                return null;
            }
            byte by2 = (byte)(byteBuffer.get(n6 + i2) & 0x7F);
            if (this.isCaseInsensitive()) {
                by2 = (byte)StringUtil.lowercases[by2];
            }
            do {
                char c2;
                if ((n7 = (c2 = this._tree[n8 = 4 * n2]) - by2) != 0) continue;
                n2 = this._tree[n8 + EQ];
                if (n2 == 0) break block0;
                if (this._key[n2] == null) continue block0;
                n5 = n2;
                V v2 = this.getBest(n2, byteBuffer, n3 + i2 + 1, n4 - i2 - 1);
                if (v2 == null) continue block0;
                return v2;
            } while ((n2 = this._tree[n8 + ArrayTernaryTrie.hilo(n7)]) != 0);
            break;
        }
        return this._value[n5];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this._rows; ++i2) {
            if (this._key[i2] == null || this._value[i2] == null) continue;
            stringBuilder.append(',');
            stringBuilder.append(this._key[i2]);
            stringBuilder.append('=');
            stringBuilder.append(this._value[i2].toString());
        }
        if (stringBuilder.length() == 0) {
            return "{}";
        }
        stringBuilder.setCharAt(0, '{');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public boolean isFull() {
        return this._rows == this._key.length;
    }

    public static int hilo(int n2) {
        return 1 + (n2 | Integer.MAX_VALUE) / 0x3FFFFFFF;
    }
}

