/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.AbstractTrie;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.MathUtils;
import java.nio.ByteBuffer;

public class ArrayTrie<V>
extends AbstractTrie<V> {
    private static final int[] __lookup = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, -1, 27, 30, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 28, 29, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1};
    private final char[] _rowIndex;
    private final String[] _key;
    private final V[] _value;
    private char[][] _bigIndex;
    private char _rows;

    public ArrayTrie() {
        this(128);
    }

    public ArrayTrie(int n2) {
        super(true);
        if (n2 > 65534) {
            throw new IllegalArgumentException("Capacity " + n2 + " > " + 65534);
        }
        this._value = new Object[n2 + 1];
        this._rowIndex = new char[(n2 + 1) * 32];
        this._key = new String[n2 + 1];
    }

    @Override
    public boolean put(String string, V v2) {
        int n2 = 0;
        int n3 = string.length();
        if (n3 > 65534) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            int n4 = __lookup[c2 & 0x7F];
            if (n4 >= 0) {
                int n5 = n2 * 32 + n4;
                if ((n2 = this._rowIndex[n5]) != 0) continue;
                this._rows = (char)MathUtils.cappedAdd(this._rows, 1, this._value.length);
                if (this._rows == this._value.length) {
                    return false;
                }
                this._rowIndex[n5] = this._rows;
                n2 = this._rowIndex[n5];
                continue;
            }
            if (c2 > '\u007f') {
                throw new IllegalArgumentException("non ascii character");
            }
            if (this._bigIndex == null) {
                this._bigIndex = new char[this._value.length][];
            }
            if (n2 >= this._bigIndex.length) {
                return false;
            }
            char[] cArray = this._bigIndex[n2];
            if (cArray == null) {
                this._bigIndex[n2] = new char[128];
                cArray = this._bigIndex[n2];
            }
            if ((n2 = cArray[c2]) != 0) continue;
            this._rows = (char)MathUtils.cappedAdd(this._rows, 1, this._value.length);
            if (this._rows == this._value.length) {
                return false;
            }
            cArray[c2] = this._rows;
            n2 = cArray[c2];
        }
        if (n2 >= this._key.length) {
            this._rows = (char)this._key.length;
            return false;
        }
        this._key[n2] = v2 == null ? null : string;
        this._value[n2] = v2;
        return true;
    }

    @Override
    public V get(String string, int n2, int n3) {
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            char[] cArray;
            char c2 = string.charAt(n2 + i2);
            if (c2 > '\u007f') {
                return null;
            }
            int n5 = __lookup[c2 & 0x7F];
            if (n5 >= 0) {
                int n6 = n4 * 32 + n5;
                if ((n4 = this._rowIndex[n6]) != 0) continue;
                return null;
            }
            char[] cArray2 = cArray = this._bigIndex == null ? null : this._bigIndex[n4];
            if (cArray == null) {
                return null;
            }
            n4 = cArray[c2 & 0x7F];
            if (n4 != 0) continue;
            return null;
        }
        return this._value[n4];
    }

    @Override
    public V getBest(ByteBuffer byteBuffer, int n2, int n3) {
        if (byteBuffer.hasArray()) {
            return this.getBest(0, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position() + n2, n3);
        }
        return this.getBest(0, byteBuffer, n2, n3);
    }

    private V getBest(int n2, byte[] byArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            byte by2 = byArray[n3 + i2];
            int n6 = __lookup[by2 & 0x7F];
            if (n6 >= 0) {
                int n7 = n2 * 32 + n6;
                n5 = this._rowIndex[n7];
                if (n5 == 0) {
                    break;
                }
            } else {
                char[] cArray;
                char[] cArray2 = cArray = this._bigIndex == null ? null : this._bigIndex[n2];
                if (cArray == null || (n5 = cArray[by2]) == 0) break;
            }
            if (this._key[n2] != null) {
                V v2 = this.getBest(n5, byArray, n3 + i2 + 1, n4 - i2 - 1);
                if (v2 == null) break;
                return v2;
            }
            n2 = n5;
        }
        return this._value[n2];
    }

    private V getBest(int n2, ByteBuffer byteBuffer, int n3, int n4) {
        int n5 = byteBuffer.position() + n3;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n6;
            byte by2;
            int n7;
            if (n5 >= byteBuffer.limit()) {
                return null;
            }
            if ((n7 = __lookup[(by2 = byteBuffer.get(n5++)) & 0x7F]) >= 0) {
                int n8 = n2 * 32 + n7;
                n6 = this._rowIndex[n8];
                if (n6 == 0) {
                    break;
                }
            } else {
                char[] cArray;
                char[] cArray2 = cArray = this._bigIndex == null ? null : this._bigIndex[n2];
                if (cArray == null || (n6 = cArray[by2]) == 0) break;
                n2 = n6;
            }
            if (this._key[n2] != null) {
                V v2 = this.getBest(n6, byteBuffer, n3 + i2 + 1, n4 - i2 - 1);
                if (v2 == null) break;
                return v2;
            }
            n2 = n6;
        }
        return this._value[n2];
    }

    public String toString() {
        int n2 = this._rows;
        if (n2 == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 123;
        for (int i2 = 0; i2 <= n2; ++i2) {
            String string = this._key[i2];
            if (string == null) continue;
            stringBuilder.append((char)n3).append(string).append('=').append(this._value[i2]);
            n3 = 44;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public boolean isFull() {
        return this._rows >= this._key.length;
    }
}

