/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.mojo;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.component.annotations.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Component(role=Mojo.class, hint="gradle-enterprise-help-mojo")
public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;
    private static final String PLUGIN_HELP_PATH = "/META-INF/maven/plugin-help.xml";
    private static final int DEFAULT_LINE_LENGTH = 80;

    private Document build() throws MojoExecutionException {
        Document document;
        block11: {
            this.getLog().debug((CharSequence)"load plugin-help.xml: /META-INF/maven/plugin-help.xml");
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(PLUGIN_HELP_PATH);
            try {
                if (inputStream == null) {
                    throw new MojoExecutionException("Could not find plugin descriptor at /META-INF/maven/plugin-help.xml");
                }
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                document = documentBuilder.parse(inputStream);
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new MojoExecutionException(iOException.getMessage(), (Exception)iOException);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new MojoExecutionException(parserConfigurationException.getMessage(), (Exception)parserConfigurationException);
                }
                catch (SAXException sAXException) {
                    throw new MojoExecutionException(sAXException.getMessage(), (Exception)sAXException);
                }
            }
            inputStream.close();
        }
        return document;
    }

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        Document document = this.build();
        StringBuilder stringBuilder = new StringBuilder();
        Node node = HelpMojo.getSingleChild(document, "plugin");
        String string = HelpMojo.getValue(node, "name");
        String string2 = HelpMojo.getValue(node, "version");
        String string3 = HelpMojo.getValue(node, "groupId") + ":" + HelpMojo.getValue(node, "artifactId") + ":" + string2;
        if (HelpMojo.isNotEmpty(string) && !string.contains(string3)) {
            this.append(stringBuilder, string + " " + string2, 0);
        } else if (HelpMojo.isNotEmpty(string)) {
            this.append(stringBuilder, string, 0);
        } else {
            this.append(stringBuilder, string3, 0);
        }
        this.append(stringBuilder, HelpMojo.getValue(node, "description"), 1);
        this.append(stringBuilder, "", 0);
        String string4 = HelpMojo.getValue(node, "goalPrefix");
        Node node2 = HelpMojo.getSingleChild(node, "mojos");
        List<Node> list = HelpMojo.findNamedChild(node2, "mojo");
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(stringBuilder, "This plugin has " + list.size() + (list.size() > 1 ? " goals:" : " goal:"), 0);
            this.append(stringBuilder, "", 0);
        }
        for (Node node3 : list) {
            this.writeGoal(stringBuilder, string4, (Element)node3);
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)stringBuilder.toString());
        }
    }

    private static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    private static String getValue(Node node, String string) throws MojoExecutionException {
        return HelpMojo.getSingleChild(node, string).getTextContent();
    }

    private static Node getSingleChild(Node node, String string) throws MojoExecutionException {
        List<Node> list = HelpMojo.findNamedChild(node, string);
        if (list.isEmpty()) {
            throw new MojoExecutionException("Could not find " + string + " in plugin-help.xml");
        }
        if (list.size() > 1) {
            throw new MojoExecutionException("Multiple " + string + " in plugin-help.xml");
        }
        return list.get(0);
    }

    private static List<Node> findNamedChild(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node2 = nodeList.item(i2);
            if (!string.equals(node2.getNodeName())) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    private static Node findSingleChild(Node node, String string) throws MojoExecutionException {
        List<Node> list = HelpMojo.findNamedChild(node, string);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new MojoExecutionException("Multiple " + string + "in plugin-help.xml");
        }
        return list.get(0);
    }

    private void writeGoal(StringBuilder stringBuilder, String string, Element element) throws MojoExecutionException {
        String string2 = HelpMojo.getValue(element, "goal");
        Node node = HelpMojo.findSingleChild(element, "configuration");
        Node node2 = HelpMojo.findSingleChild(element, "description");
        if (this.goal == null || this.goal.length() <= 0 || string2.equals(this.goal)) {
            this.append(stringBuilder, string + ":" + string2, 0);
            Node node3 = HelpMojo.findSingleChild(element, "deprecated");
            if (node3 != null && HelpMojo.isNotEmpty(node3.getTextContent())) {
                this.append(stringBuilder, "Deprecated. " + node3.getTextContent(), 1);
                if (this.detail && node2 != null) {
                    this.append(stringBuilder, "", 0);
                    this.append(stringBuilder, node2.getTextContent(), 1);
                }
            } else if (node2 != null) {
                this.append(stringBuilder, node2.getTextContent(), 1);
            }
            this.append(stringBuilder, "", 0);
            if (this.detail) {
                Node node4 = HelpMojo.getSingleChild(element, "parameters");
                List<Node> list = HelpMojo.findNamedChild(node4, "parameter");
                this.append(stringBuilder, "Available parameters:", 1);
                this.append(stringBuilder, "", 0);
                for (Node node5 : list) {
                    this.writeParameter(stringBuilder, node5, node);
                }
            }
        }
    }

    private void writeParameter(StringBuilder stringBuilder, Node node, Node node2) throws MojoExecutionException {
        String string = HelpMojo.getValue(node, "name");
        String string2 = HelpMojo.getValue(node, "description");
        Element element = null;
        if (node2 != null) {
            element = (Element)HelpMojo.findSingleChild(node2, string);
        }
        String string3 = "";
        if (element != null && element.hasAttribute("default-value")) {
            string3 = " (Default: " + element.getAttribute("default-value") + ")";
        }
        this.append(stringBuilder, string + string3, 2);
        Node node3 = HelpMojo.findSingleChild(node, "deprecated");
        if (node3 != null && HelpMojo.isNotEmpty(node3.getTextContent())) {
            this.append(stringBuilder, "Deprecated. " + node3.getTextContent(), 3);
            this.append(stringBuilder, "", 0);
        }
        this.append(stringBuilder, string2, 3);
        if ("true".equals(HelpMojo.getValue(node, "required"))) {
            this.append(stringBuilder, "Required: Yes", 3);
        }
        if (element != null && HelpMojo.isNotEmpty(element.getTextContent())) {
            String string4 = HelpMojo.getPropertyFromExpression(element.getTextContent());
            this.append(stringBuilder, "User property: " + string4, 3);
        }
        this.append(stringBuilder, "", 0);
    }

    private static String repeat(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder(n2 * string.length());
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private void append(StringBuilder stringBuilder, String string, int n2) {
        for (String string2 : HelpMojo.toLines(string, n2, this.indentSize, this.lineLength)) {
            stringBuilder.append(string2).append('\n');
        }
    }

    private static List<String> toLines(String string, int n2, int n3, int n4) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = HelpMojo.repeat("\t", n2);
        for (String string3 : stringArray = string.split("(\r\n)|(\r)|(\n)")) {
            HelpMojo.toLines(arrayList, string2 + string3, n3, n4);
        }
        return arrayList;
    }

    private static void toLines(List<String> list, String string, int n2, int n3) {
        String[] stringArray;
        int n4 = HelpMojo.getIndentLevel(string);
        StringBuilder stringBuilder = new StringBuilder(256);
        for (String string2 : stringArray = string.split(" +")) {
            if (stringBuilder.length() > 0) {
                if (stringBuilder.length() + string2.length() >= n3) {
                    list.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    stringBuilder.append(HelpMojo.repeat(" ", n4 * n2));
                } else {
                    stringBuilder.append(' ');
                }
            }
            for (int i2 = 0; i2 < string2.length(); ++i2) {
                char c2 = string2.charAt(i2);
                if (c2 == '\t') {
                    stringBuilder.append(HelpMojo.repeat(" ", n2 - stringBuilder.length() % n2));
                    continue;
                }
                if (c2 == '\u00a0') {
                    stringBuilder.append(' ');
                    continue;
                }
                stringBuilder.append(c2);
            }
        }
        list.add(stringBuilder.toString());
    }

    private static int getIndentLevel(String string) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < string.length() && string.charAt(n2) == '\t'; ++n2) {
            ++n3;
        }
        for (n2 = n3 + 1; n2 <= n3 + 4 && n2 < string.length(); ++n2) {
            if (string.charAt(n2) != '\t') continue;
            ++n3;
            break;
        }
        return n3;
    }

    private static String getPropertyFromExpression(String string) {
        if (string != null && string.startsWith("${") && string.endsWith("}") && !string.substring(2).contains("${")) {
            return string.substring(2, string.length() - 1);
        }
        return null;
    }
}

