/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public class PropertyResourceBundleFallbackCharset
extends Charset {
    public PropertyResourceBundleFallbackCharset() {
        super(PropertyResourceBundleFallbackCharset.class.getCanonicalName(), new String[0]);
    }

    @Override
    public boolean contains(Charset charset) {
        return false;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new FallbackDecoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        throw new UnsupportedOperationException();
    }

    private static final class FallbackDecoder
    extends CharsetDecoder {
        private CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        private boolean utf8 = true;

        protected FallbackDecoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        static void mark(Buffer buffer) {
            buffer.mark();
        }

        static void reset(Buffer buffer) {
            buffer.reset();
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            FallbackDecoder.mark(byteBuffer);
            FallbackDecoder.mark(charBuffer);
            CoderResult coderResult = this.decoder.decode(byteBuffer, charBuffer, false);
            if (coderResult.isError() && this.utf8) {
                FallbackDecoder.reset(byteBuffer);
                FallbackDecoder.reset(charBuffer);
                this.decoder = StandardCharsets.ISO_8859_1.newDecoder();
                this.utf8 = false;
                return this.decoder.decode(byteBuffer, charBuffer, false);
            }
            return coderResult;
        }
    }
}

