/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.service;

import com.gradle.c.b;
import java.util.function.BiConsumer;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.internal.controller.service.BuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.BuildCacheServiceRole;
import org.gradle.caching.internal.controller.service.LoadTarget;
import org.gradle.caching.internal.controller.service.StoreTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseBuildCacheServiceHandle
implements BuildCacheServiceHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseBuildCacheServiceHandle.class);
    protected final BuildCacheService service;
    protected final BuildCacheServiceRole role;
    protected final boolean disableOnError;
    private final boolean pushEnabled;
    private final boolean logStackTraces;
    private boolean disabled;

    public BaseBuildCacheServiceHandle(BuildCacheService buildCacheService, boolean bl2, BuildCacheServiceRole buildCacheServiceRole, boolean bl3, boolean bl4) {
        this.role = buildCacheServiceRole;
        this.service = buildCacheService;
        this.pushEnabled = bl2;
        this.logStackTraces = bl3;
        this.disableOnError = bl4;
    }

    @b
    public BuildCacheService getService() {
        return this.service;
    }

    @Override
    public boolean canLoad() {
        return !this.disabled;
    }

    @Override
    public final void load(BuildCacheKey buildCacheKey, LoadTarget loadTarget) {
        String string = "Load entry " + buildCacheKey.getDisplayName() + " from " + this.role.getDisplayName() + " build cache";
        LOGGER.debug(string);
        try {
            this.loadInner(string, buildCacheKey, loadTarget);
        }
        catch (Exception exception) {
            this.handleFailure("load", "from", buildCacheKey, exception);
        }
    }

    protected void loadInner(String string, BuildCacheKey buildCacheKey, LoadTarget loadTarget) {
        this.service.load(buildCacheKey, loadTarget);
    }

    @Override
    public boolean canStore() {
        return this.pushEnabled && !this.disabled;
    }

    @Override
    public final void store(BuildCacheKey buildCacheKey, StoreTarget storeTarget) {
        String string = "Store entry " + buildCacheKey.getDisplayName() + " in " + this.role.getDisplayName() + " build cache";
        LOGGER.debug(string);
        try {
            this.storeInner(string, buildCacheKey, storeTarget);
        }
        catch (Exception exception) {
            this.handleFailure("store", "in", buildCacheKey, exception);
        }
    }

    protected void storeInner(String string, BuildCacheKey buildCacheKey, StoreTarget storeTarget) {
        this.service.store(buildCacheKey, storeTarget);
    }

    private void handleFailure(String string, String string2, BuildCacheKey buildCacheKey, Throwable throwable) {
        boolean bl2 = this.shouldDisableOnFailure(buildCacheKey, throwable);
        if (bl2) {
            this.disabled = true;
        }
        this.logFailure(string, string2, buildCacheKey, throwable, bl2 ? (arg_0, arg_1) -> ((Logger)LOGGER).warn(arg_0, arg_1) : (arg_0, arg_1) -> ((Logger)LOGGER).debug(arg_0, arg_1));
    }

    private void logFailure(String string, String string2, BuildCacheKey buildCacheKey, Throwable throwable, BiConsumer<String, Object[]> biConsumer) {
        if (this.logStackTraces) {
            biConsumer.accept("Could not {} entry {} {} {} build cache", new Object[]{string, buildCacheKey.getDisplayName(), string2, this.role.getDisplayName(), throwable});
        } else {
            biConsumer.accept("Could not {} entry {} {} {} build cache: {}", new Object[]{string, buildCacheKey.getDisplayName(), string2, this.role.getDisplayName(), throwable.getMessage()});
        }
    }

    protected boolean shouldDisableOnFailure(BuildCacheKey buildCacheKey, Throwable throwable) {
        return this.disableOnError;
    }

    @Override
    public void close() {
        LOGGER.debug("Closing {} build cache", (Object)this.role.getDisplayName());
        if (this.disabled) {
            LOGGER.warn("The {} build cache was disabled during the build due to errors.", (Object)this.role.getDisplayName());
        }
        try {
            this.service.close();
        }
        catch (Exception exception) {
            if (this.logStackTraces) {
                LOGGER.warn("Error closing {} build cache: ", (Object)this.role.getDisplayName(), (Object)exception);
            }
            LOGGER.warn("Error closing {} build cache: {}", (Object)this.role.getDisplayName(), (Object)exception.getMessage());
        }
    }
}

