/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.origin;

import java.time.Duration;
import java.util.Properties;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginReader;
import org.gradle.caching.internal.origin.OriginWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginMetadataFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(OriginMetadataFactory.class);
    private final String userName;
    private final String operatingSystem;
    private final String currentBuildInvocationId;
    private final PropertiesConfigurator additionalProperties;
    private final HostnameLookup hostnameLookup;

    public OriginMetadataFactory(String string, String string2, String string3, PropertiesConfigurator propertiesConfigurator, HostnameLookup hostnameLookup) {
        this.userName = string;
        this.operatingSystem = string2;
        this.additionalProperties = propertiesConfigurator;
        this.currentBuildInvocationId = string3;
        this.hostnameLookup = hostnameLookup;
    }

    public OriginWriter createWriter(CacheableEntity cacheableEntity, Duration duration) {
        return outputStream -> {
            Properties properties = new Properties();
            properties.setProperty("buildInvocationId", this.currentBuildInvocationId);
            properties.setProperty("type", cacheableEntity.getType().getCanonicalName());
            properties.setProperty("identity", cacheableEntity.getIdentity());
            properties.setProperty("creationTime", Long.toString(System.currentTimeMillis()));
            properties.setProperty("executionTime", Long.toString(duration.toMillis()));
            properties.setProperty("operatingSystem", this.operatingSystem);
            properties.setProperty("hostName", this.hostnameLookup.getHostname());
            properties.setProperty("userName", this.userName);
            this.additionalProperties.configure(properties);
            properties.store(outputStream, "Generated origin information");
        };
    }

    public OriginReader createReader(CacheableEntity cacheableEntity) {
        return inputStream -> {
            Properties properties = new Properties();
            properties.load(inputStream);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Origin for {}: {}", (Object)cacheableEntity.getDisplayName(), (Object)properties);
            }
            String string = properties.getProperty("buildInvocationId");
            String string2 = properties.getProperty("executionTime");
            if (string == null || string2 == null) {
                throw new IllegalStateException("Cached result format error, corrupted origin metadata");
            }
            Duration duration = Duration.ofMillis(Long.parseLong(string2));
            return new OriginMetadata(string, duration);
        };
    }

    public static interface HostnameLookup {
        public String getHostname();
    }

    public static interface PropertiesConfigurator {
        public void configure(Properties var1);
    }
}

