/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import java.io.Serializable;
import org.gradle.internal.hash.PrimitiveHasher;

public abstract class HashCode
implements Serializable,
Comparable<HashCode> {
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    private HashCode() {
    }

    static HashCode fromBytes(byte[] byArray, Usage usage) {
        switch (byArray.length) {
            case 16: {
                return new HashCode128(HashCode.bytesToLong(byArray, 0), HashCode.bytesToLong(byArray, 8));
            }
        }
        return new ByteArrayBackedHashCode(usage == Usage.CLONE_BYTES_IF_NECESSARY ? (byte[])byArray.clone() : byArray);
    }

    public static HashCode fromBytes(byte[] byArray) {
        if (byArray.length < 4 || byArray.length > 255) {
            throw new IllegalArgumentException(String.format("Invalid hash code length: %d bytes", byArray.length));
        }
        return HashCode.fromBytes(byArray, Usage.CLONE_BYTES_IF_NECESSARY);
    }

    public abstract int length();

    public abstract byte[] toByteArray();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public String toString() {
        StringBuilder stringBuilder = HashCode.toStringBuilder(2 * this.length(), this.bytes());
        return stringBuilder.toString();
    }

    private static StringBuilder toStringBuilder(int n2, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (byte by2 : byArray) {
            stringBuilder.append(HEX_DIGITS[by2 >> 4 & 0xF]).append(HEX_DIGITS[by2 & 0xF]);
        }
        return stringBuilder;
    }

    abstract void appendToHasher(PrimitiveHasher var1);

    abstract byte[] bytes();

    private static int compareLong(long l2, long l3) {
        return l2 < l3 ? -1 : (l2 == l3 ? 0 : 1);
    }

    private static int compareBytes(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        int n3 = byArray2.length;
        int n4 = Math.min(n2, n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = byArray[i2] - byArray2[i2];
            if (n5 == 0) continue;
            return n5;
        }
        return n2 - n3;
    }

    private static long bytesToLong(byte[] byArray, int n2) {
        return (long)byArray[n2] & 0xFFL | ((long)byArray[n2 + 1] & 0xFFL) << 8 | ((long)byArray[n2 + 2] & 0xFFL) << 16 | ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 4] & 0xFFL) << 32 | ((long)byArray[n2 + 5] & 0xFFL) << 40 | ((long)byArray[n2 + 6] & 0xFFL) << 48 | ((long)byArray[n2 + 7] & 0xFFL) << 56;
    }

    private static void longToBytes(long l2, byte[] byArray, int n2) {
        byArray[n2] = (byte)(l2 & 0xFFL);
        byArray[n2 + 1] = (byte)(l2 >>> 8 & 0xFFL);
        byArray[n2 + 2] = (byte)(l2 >>> 16 & 0xFFL);
        byArray[n2 + 3] = (byte)(l2 >>> 24 & 0xFFL);
        byArray[n2 + 4] = (byte)(l2 >>> 32 & 0xFFL);
        byArray[n2 + 5] = (byte)(l2 >>> 40 & 0xFFL);
        byArray[n2 + 6] = (byte)(l2 >>> 48 & 0xFFL);
        byArray[n2 + 7] = (byte)(l2 >>> 56 & 0xFFL);
    }

    private static class ByteArrayBackedHashCode
    extends HashCode {
        private final byte[] bytes;

        public ByteArrayBackedHashCode(byte[] byArray) {
            this.bytes = byArray;
        }

        @Override
        public int length() {
            return this.bytes.length;
        }

        @Override
        byte[] bytes() {
            return this.bytes;
        }

        @Override
        public byte[] toByteArray() {
            return (byte[])this.bytes.clone();
        }

        @Override
        void appendToHasher(PrimitiveHasher primitiveHasher) {
            primitiveHasher.putBytes(this.bytes);
        }

        @Override
        public int hashCode() {
            return this.bytes[0] & 0xFF | (this.bytes[1] & 0xFF) << 8 | (this.bytes[2] & 0xFF) << 16 | (this.bytes[3] & 0xFF) << 24;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || object.getClass() != ByteArrayBackedHashCode.class) {
                return false;
            }
            byte[] byArray = ((ByteArrayBackedHashCode)object).bytes;
            byte[] byArray2 = this.bytes;
            int n2 = byArray2.length;
            if (byArray.length != n2) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (byArray2[i2] == byArray[i2]) continue;
                return false;
            }
            return true;
        }

        @Override
        public int compareTo(HashCode hashCode) {
            return HashCode.compareBytes(this.bytes, hashCode.bytes());
        }
    }

    static class HashCode128
    extends HashCode {
        private final long bits1;
        private final long bits2;

        public HashCode128(long l2, long l3) {
            this.bits1 = l2;
            this.bits2 = l3;
        }

        @Override
        public int length() {
            return 16;
        }

        @Override
        byte[] bytes() {
            return this.toByteArray();
        }

        @Override
        public byte[] toByteArray() {
            byte[] byArray = new byte[16];
            HashCode.longToBytes(this.bits1, byArray, 0);
            HashCode.longToBytes(this.bits2, byArray, 8);
            return byArray;
        }

        @Override
        void appendToHasher(PrimitiveHasher primitiveHasher) {
            primitiveHasher.putLong(this.bits1);
            primitiveHasher.putLong(this.bits2);
        }

        @Override
        public int hashCode() {
            return (int)this.bits1;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || object.getClass() != HashCode128.class) {
                return false;
            }
            HashCode128 hashCode128 = (HashCode128)object;
            return this.bits1 == hashCode128.bits1 && this.bits2 == hashCode128.bits2;
        }

        @Override
        public int compareTo(HashCode hashCode) {
            if (hashCode.getClass() != HashCode128.class) {
                return HashCode.compareBytes(this.bytes(), hashCode.bytes());
            }
            HashCode128 hashCode128 = (HashCode128)hashCode;
            int n2 = HashCode.compareLong(this.bits1, hashCode128.bits1);
            if (n2 == 0) {
                n2 = HashCode.compareLong(this.bits2, hashCode128.bits2);
            }
            return n2;
        }
    }

    static enum Usage {
        CLONE_BYTES_IF_NECESSARY,
        SAFE_TO_REUSE_BYTES;

    }
}

