/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.DirectorySnapshotBuilder;
import org.gradle.internal.snapshot.FileSystemLeafSnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.RootTrackingFileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class FilteredTrackingMerkleDirectorySnapshotBuilder
implements DirectorySnapshotBuilder {
    private final Deque<Boolean> isCurrentLevelUnfiltered = new ArrayDeque<Boolean>();
    private final Consumer<FileSystemLocationSnapshot> unfilteredSnapshotConsumer;
    private final DirectorySnapshotBuilder delegate = MerkleDirectorySnapshotBuilder.sortingRequired();

    public static FilteredTrackingMerkleDirectorySnapshotBuilder sortingRequired(Consumer<FileSystemLocationSnapshot> consumer) {
        return new FilteredTrackingMerkleDirectorySnapshotBuilder(consumer);
    }

    private FilteredTrackingMerkleDirectorySnapshotBuilder(Consumer<FileSystemLocationSnapshot> consumer) {
        this.unfilteredSnapshotConsumer = consumer;
        this.isCurrentLevelUnfiltered.addLast(true);
    }

    @Override
    public void enterDirectory(FileMetadata.AccessType accessType, String string, String string2, DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy emptyDirectoryHandlingStrategy) {
        this.isCurrentLevelUnfiltered.addLast(true);
        this.delegate.enterDirectory(accessType, string, string2, emptyDirectoryHandlingStrategy);
    }

    @Override
    public void visitLeafElement(FileSystemLeafSnapshot fileSystemLeafSnapshot) {
        this.delegate.visitLeafElement(fileSystemLeafSnapshot);
    }

    @Override
    public void visitDirectory(DirectorySnapshot directorySnapshot) {
        this.delegate.visitDirectory(directorySnapshot);
    }

    public void markCurrentLevelAsFiltered() {
        this.isCurrentLevelUnfiltered.removeLast();
        this.isCurrentLevelUnfiltered.addLast(false);
    }

    public boolean isCurrentLevelUnfiltered() {
        return this.isCurrentLevelUnfiltered.getLast();
    }

    @Override
    public FileSystemLocationSnapshot leaveDirectory() {
        FileSystemLocationSnapshot fileSystemLocationSnapshot = this.delegate.leaveDirectory();
        boolean bl2 = this.isCurrentLevelUnfiltered.removeLast();
        this.isCurrentLevelUnfiltered.addLast(this.isCurrentLevelUnfiltered.removeLast() != false && bl2);
        if (!bl2 && fileSystemLocationSnapshot != null) {
            fileSystemLocationSnapshot.accept(new RootTrackingFileSystemSnapshotHierarchyVisitor(){

                @Override
                public SnapshotVisitResult visitEntry(FileSystemLocationSnapshot fileSystemLocationSnapshot, boolean bl2) {
                    if (bl2) {
                        return SnapshotVisitResult.CONTINUE;
                    }
                    FilteredTrackingMerkleDirectorySnapshotBuilder.this.unfilteredSnapshotConsumer.accept(fileSystemLocationSnapshot);
                    return SnapshotVisitResult.SKIP_SUBTREE;
                }
            });
        }
        return fileSystemLocationSnapshot;
    }

    @Override
    public FileSystemLocationSnapshot getResult() {
        return this.delegate.getResult();
    }
}

