/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.groupon.metrics.example;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.groupon.metrics.SparkGauge;
import org.apache.spark.groupon.metrics.SparkHistogram;
import org.apache.spark.groupon.metrics.UserMetricsSystem$;
import org.apache.spark.scheduler.TaskInfo;
import org.apache.spark.streaming.scheduler.StreamingListener;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchSubmitted;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverError;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStopped;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001=\u0011\u0001d\u0015;sK\u0006l\u0017N\\4NKR\u0014\u0018nY:MSN$XM\\3s\u0015\t\u0019A!A\u0004fq\u0006l\u0007\u000f\\3\u000b\u0005\u00151\u0011aB7fiJL7m\u001d\u0006\u0003\u000f!\tqa\u001a:pkB|gN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003H\u0007\u00021)\u0011\u0011DG\u0001\ng\u000eDW\rZ;mKJT!a\u0007\u0005\u0002\u0013M$(/Z1nS:<\u0017BA\u000f\u0019\u0005E\u0019FO]3b[&tw\rT5ti\u0016tWM\u001d\u0005\u0006?\u0001!\t\u0001I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"A\t\u0001\u000e\u0003\tAq\u0001\n\u0001C\u0002\u0013\u0005Q%A\u0004sk:$\u0018.\\3\u0016\u0003\u0019\u0002\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\t1\fgn\u001a\u0006\u0002W\u0005!!.\u0019<b\u0013\ti\u0003FA\u0004Sk:$\u0018.\\3\t\r=\u0002\u0001\u0015!\u0003'\u0003!\u0011XO\u001c;j[\u0016\u0004\u0003bB\u0019\u0001\u0005\u0004%\tAM\u0001\b_N\u001cF/\u0019;t+\u0005\u0019\u0004C\u0001\u001b<\u001b\u0005)$B\u0001\u001c8\u0003)i\u0017M\\1hK6,g\u000e\u001e\u0006\u0003qe\n1a];o\u0015\u0005Q\u0014aA2p[&\u0011A(\u000e\u0002\u0016\u001fB,'/\u0019;j]\u001e\u001c\u0016p\u001d;f[6C&)Z1o\u0011\u0019q\u0004\u0001)A\u0005g\u0005Aqn]*uCR\u001c\b\u0005\u0003\u0005A\u0001!\u0015\r\u0011\"\u0001B\u0003A!x\u000e^1m\u001b\u0016lwN]=HCV<W-F\u0001C!\t\u0019E)D\u0001\u0005\u0013\t)EA\u0001\u0006Ta\u0006\u00148nR1vO\u0016D\u0001b\u0012\u0001\t\u0002\u0003\u0006KAQ\u0001\u0012i>$\u0018\r\\'f[>\u0014\u0018pR1vO\u0016\u0004\u0003\u0002C%\u0001\u0011\u000b\u0007I\u0011A!\u0002\u001d5\f\u00070T3n_JLx)Y;hK\"A1\n\u0001E\u0001B\u0003&!)A\bnCblU-\\8ss\u001e\u000bWoZ3!\u0011!i\u0005\u0001#b\u0001\n\u0003\t\u0015a\u00044sK\u0016lU-\\8ss\u001e\u000bWoZ3\t\u0011=\u0003\u0001\u0012!Q!\n\t\u000b\u0001C\u001a:fK6+Wn\u001c:z\u000f\u0006,x-\u001a\u0011\t\u0011E\u0003\u0001R1A\u0005\u0002\u0005\u000bq\"^:fI6+Wn\u001c:z\u000f\u0006,x-\u001a\u0005\t'\u0002A\t\u0011)Q\u0005\u0005\u0006\u0001Ro]3e\u001b\u0016lwN]=HCV<W\r\t\u0005\t+\u0002A)\u0019!C\u0001\u0003\u0006a1\r];M_\u0006$w)Y;hK\"Aq\u000b\u0001E\u0001B\u0003&!)A\u0007daVdu.\u00193HCV<W\r\t\u0005\t3\u0002A)\u0019!C\u00015\u0006\u0019Ro]3e\u001b\u0016lwN]=ISN$xn\u001a:b[V\t1\f\u0005\u0002D9&\u0011Q\f\u0002\u0002\u000f'B\f'o\u001b%jgR|wM]1n\u0011!y\u0006\u0001#A!B\u0013Y\u0016\u0001F;tK\u0012lU-\\8ss\"K7\u000f^8he\u0006l\u0007\u0005\u0003\u0005b\u0001!\u0015\r\u0011\"\u0001[\u0003A\u0019\u0007/\u001e'pC\u0012D\u0015n\u001d;pOJ\fW\u000e\u0003\u0005d\u0001!\u0005\t\u0015)\u0003\\\u0003E\u0019\u0007/\u001e'pC\u0012D\u0015n\u001d;pOJ\fW\u000e\t\u0005\u0006K\u0002!\tEZ\u0001\u0011_:\u0014\u0015\r^2i'V\u0014W.\u001b;uK\u0012$\"a\u001a6\u0011\u0005EA\u0017BA5\u0013\u0005\u0011)f.\u001b;\t\u000b-$\u0007\u0019\u00017\u0002\u001d\t\fGo\u00195Tk\nl\u0017\u000e\u001e;fIB\u0011q#\\\u0005\u0003]b\u0011qd\u0015;sK\u0006l\u0017N\\4MSN$XM\\3s\u0005\u0006$8\r[*vE6LG\u000f^3e\u0011\u0015\u0001\b\u0001\"\u0001r\u0003E9W\r^*dQ\u0016$W\u000f\\3s\t\u0016d\u0017-\u001f\u000b\u0006eVd\u0018q\u0001\t\u0003#ML!\u0001\u001e\n\u0003\t1{gn\u001a\u0005\u0006m>\u0004\ra^\u0001\u0005S:4w\u000e\u0005\u0002yu6\t\u0011P\u0003\u0002\u001a\u0011%\u001110\u001f\u0002\t)\u0006\u001c8.\u00138g_\")Qa\u001ca\u0001{B\u0019a0a\u0001\u000e\u0003}T1!!\u0001\t\u0003!)\u00070Z2vi>\u0014\u0018bAA\u0003\u007f\nYA+Y:l\u001b\u0016$(/[2t\u0011\u0019\tIa\u001ca\u0001e\u0006Y1-\u001e:sK:$H+[7f\u0001")
public class StreamingMetricsListener
implements StreamingListener {
    private final Runtime runtime;
    private final OperatingSystemMXBean osStats;
    private SparkGauge totalMemoryGauge;
    private SparkGauge maxMemoryGauge;
    private SparkGauge freeMemoryGauge;
    private SparkGauge usedMemoryGauge;
    private SparkGauge cpuLoadGauge;
    private SparkHistogram usedMemoryHistogram;
    private SparkHistogram cpuLoadHistogram;
    private volatile byte bitmap$0;

    private SparkGauge totalMemoryGauge$lzycompute() {
        StreamingMetricsListener streamingMetricsListener = this;
        synchronized (streamingMetricsListener) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.totalMemoryGauge = UserMetricsSystem$.MODULE$.gauge("MemoryTotal");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.totalMemoryGauge;
        }
    }

    private SparkGauge maxMemoryGauge$lzycompute() {
        StreamingMetricsListener streamingMetricsListener = this;
        synchronized (streamingMetricsListener) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.maxMemoryGauge = UserMetricsSystem$.MODULE$.gauge("MemoryMax");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.maxMemoryGauge;
        }
    }

    private SparkGauge freeMemoryGauge$lzycompute() {
        StreamingMetricsListener streamingMetricsListener = this;
        synchronized (streamingMetricsListener) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.freeMemoryGauge = UserMetricsSystem$.MODULE$.gauge("MemoryFree");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.freeMemoryGauge;
        }
    }

    private SparkGauge usedMemoryGauge$lzycompute() {
        StreamingMetricsListener streamingMetricsListener = this;
        synchronized (streamingMetricsListener) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.usedMemoryGauge = UserMetricsSystem$.MODULE$.gauge("MemoryUsedPercent");
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.usedMemoryGauge;
        }
    }

    private SparkGauge cpuLoadGauge$lzycompute() {
        StreamingMetricsListener streamingMetricsListener = this;
        synchronized (streamingMetricsListener) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.cpuLoadGauge = UserMetricsSystem$.MODULE$.gauge("CPULoadPercent");
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.cpuLoadGauge;
        }
    }

    private SparkHistogram usedMemoryHistogram$lzycompute() {
        StreamingMetricsListener streamingMetricsListener = this;
        synchronized (streamingMetricsListener) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.usedMemoryHistogram = UserMetricsSystem$.MODULE$.histogram("MemoryUsedHistogram", UserMetricsSystem$.MODULE$.histogram$default$2());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
            return this.usedMemoryHistogram;
        }
    }

    private SparkHistogram cpuLoadHistogram$lzycompute() {
        StreamingMetricsListener streamingMetricsListener = this;
        synchronized (streamingMetricsListener) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.cpuLoadHistogram = UserMetricsSystem$.MODULE$.histogram("CPULoadHistogram", UserMetricsSystem$.MODULE$.histogram$default$2());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
            return this.cpuLoadHistogram;
        }
    }

    public void onReceiverStarted(StreamingListenerReceiverStarted receiverStarted) {
        StreamingListener.class.onReceiverStarted((StreamingListener)this, (StreamingListenerReceiverStarted)receiverStarted);
    }

    public void onReceiverError(StreamingListenerReceiverError receiverError) {
        StreamingListener.class.onReceiverError((StreamingListener)this, (StreamingListenerReceiverError)receiverError);
    }

    public void onReceiverStopped(StreamingListenerReceiverStopped receiverStopped) {
        StreamingListener.class.onReceiverStopped((StreamingListener)this, (StreamingListenerReceiverStopped)receiverStopped);
    }

    public void onBatchStarted(StreamingListenerBatchStarted batchStarted) {
        StreamingListener.class.onBatchStarted((StreamingListener)this, (StreamingListenerBatchStarted)batchStarted);
    }

    public void onBatchCompleted(StreamingListenerBatchCompleted batchCompleted) {
        StreamingListener.class.onBatchCompleted((StreamingListener)this, (StreamingListenerBatchCompleted)batchCompleted);
    }

    public void onOutputOperationStarted(StreamingListenerOutputOperationStarted outputOperationStarted) {
        StreamingListener.class.onOutputOperationStarted((StreamingListener)this, (StreamingListenerOutputOperationStarted)outputOperationStarted);
    }

    public void onOutputOperationCompleted(StreamingListenerOutputOperationCompleted outputOperationCompleted) {
        StreamingListener.class.onOutputOperationCompleted((StreamingListener)this, (StreamingListenerOutputOperationCompleted)outputOperationCompleted);
    }

    public Runtime runtime() {
        return this.runtime;
    }

    public OperatingSystemMXBean osStats() {
        return this.osStats;
    }

    public SparkGauge totalMemoryGauge() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.totalMemoryGauge$lzycompute() : this.totalMemoryGauge;
    }

    public SparkGauge maxMemoryGauge() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.maxMemoryGauge$lzycompute() : this.maxMemoryGauge;
    }

    public SparkGauge freeMemoryGauge() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.freeMemoryGauge$lzycompute() : this.freeMemoryGauge;
    }

    public SparkGauge usedMemoryGauge() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.usedMemoryGauge$lzycompute() : this.usedMemoryGauge;
    }

    public SparkGauge cpuLoadGauge() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.cpuLoadGauge$lzycompute() : this.cpuLoadGauge;
    }

    public SparkHistogram usedMemoryHistogram() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.usedMemoryHistogram$lzycompute() : this.usedMemoryHistogram;
    }

    public SparkHistogram cpuLoadHistogram() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.cpuLoadHistogram$lzycompute() : this.cpuLoadHistogram;
    }

    public void onBatchSubmitted(StreamingListenerBatchSubmitted batchSubmitted) {
        long free = this.runtime().freeMemory();
        long total = this.runtime().totalMemory();
        long max = this.runtime().maxMemory();
        float usedMemPercent = (float)(total - free) / (float)total;
        double cpuLoadPercent = this.osStats().getProcessCpuLoad();
        this.totalMemoryGauge().set(BoxesRunTime.boxToLong((long)(total / 1024L)));
        this.maxMemoryGauge().set(BoxesRunTime.boxToLong((long)(max / 1024L)));
        this.freeMemoryGauge().set(BoxesRunTime.boxToLong((long)(free / 1024L)));
        this.usedMemoryGauge().set(BoxesRunTime.boxToFloat((float)usedMemPercent));
        this.usedMemoryHistogram().update((int)(usedMemPercent * (float)100));
        this.cpuLoadGauge().set(BoxesRunTime.boxToDouble((double)cpuLoadPercent));
        this.cpuLoadHistogram().update((int)(cpuLoadPercent * (double)100));
    }

    public long getSchedulerDelay(TaskInfo info, TaskMetrics metrics, long currentTime) {
        long totalExecutionTime = info.finishTime() - info.launchTime();
        long executorOverhead = metrics.executorDeserializeTime() + metrics.resultSerializationTime();
        long gettingResultTime = info.finishTime() - info.gettingResultTime();
        return package$.MODULE$.max(0L, totalExecutionTime - metrics.executorRunTime() - executorOverhead - gettingResultTime);
    }

    public StreamingMetricsListener() {
        StreamingListener.class.$init$((StreamingListener)this);
        this.runtime = Runtime.getRuntime();
        this.osStats = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    }
}

