/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueShort
extends Value {
    static final int PRECISION = 5;
    static final int DISPLAY_SIZE = 6;
    private final short value;

    private ValueShort(short s) {
        this.value = s;
    }

    @Override
    public Value add(Value value) {
        ValueShort valueShort = (ValueShort)value;
        return ValueShort.checkRange(this.value + valueShort.value);
    }

    private static ValueShort checkRange(int n) {
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw DbException.get(22003, Integer.toString(n));
        }
        return ValueShort.get((short)n);
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.value);
    }

    @Override
    public Value negate() {
        return ValueShort.checkRange(-this.value);
    }

    @Override
    public Value subtract(Value value) {
        ValueShort valueShort = (ValueShort)value;
        return ValueShort.checkRange(this.value - valueShort.value);
    }

    @Override
    public Value multiply(Value value) {
        ValueShort valueShort = (ValueShort)value;
        return ValueShort.checkRange(this.value * valueShort.value);
    }

    @Override
    public Value divide(Value value) {
        ValueShort valueShort = (ValueShort)value;
        if (valueShort.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueShort.get((short)(this.value / valueShort.value));
    }

    @Override
    public Value modulus(Value value) {
        ValueShort valueShort = (ValueShort)value;
        if (valueShort.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueShort.get((short)(this.value % valueShort.value));
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public short getShort() {
        return this.value;
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueShort valueShort = (ValueShort)value;
        return MathUtils.compareInt(this.value, valueShort.value);
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public long getPrecision() {
        return 5L;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setShort(n, this.value);
    }

    public static ValueShort get(short s) {
        return (ValueShort)Value.cache(new ValueShort(s));
    }

    @Override
    public int getDisplaySize() {
        return 6;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueShort && this.value == ((ValueShort)object).value;
    }
}

