/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.retirejs.repo;

import com.esotericsoftware.minlog.Log;
import com.h3xstream.retirejs.repo.JsLibrary;
import com.h3xstream.retirejs.repo.JsLibraryResult;
import com.h3xstream.retirejs.repo.JsVulnerability;
import com.h3xstream.retirejs.util.CompareVersionUtil;
import com.h3xstream.retirejs.util.RegexUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class VulnerabilitiesRepository {
    protected List<JsLibrary> jsLibrares = new ArrayList<JsLibrary>();

    public void addLibrary(JsLibrary lib) {
        this.jsLibrares.add(lib);
    }

    public List<JsLibraryResult> findByUri(String uri) {
        Log.debug((String)("Analysing URI: \"" + uri + "\""));
        ArrayList<JsLibraryResult> res = new ArrayList<JsLibraryResult>();
        long before = System.currentTimeMillis();
        block0: for (JsLibrary lib : this.jsLibrares) {
            if (lib.getUris() == null) continue;
            for (String uriRegex : lib.getUris()) {
                Pattern p = Pattern.compile(uriRegex);
                String version = RegexUtil.simpleMatch(p, uri);
                if (version == null) continue;
                Log.debug((String)("Pattern match \"" + uriRegex + "\" !"));
                Log.debug((String)("Identify the library " + lib.getName() + " (version:" + version + ")"));
                this.findVersionVulnerable(lib, version, res, uriRegex, null);
                continue block0;
            }
        }
        long delta = System.currentTimeMillis() - before;
        Log.debug((String)("It took ~" + (int)((double)delta / 1000.0) + " sec. (" + delta + " ms) to scan"));
        return res;
    }

    public List<JsLibraryResult> findByFilename(String filename) {
        Log.debug((String)("Analysing filename: \"" + filename + "\""));
        long before = System.currentTimeMillis();
        ArrayList<JsLibraryResult> res = new ArrayList<JsLibraryResult>();
        block0: for (JsLibrary lib : this.jsLibrares) {
            if (lib.getFilename() == null) continue;
            for (String filenameRegex : lib.getFilename()) {
                Pattern p = Pattern.compile(filenameRegex);
                String version = RegexUtil.simpleMatch(p, filename);
                if (version == null) continue;
                Log.debug((String)("Pattern match \"" + filenameRegex + "\" !"));
                Log.debug((String)("Identify the library " + lib.getName() + " (version:" + version + ")"));
                this.findVersionVulnerable(lib, version, res, filenameRegex, null);
                continue block0;
            }
        }
        long delta = System.currentTimeMillis() - before;
        Log.debug((String)("It took ~" + (int)((double)delta / 1000.0) + " sec. (" + delta + " ms) to scan"));
        return res;
    }

    public List<JsLibraryResult> findByFileContent(String scriptContent) {
        String scriptStart = scriptContent.substring(0, Math.min(20, scriptContent.length())).replace("\n", "");
        Log.debug((String)("Analysing the content: \"" + scriptStart + "[..]\""));
        long before = System.currentTimeMillis();
        ArrayList<JsLibraryResult> res = new ArrayList<JsLibraryResult>();
        block0: for (JsLibrary lib : this.jsLibrares) {
            if (lib.getFileContents() == null) continue;
            for (String contentRegex : lib.getFileContents()) {
                String version = this.extractVersion(scriptContent, contentRegex);
                if (version == null) continue;
                Log.debug((String)("Pattern match \"" + contentRegex + "\" !"));
                Log.debug((String)("Identify the library " + lib.getName() + " (version:" + version + ")"));
                this.findVersionVulnerable(lib, version, res, null, contentRegex);
                continue block0;
            }
        }
        long delta = System.currentTimeMillis() - before;
        Log.debug((String)("It took ~" + (int)((double)delta / 1000.0) + " sec. (" + delta + " ms) to scan"));
        return res;
    }

    private String extractVersion(String scriptContent, String contentRegex) {
        try {
            Pattern p = Pattern.compile(contentRegex);
            String version = RegexUtil.simpleMatch(p, scriptContent);
            return version;
        }
        catch (Exception any) {
            Log.warn((String)String.format("Unable to extract version using regex '%s'", contentRegex));
            return null;
        }
    }

    public List<JsLibraryResult> findByHash(String hash) {
        ArrayList<JsLibraryResult> res = new ArrayList<JsLibraryResult>();
        for (JsLibrary lib : this.jsLibrares) {
            String version;
            if (lib.getHashes() == null || (version = lib.getHashes().get(hash)) == null) continue;
            Log.debug((String)("Hash found \"" + hash + "\" !"));
            Log.debug((String)("Identify the library " + lib.getName() + " (version:" + version + ")"));
            this.findVersionVulnerable(lib, version, res, null, null);
            return res;
        }
        return res;
    }

    public List<JsLibraryResult> findByFunction(String scriptContent) {
        return new ArrayList<JsLibraryResult>();
    }

    private void findVersionVulnerable(JsLibrary lib, String version, List<JsLibraryResult> resultsFound, String regexRequest, String regexResponse) {
        for (JsVulnerability vuln : lib.getVulnerabilities()) {
            if (!CompareVersionUtil.isUnder(version, vuln.getBelow()) || vuln.getAtOrAbove() != null && !CompareVersionUtil.atOrAbove(version, vuln.getAtOrAbove())) continue;
            Log.info((String)String.format("Vulnerability found: %s below %s", lib.getName(), vuln.getBelow()));
            resultsFound.add(new JsLibraryResult(lib, vuln, version, regexRequest, regexResponse));
        }
    }
}

