/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.retirejs.vuln;

import com.esotericsoftware.minlog.Log;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.h3xstream.retirejs.vuln.DescriptionModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;

public class TemplateBuilder {
    public static String buildDescription(String templateFile, String detectedLibrary, String detectedVersion, List<String> urls, String aboveVersion, String belowVersion) {
        InputStream tpl = TemplateBuilder.class.getResourceAsStream(templateFile);
        if (tpl == null) {
            return TemplateBuilder.errorResult(null);
        }
        try {
            DescriptionModel model = new DescriptionModel();
            model.setDetectedLibrary(detectedLibrary);
            model.setDetectedVersion(detectedVersion);
            model.getLinks().addAll(urls);
            model.setAboveVersion(aboveVersion == null || "".equals(aboveVersion) ? "*" : aboveVersion);
            model.setBelowVersion(belowVersion);
            DefaultMustacheFactory mf = new DefaultMustacheFactory();
            Mustache mustache = mf.compile((Reader)new InputStreamReader(tpl), "");
            ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
            mustache.execute((Writer)new PrintWriter(outBuffer), (Object)model).flush();
            return outBuffer.toString();
        }
        catch (IOException e) {
            return TemplateBuilder.errorResult(e);
        }
    }

    private static String errorResult(Exception e) {
        Log.error((String)("Unable to generate the description." + (e != null ? e.getMessage() : "")));
        return "An error occurs while loading description template.";
    }
}

