/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.plan;

import com.hazelcast.org.apache.calcite.DataContext;
import com.hazelcast.org.apache.calcite.adapter.java.JavaTypeFactory;
import com.hazelcast.org.apache.calcite.linq4j.QueryProvider;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalFilter;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rex.RexCall;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.schema.SchemaPlus;
import com.hazelcast.org.apache.calcite.util.NlsString;
import com.hazelcast.org.apache.calcite.util.Pair;
import com.hazelcast.org.apache.calcite.util.trace.CalciteLogger;
import com.hazelcast.org.slf4j.LoggerFactory;
import java.math.BigDecimal;
import java.util.List;

public class VisitorDataContext
implements DataContext {
    private static final CalciteLogger LOGGER = new CalciteLogger(LoggerFactory.getLogger(VisitorDataContext.class.getName()));
    private final Object[] values;

    public VisitorDataContext(Object[] values) {
        this.values = values;
    }

    @Override
    public SchemaPlus getRootSchema() {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public JavaTypeFactory getTypeFactory() {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public QueryProvider getQueryProvider() {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public Object get(String name) {
        if (name.equals("inputRecord")) {
            return this.values;
        }
        return null;
    }

    public static DataContext of(RelNode targetRel, LogicalFilter queryRel) {
        return VisitorDataContext.of(targetRel.getRowType(), queryRel.getCondition());
    }

    public static DataContext of(RelDataType rowType, RexNode rex) {
        RexNode secondOperand;
        int size = rowType.getFieldList().size();
        Object[] values = new Object[size];
        List<RexNode> operands = ((RexCall)rex).getOperands();
        RexNode firstOperand = operands.get(0);
        Pair<Integer, ?> value = VisitorDataContext.getValue(firstOperand, secondOperand = operands.get(1));
        if (value != null) {
            int index = value.getKey();
            values[index] = value.getValue();
            return new VisitorDataContext(values);
        }
        return null;
    }

    public static DataContext of(RelDataType rowType, List<Pair<RexInputRef, RexNode>> usageList) {
        int size = rowType.getFieldList().size();
        Object[] values = new Object[size];
        for (Pair<RexInputRef, RexNode> elem : usageList) {
            Pair<Integer, ?> value = VisitorDataContext.getValue(elem.getKey(), elem.getValue());
            if (value == null) {
                LOGGER.warn("{} is not handled for {} for checking implication", (Object)elem.getKey(), (Object)elem.getValue());
                return null;
            }
            int index = value.getKey();
            values[index] = value.getValue();
        }
        return new VisitorDataContext(values);
    }

    public static Pair<Integer, ?> getValue(RexNode inputRef, RexNode literal) {
        inputRef = inputRef == null ? null : RexUtil.removeCast(inputRef);
        RexNode rexNode = literal = literal == null ? null : RexUtil.removeCast(literal);
        if (inputRef instanceof RexInputRef && literal instanceof RexLiteral) {
            int index = ((RexInputRef)inputRef).getIndex();
            RexLiteral rexLiteral = (RexLiteral)literal;
            RelDataType type = inputRef.getType();
            if (type.getSqlTypeName() == null) {
                LOGGER.warn("{} returned null SqlTypeName", inputRef.toString());
                return null;
            }
            switch (type.getSqlTypeName()) {
                case INTEGER: {
                    return Pair.of(index, rexLiteral.getValueAs(Integer.class));
                }
                case DOUBLE: {
                    return Pair.of(index, rexLiteral.getValueAs(Double.class));
                }
                case REAL: {
                    return Pair.of(index, rexLiteral.getValueAs(Float.class));
                }
                case BIGINT: {
                    return Pair.of(index, rexLiteral.getValueAs(Long.class));
                }
                case SMALLINT: {
                    return Pair.of(index, rexLiteral.getValueAs(Short.class));
                }
                case TINYINT: {
                    return Pair.of(index, rexLiteral.getValueAs(Byte.class));
                }
                case DECIMAL: {
                    return Pair.of(index, rexLiteral.getValueAs(BigDecimal.class));
                }
                case DATE: 
                case TIME: {
                    return Pair.of(index, rexLiteral.getValueAs(Integer.class));
                }
                case TIMESTAMP: {
                    return Pair.of(index, rexLiteral.getValueAs(Long.class));
                }
                case CHAR: {
                    return Pair.of(index, rexLiteral.getValueAs(Character.class));
                }
                case VARCHAR: {
                    return Pair.of(index, rexLiteral.getValueAs(String.class));
                }
            }
            LOGGER.warn("{} for value of class {} is being handled in default way", (Object)type.getSqlTypeName(), (Object)rexLiteral.getValue().getClass());
            if (rexLiteral.getValue() instanceof NlsString) {
                return Pair.of(index, ((NlsString)rexLiteral.getValue()).getValue());
            }
            return Pair.of(index, rexLiteral.getValue());
        }
        return null;
    }
}

