/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.plan.volcano;

import com.hazelcast.org.apache.calcite.linq4j.Linq4j;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.org.apache.calcite.plan.RelOptListener;
import com.hazelcast.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.plan.volcano.AbstractConverter;
import com.hazelcast.org.apache.calcite.plan.volcano.OptimizeTask;
import com.hazelcast.org.apache.calcite.plan.volcano.RelSet;
import com.hazelcast.org.apache.calcite.plan.volcano.VolcanoPlanner;
import com.hazelcast.org.apache.calcite.rel.AbstractRelNode;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.RelWriter;
import com.hazelcast.org.apache.calcite.rel.core.CorrelationId;
import com.hazelcast.org.apache.calcite.rel.externalize.RelWriterImpl;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlExplainLevel;
import com.hazelcast.org.apache.calcite.util.Litmus;
import com.hazelcast.org.apache.calcite.util.Pair;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.apache.calcite.util.trace.CalciteTrace;
import com.hazelcast.org.slf4j.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;

public class RelSubset
extends AbstractRelNode {
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    private static final int DELIVERED = 1;
    private static final int REQUIRED = 2;
    OptimizeTask.State taskState;
    RelOptCost bestCost;
    final RelSet set;
    RelNode best;
    long timestamp;
    private int state = 0;
    boolean triggerRule = false;

    RelSubset(RelOptCluster cluster, RelSet set, RelTraitSet traits) {
        super(cluster, traits);
        this.set = set;
        assert (traits.allSimple());
        this.computeBestCost(cluster.getPlanner());
        this.recomputeDigest();
    }

    private void computeBestCost(RelOptPlanner planner) {
        this.bestCost = planner.getCostFactory().makeInfiniteCost();
        RelMetadataQuery mq = this.getCluster().getMetadataQuery();
        for (RelNode rel : this.getRels()) {
            RelOptCost cost = planner.getCost(rel, mq);
            if (!cost.isLt(this.bestCost)) continue;
            this.bestCost = cost;
            this.best = rel;
        }
    }

    void setDelivered() {
        this.triggerRule = !this.isDelivered();
        this.state |= 1;
    }

    void setRequired() {
        this.triggerRule = false;
        this.state |= 2;
    }

    @API(since="1.23", status=API.Status.EXPERIMENTAL)
    public boolean isDelivered() {
        return (this.state & 1) == 1;
    }

    @API(since="1.23", status=API.Status.EXPERIMENTAL)
    public boolean isRequired() {
        return (this.state & 2) == 2;
    }

    public RelNode getBest() {
        return this.best;
    }

    public RelNode getOriginal() {
        return this.set.rel;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        if (inputs.isEmpty()) {
            RelTraitSet traitSet1 = traitSet.simplify();
            if (traitSet1.equals(this.traitSet)) {
                return this;
            }
            return this.set.getOrCreateSubset(this.getCluster(), traitSet1);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeZeroCost();
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        if (this.best != null) {
            return mq.getRowCount(this.best);
        }
        return mq.getRowCount(this.set.rel);
    }

    @Override
    public void explain(RelWriter pw) {
        pw.item("subset", this.toString());
        AbstractRelNode input = (AbstractRelNode)Util.first(this.getBest(), this.getOriginal());
        if (input == null) {
            return;
        }
        input.explainTerms(pw);
        pw.done(input);
    }

    @Override
    protected String computeDigest() {
        StringBuilder digest = new StringBuilder("Subset#");
        digest.append(this.set.id);
        for (RelTrait trait : this.traitSet) {
            digest.append('.').append(trait);
        }
        return digest.toString();
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.set.rel.getRowType();
    }

    Set<RelNode> getParents() {
        LinkedHashSet<RelNode> list = new LinkedHashSet<RelNode>();
        for (RelNode parent : this.set.getParentRels()) {
            for (RelSubset rel : RelSubset.inputSubsets(parent)) {
                if (rel != this) continue;
                list.add(parent);
            }
        }
        return list;
    }

    Set<RelSubset> getParentSubsets(VolcanoPlanner planner) {
        LinkedHashSet<RelSubset> list = new LinkedHashSet<RelSubset>();
        for (RelNode parent : this.set.getParentRels()) {
            for (RelSubset rel : RelSubset.inputSubsets(parent)) {
                if (rel.set != this.set || !rel.getTraitSet().equals(this.traitSet)) continue;
                list.add(planner.getSubset(parent));
            }
        }
        return list;
    }

    private static List<RelSubset> inputSubsets(RelNode parent) {
        return parent.getInputs();
    }

    public Collection<RelNode> getParentRels() {
        LinkedHashSet<RelNode> list = new LinkedHashSet<RelNode>();
        block0: for (RelNode parent : this.set.getParentRels()) {
            for (RelSubset rel : RelSubset.inputSubsets(parent)) {
                if (rel.set != this.set || !this.traitSet.satisfies(rel.getTraitSet())) continue;
                list.add(parent);
                continue block0;
            }
        }
        return list;
    }

    RelSet getSet() {
        return this.set;
    }

    void add(RelNode rel) {
        if (this.set.rels.contains(rel)) {
            return;
        }
        VolcanoPlanner planner = (VolcanoPlanner)rel.getCluster().getPlanner();
        if (planner.getListener() != null) {
            RelOptListener.RelEquivalenceEvent event = new RelOptListener.RelEquivalenceEvent(planner, rel, this, true);
            planner.getListener().relEquivalenceFound(event);
        }
        if (this.set.rel != null) {
            RelOptUtil.equal("rowtype of new rel", rel.getRowType(), "rowtype of set", this.getRowType(), Litmus.THROW);
        }
        this.set.addInternal(rel);
    }

    RelNode buildCheapestPlan(VolcanoPlanner planner) {
        CheapestPlanReplacer replacer = new CheapestPlanReplacer(planner);
        RelNode cheapest = replacer.visit(this, -1, null);
        if (planner.getListener() != null) {
            RelOptListener.RelChosenEvent event = new RelOptListener.RelChosenEvent(planner, null);
            planner.getListener().relChosen(event);
        }
        return cheapest;
    }

    void propagateCostImprovements(VolcanoPlanner planner, RelMetadataQuery mq, RelNode rel, Set<RelSubset> activeSet) {
        ArrayDeque<Pair<RelSubset, RelNode>> propagationQueue = new ArrayDeque<Pair<RelSubset, RelNode>>();
        for (RelSubset subset : this.set.subsets) {
            if (!rel.getTraitSet().satisfies(subset.traitSet)) continue;
            propagationQueue.offer(Pair.of(subset, rel));
        }
        while (!propagationQueue.isEmpty()) {
            Pair p = (Pair)propagationQueue.poll();
            ((RelSubset)p.left).propagateCostImprovements0(planner, mq, (RelNode)p.right, activeSet, propagationQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void propagateCostImprovements0(VolcanoPlanner planner, RelMetadataQuery mq, RelNode rel, Set<RelSubset> activeSet, Queue<Pair<RelSubset, RelNode>> propagationQueue) {
        ++this.timestamp;
        if (!activeSet.add(this)) {
            LOGGER.trace("cyclic: {}", (Object)this);
            return;
        }
        try {
            RelOptCost cost = planner.getCost(rel, mq);
            if (cost.isLt(this.bestCost)) {
                LOGGER.trace("Subset cost changed: subset [{}] cost was {} now {}", this, this.bestCost, cost);
                this.bestCost = cost;
                this.best = rel;
                mq.clearCache(this);
                for (RelNode parent : this.getParents()) {
                    mq.clearCache(parent);
                    RelSubset parentSubset = planner.getSubset(parent);
                    for (RelSubset subset : parentSubset.set.subsets) {
                        if (!parent.getTraitSet().satisfies(subset.traitSet)) continue;
                        propagationQueue.offer(Pair.of(subset, parent));
                    }
                }
            }
        }
        finally {
            activeSet.remove(this);
        }
    }

    @Override
    public void collectVariablesUsed(Set<CorrelationId> variableSet) {
        variableSet.addAll(this.set.variablesUsed);
    }

    @Override
    public void collectVariablesSet(Set<CorrelationId> variableSet) {
        variableSet.addAll(this.set.variablesPropagated);
    }

    public Iterable<RelNode> getRels() {
        return () -> Linq4j.asEnumerable(this.set.rels).where(v1 -> v1.getTraitSet().satisfies(this.traitSet)).iterator();
    }

    public List<RelNode> getRelList() {
        ArrayList<RelNode> list = new ArrayList<RelNode>();
        for (RelNode rel : this.set.rels) {
            if (!rel.getTraitSet().satisfies(this.traitSet)) continue;
            list.add(rel);
        }
        return list;
    }

    @API(since="1.23", status=API.Status.EXPERIMENTAL)
    public Stream<RelSubset> getSubsetsSatisfyingThis() {
        return this.set.subsets.stream().filter(s -> s.getTraitSet().satisfies(this.traitSet));
    }

    @API(since="1.23", status=API.Status.EXPERIMENTAL)
    public Stream<RelSubset> getSatisfyingSubsets() {
        return this.set.subsets.stream().filter(s -> this.traitSet.satisfies(s.getTraitSet()));
    }

    static class CheapestPlanReplacer {
        VolcanoPlanner planner;

        CheapestPlanReplacer(VolcanoPlanner planner) {
            this.planner = planner;
        }

        private static String traitDiff(RelTraitSet original, RelTraitSet desired) {
            return Pair.zip(original, desired).stream().filter(p -> !((RelTrait)p.left).satisfies((RelTrait)p.right)).map(p -> ((RelTrait)p.left).getTraitDef().getSimpleName() + ": " + p.left + " -> " + p.right).collect(Collectors.joining(", ", "[", "]"));
        }

        public RelNode visit(RelNode p, int ordinal, RelNode parent) {
            if (p instanceof RelSubset) {
                RelSubset subset = (RelSubset)p;
                RelNode cheapest = subset.best;
                if (cheapest == null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    pw.print("There are not enough rules to produce a node with desired properties");
                    RelTraitSet desiredTraits = subset.getTraitSet();
                    String sep = ": ";
                    for (RelTrait trait : desiredTraits) {
                        pw.print(sep);
                        pw.print(trait.getTraitDef().getSimpleName());
                        pw.print("=");
                        pw.print(trait);
                        sep = ", ";
                    }
                    pw.print(".");
                    DeadEndFinder finder = new DeadEndFinder();
                    finder.visit(subset);
                    if (finder.deadEnds.isEmpty()) {
                        pw.print(" All the inputs have relevant nodes, however the cost is still infinite.");
                    } else {
                        Map problemCounts = finder.deadEnds.stream().filter(deadSubset -> deadSubset.getOriginal() != null).map(x -> x.getOriginal().getClass().getSimpleName() + CheapestPlanReplacer.traitDiff(x.getOriginal().getTraitSet(), x.getTraitSet())).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                        String problems = problemCounts.entrySet().stream().sorted(Comparator.comparingLong(Map.Entry::getValue).reversed()).map(e -> (String)e.getKey() + ((Long)e.getValue() > 1L ? " (" + e.getValue() + " cases)" : "")).collect(Collectors.joining(", "));
                        pw.println();
                        pw.print("Missing conversion");
                        pw.print(finder.deadEnds.size() == 1 ? " is " : "s are ");
                        pw.print(problems);
                        pw.println();
                        if (finder.deadEnds.size() == 1) {
                            pw.print("There is 1 empty subset: ");
                        }
                        if (finder.deadEnds.size() > 1) {
                            pw.println("There are " + finder.deadEnds.size() + " empty subsets:");
                        }
                        int i = 0;
                        int rest = finder.deadEnds.size();
                        for (RelSubset deadEnd : finder.deadEnds) {
                            if (finder.deadEnds.size() > 1) {
                                pw.print("Empty subset ");
                                pw.print(i);
                                pw.print(": ");
                            }
                            pw.print(deadEnd);
                            pw.println(", the relevant part of the original plan is as follows");
                            RelNode original = deadEnd.getOriginal();
                            original.explain(new RelWriterImpl(pw, SqlExplainLevel.EXPPLAN_ATTRIBUTES, true));
                            ++i;
                            if (--rest > 0) {
                                pw.println();
                            }
                            if (i < 10 || rest <= 1) continue;
                            pw.print("The rest ");
                            pw.print(rest);
                            pw.println(" leafs are omitted.");
                            break;
                        }
                    }
                    pw.println();
                    this.planner.dump(pw);
                    pw.flush();
                    String dump = sw.toString();
                    RelOptPlanner.CannotPlanException e2 = new RelOptPlanner.CannotPlanException(dump);
                    LOGGER.trace("Caught exception in class={}, method=visit", (Object)this.getClass().getName(), (Object)e2);
                    throw e2;
                }
                p = cheapest;
            }
            if (ordinal != -1 && this.planner.getListener() != null) {
                RelOptListener.RelChosenEvent event = new RelOptListener.RelChosenEvent(this.planner, p);
                this.planner.getListener().relChosen(event);
            }
            List<RelNode> oldInputs = p.getInputs();
            ArrayList<RelNode> inputs = new ArrayList<RelNode>();
            for (int i = 0; i < oldInputs.size(); ++i) {
                RelNode oldInput = oldInputs.get(i);
                RelNode input = this.visit(oldInput, i, p);
                inputs.add(input);
            }
            if (!inputs.equals(oldInputs)) {
                RelNode pOld = p;
                p = p.copy(p.getTraitSet(), inputs);
                this.planner.provenanceMap.put(p, new VolcanoPlanner.DirectProvenance(pOld));
            }
            return p;
        }
    }

    static class DeadEndFinder {
        final Set<RelSubset> deadEnds = new HashSet<RelSubset>();
        private final Set<RelNode> visitedNodes = new HashSet<RelNode>();
        private final Set<RelNode> activeNodes = new HashSet<RelNode>();

        DeadEndFinder() {
        }

        private boolean visit(RelNode p) {
            if (p instanceof RelSubset) {
                this.visitSubset((RelSubset)p);
                return false;
            }
            return this.visitRel(p);
        }

        private void visitSubset(RelSubset subset) {
            RelNode cheapest = subset.getBest();
            if (cheapest != null) {
                return;
            }
            boolean isEmpty = true;
            for (RelNode rel : subset.getRels()) {
                if (rel instanceof AbstractConverter || !this.activeNodes.add(rel)) continue;
                boolean res = this.visit(rel);
                isEmpty &= res;
                this.activeNodes.remove(rel);
            }
            if (isEmpty) {
                this.deadEnds.add(subset);
            }
        }

        private boolean visitRel(RelNode p) {
            for (RelNode oldInput : p.getInputs()) {
                if (!this.activeNodes.contains(oldInput)) continue;
                return true;
            }
            this.activeNodes.addAll(p.getInputs());
            for (RelNode oldInput : p.getInputs()) {
                if (!this.visitedNodes.add(oldInput)) continue;
                this.visit(oldInput);
            }
            this.activeNodes.removeAll(p.getInputs());
            return false;
        }
    }
}

