/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.type;

import com.hazelcast.com.google.common.cache.CacheBuilder;
import com.hazelcast.com.google.common.cache.CacheLoader;
import com.hazelcast.com.google.common.cache.LoadingCache;
import com.hazelcast.com.google.common.collect.ImmutableSet;
import com.hazelcast.com.google.common.collect.Sets;
import com.hazelcast.com.google.common.util.concurrent.UncheckedExecutionException;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeAssignmentRule;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeCoercionRule;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeMappingRule;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.util.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public abstract class SqlTypeMappingRules {
    public static SqlTypeMappingRule instance(boolean coerce) {
        if (coerce) {
            return SqlTypeCoercionRule.instance();
        }
        return SqlTypeAssignmentRule.instance();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        final Map<SqlTypeName, ImmutableSet<SqlTypeName>> map = new HashMap<SqlTypeName, ImmutableSet<SqlTypeName>>();
        final LoadingCache<Set<SqlTypeName>, ImmutableSet<SqlTypeName>> sets = CacheBuilder.newBuilder().build(CacheLoader.from(set -> Sets.immutableEnumSet(set)));

        Builder() {
        }

        void add(SqlTypeName fromType, Set<SqlTypeName> toTypes) {
            try {
                this.map.put(fromType, this.sets.get(toTypes));
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                Util.throwIfUnchecked(e.getCause());
                throw new RuntimeException("populating SqlTypeAssignmentRules", e);
            }
        }

        void addAll(Map<SqlTypeName, ImmutableSet<SqlTypeName>> typeMapping) {
            try {
                this.map.putAll(typeMapping);
            }
            catch (UncheckedExecutionException e) {
                Util.throwIfUnchecked(e.getCause());
                throw new RuntimeException("populating SqlTypeAssignmentRules", e);
            }
        }

        ImmutableSet.Builder<SqlTypeName> copyValues(SqlTypeName typeName) {
            return ImmutableSet.builder().addAll(this.map.get((Object)typeName));
        }
    }
}

