/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.distributed;

import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.CacheEnvironment;
import com.hazelcast.hibernate.HazelcastTimestamper;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.hibernate.distributed.LockEntryProcessor;
import com.hazelcast.hibernate.distributed.UnlockEntryProcessor;
import com.hazelcast.hibernate.distributed.UpdateEntryProcessor;
import com.hazelcast.hibernate.serialization.Expirable;
import com.hazelcast.hibernate.serialization.ExpiryMarker;
import com.hazelcast.hibernate.serialization.MarkerWrapper;
import com.hazelcast.hibernate.serialization.Value;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.IMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.access.SoftLock;

public class IMapRegionCache
implements RegionCache {
    private static final long COMPARISON_VALUE = 500L;
    private final String name;
    private final HazelcastInstance hazelcastInstance;
    private final IMap<Object, Expirable> map;
    private final Comparator versionComparator;
    private final int lockTimeout;
    private final long tryLockAndGetTimeout;
    private final AtomicLong markerIdCounter;
    private final boolean isMember;

    public IMapRegionCache(String name, HazelcastInstance hazelcastInstance, Properties props, CacheDataDescription metadata) {
        this.name = name;
        this.hazelcastInstance = hazelcastInstance;
        this.versionComparator = metadata != null && metadata.isVersioned() ? metadata.getVersionComparator() : null;
        this.map = hazelcastInstance.getMap(this.name);
        this.isMember = IMapRegionCache.isMemberInstance(hazelcastInstance);
        this.lockTimeout = CacheEnvironment.getLockTimeoutInMillis(props);
        long maxOperationTimeout = HazelcastTimestamper.getMaxOperationTimeout(hazelcastInstance);
        this.tryLockAndGetTimeout = Math.min(maxOperationTimeout, 500L);
        this.markerIdCounter = new AtomicLong();
    }

    @Override
    public Object get(Object key, long txTimestamp) {
        Expirable entry = (Expirable)this.map.get(key);
        return entry == null ? null : entry.getValue(txTimestamp);
    }

    @Override
    public boolean insert(Object key, Object value, Object currentVersion) {
        return this.map.putIfAbsent(key, (Object)new Value(currentVersion, HazelcastTimestamper.nextTimestamp(this.hazelcastInstance), value)) == null;
    }

    @Override
    public boolean put(Object key, Object value, long txTimestamp, Object version) {
        long timeout = System.currentTimeMillis() + this.tryLockAndGetTimeout;
        Value newEntry = new Value(version, txTimestamp, value);
        do {
            Expirable currentEntry;
            if ((currentEntry = (Expirable)this.map.putIfAbsent(key, (Object)newEntry)) == null) {
                return true;
            }
            if (!currentEntry.isReplaceableBy(txTimestamp, version, this.versionComparator)) {
                return false;
            }
            if (!this.map.replace(key, (Object)currentEntry, (Object)newEntry)) continue;
            return true;
        } while (System.currentTimeMillis() < timeout);
        return false;
    }

    @Override
    public boolean update(Object key, Object newValue, Object newVersion, SoftLock lock) {
        if (lock instanceof MarkerWrapper) {
            ExpiryMarker unwrappedMarker = ((MarkerWrapper)lock).getMarker();
            return (Boolean)this.map.executeOnKey(key, (EntryProcessor)new UpdateEntryProcessor(unwrappedMarker, newValue, newVersion, this.nextMarkerId(), HazelcastTimestamper.nextTimestamp(this.hazelcastInstance)));
        }
        return false;
    }

    @Override
    public boolean remove(Object key) {
        return this.map.remove(key) != null;
    }

    @Override
    public SoftLock tryLock(Object key, Object version) {
        long timeout = HazelcastTimestamper.nextTimestamp(this.hazelcastInstance) + (long)this.lockTimeout;
        ExpiryMarker marker = (ExpiryMarker)this.map.executeOnKey(key, (EntryProcessor)new LockEntryProcessor(this.nextMarkerId(), timeout, version));
        return new MarkerWrapper(marker);
    }

    @Override
    public void unlock(Object key, SoftLock lock) {
        if (lock instanceof MarkerWrapper) {
            ExpiryMarker unwrappedMarker = ((MarkerWrapper)lock).getMarker();
            this.map.executeOnKey(key, (EntryProcessor)new UnlockEntryProcessor(unwrappedMarker, this.nextMarkerId(), HazelcastTimestamper.nextTimestamp(this.hazelcastInstance)));
        }
    }

    @Override
    public boolean contains(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public void clear() {
        this.map.evictAll();
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public long getSizeInMemory() {
        return this.isMember ? this.map.getLocalMapStats().getHeapCost() : -1L;
    }

    @Override
    public Map asMap() {
        return this.map;
    }

    private String nextMarkerId() {
        return this.hazelcastInstance.getLocalEndpoint().getUuid().toString() + this.markerIdCounter.getAndIncrement();
    }

    private static boolean isMemberInstance(HazelcastInstance instance) {
        return instance.getLocalEndpoint() instanceof Member;
    }
}

