/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.region;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.Objects;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.Type;

public final class CacheKeyImpl
implements DataSerializable {
    private Object id;
    private Type type;
    private String entityOrRoleName;
    private String tenantId;
    private int hashCode;

    public CacheKeyImpl() {
    }

    public CacheKeyImpl(Object id, Type type, String entityOrRoleName, String tenantId, SessionFactoryImplementor factory) {
        this.id = id;
        this.type = type;
        this.entityOrRoleName = entityOrRoleName;
        this.tenantId = tenantId;
        this.hashCode = this.calculateHashCode(type, factory);
    }

    private int calculateHashCode(Type type, SessionFactoryImplementor factory) {
        int result = type.getHashCode(this.id, factory);
        result = 31 * result + (this.tenantId != null ? this.tenantId.hashCode() : 0);
        return result;
    }

    Object getId() {
        return this.id;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.id);
        out.writeUTF(this.entityOrRoleName);
        out.writeUTF(this.tenantId);
        out.writeObject((Object)this.type);
        out.writeInt(this.hashCode);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.id = in.readObject();
        this.entityOrRoleName = in.readUTF();
        this.tenantId = in.readUTF();
        this.type = (Type)in.readObject();
        this.hashCode = in.readInt();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CacheKeyImpl that = (CacheKeyImpl)other;
        if (!this.type.isEqual(this.id, that.id)) {
            return false;
        }
        if (!this.entityOrRoleName.equals(that.entityOrRoleName)) {
            return false;
        }
        return Objects.equals(this.tenantId, that.tenantId);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.entityOrRoleName + '#' + this.id.toString();
    }
}

