/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2servlet.util;

import com.helger.as2lib.crypto.ECryptoAlgorithmSign;
import com.helger.as2lib.exception.OpenAS2Exception;
import com.helger.as2lib.partner.Partnership;
import com.helger.as2lib.partner.xml.SelfFillingXMLPartnershipFactory;
import javax.annotation.Nonnull;

public class AS2ServletPartnershipFactory
extends SelfFillingXMLPartnershipFactory {
    protected void onBeforeAddPartnership(@Nonnull Partnership partnership) throws OpenAS2Exception {
        super.onBeforeAddPartnership(partnership);
        if ("auto-created-dummy".equals(partnership.getName())) {
            partnership.setName(partnership.getSenderAS2ID() + "-" + partnership.getReceiverAS2ID());
        }
        if (partnership.getSigningAlgorithm() == null) {
            partnership.setSigningAlgorithm(ECryptoAlgorithmSign.DIGEST_SHA_1);
        }
    }

    protected void markAsChanged() throws OpenAS2Exception {
        this.storePartnership();
    }
}

