/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2servlet;

import com.helger.as2lib.exception.OpenAS2Exception;
import com.helger.as2lib.message.AS2Message;
import com.helger.as2lib.message.IBaseMessage;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.processor.receiver.AS2ReceiverModule;
import com.helger.as2lib.util.http.HTTPHelper;
import com.helger.as2lib.util.http.IAS2HttpResponseHandler;
import com.helger.as2servlet.util.AS2OutputStreamCreatorHttpServletResponse;
import com.helger.as2servlet.util.AS2ServletReceiverModule;
import com.helger.as2servlet.util.AS2ServletSession;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.string.StringHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.mail.internet.InternetHeaders;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2ReceiveServlet
extends HttpServlet {
    public static final String SERVLET_INIT_PARAM_AS2_SERVLET_CONFIG_FILENAME = "as2-servlet-config-filename";
    private static final Logger s_aLogger = LoggerFactory.getLogger(AS2ReceiveServlet.class);
    private AS2ServletSession m_aSession;
    private AS2ReceiverModule m_aReceiver;

    @Nonnull
    @OverrideOnDemand
    protected File getConfigurationFile() throws ServletException {
        String string = this.getServletConfig().getInitParameter(SERVLET_INIT_PARAM_AS2_SERVLET_CONFIG_FILENAME);
        if (StringHelper.hasNoText((String)string)) {
            throw new ServletException("Servlet Init-Parameter 'as2-servlet-config-filename' is missing or empty!");
        }
        try {
            return new File(string).getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new ServletException("Failed to get the canonical file from '" + string + "'", (Throwable)iOException);
        }
    }

    @Nonnull
    @OverrideOnDemand
    protected AS2ServletSession createAS2ServletSession(@Nonnull File file) throws OpenAS2Exception, ServletException {
        return new AS2ServletSession(file);
    }

    public void init() throws ServletException {
        File file = this.getConfigurationFile();
        if (file == null) {
            throw new ServletException("No configuration file provided!");
        }
        try {
            this.m_aSession = this.createAS2ServletSession(file);
            this.m_aReceiver = (AS2ReceiverModule)this.m_aSession.getMessageProcessor().getModuleOfClass(AS2ServletReceiverModule.class);
            if (this.m_aReceiver == null) {
                throw new ServletException("Failed to retrieve AS2ReceiverModule which is a mandatory module!");
            }
        }
        catch (OpenAS2Exception openAS2Exception) {
            throw new ServletException("Failed to init AS2 configuration", (Throwable)openAS2Exception);
        }
        s_aLogger.info("Successfully initialized AS2 configuration from file '" + file.getAbsolutePath() + "'");
    }

    @Nonnull
    protected AS2ServletSession getSession() {
        if (this.m_aSession == null) {
            throw new IllegalStateException("This servlet was not initialized properly! No AS2 session is present.");
        }
        return this.m_aSession;
    }

    @Nonnull
    protected AS2ReceiverModule getReceiverModule() {
        if (this.m_aReceiver == null) {
            throw new IllegalStateException("This servlet was not initialized properly! No receiver is present.");
        }
        return this.m_aReceiver;
    }

    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void handeIncomingMessage(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull byte[] byArray, @Nonnull AS2Message aS2Message, @Nonnull AS2OutputStreamCreatorHttpServletResponse aS2OutputStreamCreatorHttpServletResponse) throws ServletException {
        String string = httpServletRequest.getRemoteAddr() + ":" + httpServletRequest.getRemotePort();
        this.getReceiverModule().createHandler().handleIncomingMessage(string, byArray, aS2Message, (IAS2HttpResponseHandler)aS2OutputStreamCreatorHttpServletResponse);
    }

    protected void doPost(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        Object object2;
        AS2Message aS2Message = new AS2Message();
        aS2Message.setAttribute("source_ip", httpServletRequest.getRemoteAddr());
        aS2Message.setAttribute("source_port", Integer.toString(httpServletRequest.getRemotePort()));
        aS2Message.setAttribute("destination_ip", httpServletRequest.getLocalAddr());
        aS2Message.setAttribute("destination_port", Integer.toString(httpServletRequest.getLocalPort()));
        aS2Message.setAttribute("HTTP_REQUEST_TYPE", httpServletRequest.getMethod());
        aS2Message.setAttribute("HTTP_REQUEST_URL", httpServletRequest.getRequestURI());
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = httpServletRequest.getHeaders((String)object2);
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                aS2Message.addHeader((String)object2, string);
            }
        }
        object2 = new AS2OutputStreamCreatorHttpServletResponse(httpServletResponse);
        object = HTTPHelper.readHttpPayload((InputStream)httpServletRequest.getInputStream(), (IAS2HttpResponseHandler)object2, (IMessage)aS2Message);
        if (HTTPHelper.isHTTPIncomingDumpEnabled()) {
            HTTPHelper.dumpIncomingHttpRequest((ICommonsList)HTTPHelper.getAllHTTPHeaderLines((InternetHeaders)aS2Message.getHeaders()), (byte[])object, (IBaseMessage)aS2Message);
        }
        this.handeIncomingMessage(httpServletRequest, httpServletResponse, (byte[])object, aS2Message, (AS2OutputStreamCreatorHttpServletResponse)object2);
    }
}

