/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.cert;

import com.helger.as2lib.AbstractDynamicComponent;
import com.helger.as2lib.cert.AS2CertificateExistsException;
import com.helger.as2lib.cert.AS2CertificateNotFoundException;
import com.helger.as2lib.cert.AS2KeyNotFoundException;
import com.helger.as2lib.cert.ECertificatePartnershipType;
import com.helger.as2lib.cert.IAliasedCertificateFactory;
import com.helger.as2lib.cert.IKeyStoreCertificateFactory;
import com.helger.as2lib.cert.IStorableCertificateFactory;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.exception.WrappedAS2Exception;
import com.helger.as2lib.message.IBaseMessage;
import com.helger.as2lib.partner.Partnership;
import com.helger.as2lib.session.IAS2Session;
import com.helger.as2lib.util.AS2Helper;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.attr.IStringMap;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.StringHelper;
import com.helger.security.keystore.EKeyStoreType;
import com.helger.security.keystore.IKeyStoreType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CertificateFactory
extends AbstractDynamicComponent
implements IAliasedCertificateFactory,
IKeyStoreCertificateFactory,
IStorableCertificateFactory {
    public static final EKeyStoreType DEFAULT_KEY_STORE_TYPE = EKeyStoreType.PKCS12;
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_FILENAME = "filename";
    public static final String ATTR_PASSWORD = "password";
    public static final String ATTR_SAVE_CHANGES_TO_FILE = "autosave";
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateFactory.class);
    @GuardedBy(value="m_aRWLock")
    private KeyStore m_aKeyStore;
    private boolean m_bDebugLog = false;

    public final boolean isDebugLogEnabled() {
        return this.m_bDebugLog;
    }

    public final void setDebugLogEnaled(boolean bl) {
        this.m_bDebugLog = bl;
    }

    protected final void debugLog(@Nonnull Supplier<String> supplier) {
        if (this.m_bDebugLog && LOGGER.isInfoEnabled()) {
            LOGGER.info(supplier.get());
        }
    }

    @Nullable
    public final String getKeyStoreType() {
        this.debugLog(() -> "getKeyStoreType ()");
        String string = (String)this.m_aRWLock.readLockedGet(() -> this.attrs().getAsString((Object)ATTR_TYPE));
        this.debugLog(() -> "getKeyStoreType -> " + string);
        return string;
    }

    public final void setKeyStoreType(@Nullable IKeyStoreType iKeyStoreType) {
        this.setKeyStoreType(iKeyStoreType == null ? null : (String)iKeyStoreType.getID());
    }

    public final void setKeyStoreType(@Nullable String string) {
        this.debugLog(() -> "setKeyStoreType (" + string + ")");
        if (string == null) {
            this.m_aRWLock.writeLockedGet(() -> (String)this.attrs().remove((Object)ATTR_TYPE));
        } else {
            this.m_aRWLock.writeLockedGet(() -> this.attrs().putIn((Object)ATTR_TYPE, (Object)string));
        }
    }

    @Override
    public void setFilename(@Nullable String string) {
        this.debugLog(() -> "setFilename (" + string + ")");
        this.m_aRWLock.writeLockedGet(() -> this.attrs().putIn((Object)ATTR_FILENAME, (Object)string));
    }

    @Override
    @Nullable
    public String getFilename() {
        this.debugLog(() -> "getFilename ()");
        String string = (String)this.m_aRWLock.readLockedGet(() -> this.attrs().getAsString((Object)ATTR_FILENAME));
        this.debugLog(() -> "getFilename -> " + string);
        return string;
    }

    @Override
    public void setPassword(@Nullable String string) {
        this.debugLog(() -> "setPassword (***)");
        this.m_aRWLock.writeLockedGet(() -> this.attrs().putIn((Object)ATTR_PASSWORD, (Object)string));
    }

    @Override
    @Nullable
    public char[] getPassword() {
        this.debugLog(() -> "getPassword ()");
        char[] cArray = (char[])this.m_aRWLock.readLockedGet(() -> this.attrs().getAsCharArray((Object)ATTR_PASSWORD));
        this.debugLog(() -> "getPassword -> ***");
        return cArray;
    }

    @Override
    public void setSaveChangesToFile(boolean bl) {
        this.debugLog(() -> "setSaveChangesToFile (" + bl + ")");
        this.m_aRWLock.writeLockedGet(() -> this.attrs().putIn(ATTR_SAVE_CHANGES_TO_FILE, bl));
    }

    @Override
    public boolean isSaveChangesToFile() {
        this.debugLog(() -> "isSaveChangesToFile ()");
        boolean bl = this.m_aRWLock.readLockedBoolean(() -> this.attrs().getAsBoolean((Object)ATTR_SAVE_CHANGES_TO_FILE, true));
        this.debugLog(() -> "isSaveChangesToFile -> " + bl);
        return bl;
    }

    @Nonnull
    @Nonempty
    private static String _debug(@Nullable X509Certificate x509Certificate) {
        return x509Certificate == null ? "null" : x509Certificate.getSubjectX500Principal().getName() + "/" + x509Certificate.getSerialNumber().toString();
    }

    @Nonnull
    @Nonempty
    private static String _debug(@Nonnull Exception exception) {
        return exception.getClass().getName() + " - " + exception.getMessage();
    }

    @Nonnull
    @OverrideOnDemand
    protected KeyStore createNewKeyStore(@Nonnull EKeyStoreType eKeyStoreType) throws GeneralSecurityException {
        ValueEnforcer.notNull((Object)eKeyStoreType, (String)"KeystoreType");
        this.debugLog(() -> "createNewKeyStore (" + eKeyStoreType + ")");
        return AS2Helper.getCryptoHelper().createNewKeyStore((IKeyStoreType)eKeyStoreType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initDynamicComponent(@Nonnull IAS2Session iAS2Session, @Nullable IStringMap iStringMap) throws AS2Exception {
        String string;
        this.debugLog(() -> "initDynamicComponent (" + iAS2Session + ", " + iStringMap + ")");
        super.initDynamicComponent(iAS2Session, iStringMap);
        try {
            string = this.getKeyStoreType();
            EKeyStoreType eKeyStoreType = EKeyStoreType.getFromIDCaseInsensitiveOrDefault((String)string, (EKeyStoreType)DEFAULT_KEY_STORE_TYPE);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Using internal keystore of type " + eKeyStoreType);
            }
            this.m_aRWLock.writeLock().lock();
            try {
                this.m_aKeyStore = this.createNewKeyStore(eKeyStoreType);
                if (this.m_aKeyStore == null) {
                    this.debugLog(() -> "initDynamicComponent -> no keystore");
                    throw new InitializationException("Failed to create new keystore with type " + eKeyStoreType);
                }
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.debugLog(() -> "initDynamicComponent -> " + CertificateFactory._debug(generalSecurityException));
            throw WrappedAS2Exception.wrap(generalSecurityException);
        }
        string = this.getFilename();
        if (StringHelper.hasText((String)string)) {
            this.load(string, this.getPassword());
        }
        this.debugLog(() -> "initDynamicComponent -> done");
    }

    @Override
    @Nonnull
    public KeyStore getKeyStore() {
        KeyStore keyStore = (KeyStore)this.m_aRWLock.readLockedGet(() -> this.m_aKeyStore);
        if (keyStore == null) {
            throw new IllegalStateException("No keystore present");
        }
        return keyStore;
    }

    @Nullable
    @OverrideOnDemand
    protected String getUnifiedAlias(@Nullable String string) {
        return string;
    }

    @Nonnull
    public String getAlias(@Nonnull Partnership partnership, @Nonnull ECertificatePartnershipType eCertificatePartnershipType) throws AS2Exception {
        String string;
        ValueEnforcer.notNull((Object)partnership, (String)"Partnership");
        ValueEnforcer.notNull((Object)((Object)eCertificatePartnershipType), (String)"PartnershipType");
        this.debugLog(() -> "getAlias (" + partnership + ", " + (Object)((Object)eCertificatePartnershipType) + ")");
        switch (eCertificatePartnershipType) {
            case RECEIVER: {
                string = partnership.getReceiverX509Alias();
                break;
            }
            case SENDER: {
                string = partnership.getSenderX509Alias();
                break;
            }
            default: {
                string = null;
            }
        }
        if (string == null) {
            this.debugLog(() -> "getAlias -> null");
            throw new AS2CertificateNotFoundException(eCertificatePartnershipType, partnership);
        }
        String string2 = this.getUnifiedAlias(string);
        this.debugLog(() -> "getAlias -> " + string2);
        return string2;
    }

    @Nonnull
    protected X509Certificate internalGetCertificate(@Nullable String string, @Nullable ECertificatePartnershipType eCertificatePartnershipType) throws AS2Exception {
        this.debugLog(() -> "internalGetCertificate (" + string + ", " + (Object)((Object)eCertificatePartnershipType) + ")");
        String string2 = this.getUnifiedAlias(string);
        this.m_aRWLock.readLock().lock();
        try {
            X509Certificate x509Certificate = (X509Certificate)this.m_aKeyStore.getCertificate(string2);
            if (x509Certificate == null) {
                throw new AS2CertificateNotFoundException(eCertificatePartnershipType, string2);
            }
            this.debugLog(() -> "internalGetCertificate -> " + CertificateFactory._debug(x509Certificate));
            X509Certificate x509Certificate2 = x509Certificate;
            return x509Certificate2;
        }
        catch (KeyStoreException keyStoreException) {
            this.debugLog(() -> "internalGetCertificate -> " + CertificateFactory._debug(keyStoreException));
            throw WrappedAS2Exception.wrap(keyStoreException);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    @Nonnull
    public X509Certificate getCertificate(@Nullable String string) throws AS2Exception {
        this.debugLog(() -> "getCertificate (" + string + ")");
        X509Certificate x509Certificate = this.internalGetCertificate(string, null);
        this.debugLog(() -> "getCertificate -> " + CertificateFactory._debug(x509Certificate));
        return x509Certificate;
    }

    @Override
    @Nonnull
    public X509Certificate getCertificate(@Nonnull IBaseMessage iBaseMessage, @Nonnull ECertificatePartnershipType eCertificatePartnershipType) throws AS2Exception {
        this.debugLog(() -> "getCertificate (" + iBaseMessage.getMessageID() + ", " + (Object)((Object)eCertificatePartnershipType) + ")");
        String string = this.getAlias(iBaseMessage.partnership(), eCertificatePartnershipType);
        X509Certificate x509Certificate = this.internalGetCertificate(string, eCertificatePartnershipType);
        this.debugLog(() -> "getCertificate -> " + CertificateFactory._debug(x509Certificate));
        return x509Certificate;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, X509Certificate> getCertificates() throws AS2Exception {
        this.debugLog(() -> "getCertificates ()");
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        this.m_aRWLock.readLock().lock();
        try {
            Enumeration<String> enumeration = this.m_aKeyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                commonsLinkedHashMap.put((Object)string, (Object)((X509Certificate)this.m_aKeyStore.getCertificate(string)));
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.debugLog(() -> "getCertificates -> " + CertificateFactory._debug(generalSecurityException));
            throw WrappedAS2Exception.wrap(generalSecurityException);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        this.debugLog(() -> CertificateFactory.lambda$getCertificates$41((ICommonsOrderedMap)commonsLinkedHashMap));
        return commonsLinkedHashMap;
    }

    @OverrideOnDemand
    protected void onChange() throws AS2Exception {
        this.debugLog(() -> "onChange ()");
        if (this.isSaveChangesToFile()) {
            String string = this.getFilename();
            if (StringHelper.hasText((String)string)) {
                this.save(string, this.getPassword());
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Something changed in the keystore, but because no filename is present, changes are not saved");
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Something changed in the keystore, saving of changes is disabled");
        }
        this.debugLog(() -> "onChange -> done");
    }

    @Nonnull
    private ICommonsList<String> _getAllAliases() {
        this.debugLog(() -> "_getAllAliases ()");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        this.m_aRWLock.readLock().lock();
        try {
            commonsArrayList.addAll(this.m_aKeyStore.aliases());
        }
        catch (KeyStoreException keyStoreException) {
            LOGGER.warn("Failed to determine all aliases from keystore", (Throwable)keyStoreException);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        this.debugLog(() -> CertificateFactory.lambda$_getAllAliases$45((ICommonsList)commonsArrayList));
        return commonsArrayList;
    }

    @Override
    @Nonnull
    public PrivateKey getPrivateKey(@Nullable X509Certificate x509Certificate) throws AS2Exception {
        this.debugLog(() -> "getPrivateKey (" + CertificateFactory._debug(x509Certificate) + ")");
        String string = null;
        this.m_aRWLock.readLock().lock();
        try {
            String string2 = this.m_aKeyStore.getCertificateAlias(x509Certificate);
            if (string2 == null) {
                this.debugLog(() -> "getCertificates -> null");
                throw new AS2CertificateNotFoundException(x509Certificate);
            }
            string = this.getUnifiedAlias(string2);
            PrivateKey privateKey = (PrivateKey)this.m_aKeyStore.getKey(string, this.getPassword());
            if (privateKey == null) {
                this.debugLog(() -> "getPrivateKey -> null");
                throw new AS2KeyNotFoundException(x509Certificate, string, this._getAllAliases(), null);
            }
            this.debugLog(() -> "getPrivateKey -> " + privateKey);
            PrivateKey privateKey2 = privateKey;
            return privateKey2;
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.debugLog(() -> "getPrivateKey -> " + CertificateFactory._debug(generalSecurityException));
            throw new AS2KeyNotFoundException(x509Certificate, string, this._getAllAliases(), generalSecurityException);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    public void addCertificate(@Nonnull @Nonempty String string, @Nonnull X509Certificate x509Certificate, boolean bl) throws AS2Exception {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Alias");
        ValueEnforcer.notNull((Object)x509Certificate, (String)"Cert");
        this.debugLog(() -> "addCertificate (" + string + ", " + CertificateFactory._debug(x509Certificate) + ", " + bl + ")");
        String string2 = this.getUnifiedAlias(string);
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aKeyStore.containsAlias(string2) && !bl) {
                throw new AS2CertificateExistsException(string2);
            }
            this.m_aKeyStore.setCertificateEntry(string2, x509Certificate);
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.debugLog(() -> "addCertificate -> " + CertificateFactory._debug(generalSecurityException));
            throw WrappedAS2Exception.wrap(generalSecurityException);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        this.onChange();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Added certificate alias '" + string2 + "' of certificate '" + CertificateFactory._debug(x509Certificate) + "'");
        }
        this.debugLog(() -> "addCertificate -> done");
    }

    @Override
    public void addPrivateKey(@Nonnull @Nonempty String string, @Nonnull Key key, @Nonnull String string2) throws AS2Exception {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Alias");
        ValueEnforcer.notNull((Object)key, (String)"Key");
        ValueEnforcer.notNull((Object)string2, (String)"Password");
        this.debugLog(() -> "addPrivateKey (" + string + ", " + key + ", ***)");
        String string3 = this.getUnifiedAlias(string);
        this.m_aRWLock.writeLock().lock();
        try {
            if (!this.m_aKeyStore.containsAlias(string3)) {
                throw new AS2CertificateNotFoundException(null, string3);
            }
            Certificate[] certificateArray = this.m_aKeyStore.getCertificateChain(string3);
            this.m_aKeyStore.setKeyEntry(string3, key, string2.toCharArray(), certificateArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.debugLog(() -> "addPrivateKey -> " + CertificateFactory._debug(generalSecurityException));
            throw WrappedAS2Exception.wrap(generalSecurityException);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        this.onChange();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Added private key alias '" + string3 + "'");
        }
        this.debugLog(() -> "addPrivateKey -> done");
    }

    @Override
    public void clearCertificates() throws AS2Exception {
        this.debugLog(() -> "clearCertificates ()");
        int n = 0;
        this.m_aRWLock.writeLock().lock();
        try {
            for (String string : CollectionHelper.newList(this.m_aKeyStore.aliases())) {
                this.m_aKeyStore.deleteEntry(string);
                ++n;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.debugLog(() -> "clearCertificates -> " + CertificateFactory._debug(generalSecurityException));
            throw WrappedAS2Exception.wrap(generalSecurityException);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (n > 0) {
            this.onChange();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Remove all aliases (" + n + ") in key store");
            }
        }
        int n2 = n;
        this.debugLog(() -> "clearCertificates -> removed " + n2);
    }

    @Override
    public void removeCertificate(@Nonnull X509Certificate x509Certificate) throws AS2Exception {
        String string;
        ValueEnforcer.notNull((Object)x509Certificate, (String)"Cert");
        this.debugLog(() -> "removeCertificate (" + CertificateFactory._debug(x509Certificate) + ")");
        this.m_aRWLock.readLock().lock();
        try {
            string = this.m_aKeyStore.getCertificateAlias(x509Certificate);
            if (string == null) {
                throw new AS2CertificateNotFoundException(x509Certificate);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.debugLog(() -> "removeCertificate -> " + CertificateFactory._debug(generalSecurityException));
            throw WrappedAS2Exception.wrap(generalSecurityException);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        this.removeCertificate(string);
        this.debugLog(() -> "removeCertificate -> done");
    }

    @Override
    public void removeCertificate(@Nullable String string) throws AS2Exception {
        X509Certificate x509Certificate;
        this.debugLog(() -> "removeCertificate (" + string + ")");
        String string2 = this.getUnifiedAlias(string);
        this.m_aRWLock.writeLock().lock();
        try {
            x509Certificate = (X509Certificate)this.m_aKeyStore.getCertificate(string2);
            if (x509Certificate == null) {
                throw new AS2CertificateNotFoundException(null, string2);
            }
            this.m_aKeyStore.deleteEntry(string2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.debugLog(() -> "removeCertificate -> " + CertificateFactory._debug(generalSecurityException));
            throw WrappedAS2Exception.wrap(generalSecurityException);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        this.onChange();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Removed certificate alias '" + string2 + "' of certificate " + CertificateFactory._debug(x509Certificate));
        }
        this.debugLog(() -> "removeCertificate -> done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(@Nonnull @WillClose InputStream inputStream, @Nonnull char[] cArray) throws AS2Exception {
        this.debugLog(() -> "load (" + inputStream + ", ***)");
        this.m_aRWLock.writeLock().lock();
        try {
            try {
                this.m_aKeyStore.load(inputStream, cArray);
            }
            catch (IOException | GeneralSecurityException exception) {
                this.debugLog(() -> "load -> " + CertificateFactory._debug(exception));
                throw WrappedAS2Exception.wrap(exception);
            }
            finally {
                StreamHelper.close((AutoCloseable)inputStream);
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished loading keystore from an InputStream");
        }
        this.debugLog(() -> "load -> done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(@Nonnull @WillClose OutputStream outputStream, @Nonnull char[] cArray) throws AS2Exception {
        this.debugLog(() -> "save (" + outputStream + ", ***)");
        this.m_aRWLock.writeLock().lock();
        try {
            try {
                this.m_aKeyStore.store(outputStream, cArray);
            }
            catch (IOException | GeneralSecurityException exception) {
                this.debugLog(() -> "save -> " + CertificateFactory._debug(exception));
                throw WrappedAS2Exception.wrap(exception);
            }
            finally {
                StreamHelper.close((AutoCloseable)outputStream);
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished saving keystore to an OutputStream");
        }
        this.debugLog(() -> "save -> done");
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private static /* synthetic */ String lambda$_getAllAliases$45(ICommonsList iCommonsList) {
        return "_getAllAliases -> " + iCommonsList;
    }

    private static /* synthetic */ String lambda$getCertificates$41(ICommonsOrderedMap iCommonsOrderedMap) {
        return "getCertificates -> " + new CommonsLinkedHashMap((Map)iCommonsOrderedMap, string -> string, x509Certificate -> CertificateFactory._debug(x509Certificate)).toString();
    }
}

