/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.message;

import com.helger.as2lib.message.AbstractBaseMessage;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.message.IMessageMDN;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;

public abstract class AbstractMessageMDN
extends AbstractBaseMessage
implements IMessageMDN {
    private IMessage m_aMessage;
    private MimeBodyPart m_aData;
    private String m_sText;

    public AbstractMessageMDN(@Nonnull IMessage iMessage) {
        this.setMessage(iMessage);
        iMessage.setMDN(this);
    }

    @Override
    @Nonnull
    public final IMessage getMessage() {
        return this.m_aMessage;
    }

    @Override
    public final void setMessage(@Nonnull IMessage iMessage) {
        ValueEnforcer.notNull((Object)iMessage, (String)"Message");
        this.m_aMessage = iMessage;
    }

    @Override
    @Nullable
    public final MimeBodyPart getData() {
        return this.m_aData;
    }

    @Override
    public final void setData(@Nullable MimeBodyPart mimeBodyPart) {
        this.m_aData = mimeBodyPart;
    }

    @Override
    @Nullable
    public final String getText() {
        return this.m_sText;
    }

    @Override
    public final void setText(@Nullable String string) {
        this.m_sText = string;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MDN From:").append(this.partnership().getAllSenderIDs().toString()).append("\r\n").append("To:").append(this.partnership().getAllReceiverIDs().toString()).append("\r\n").append("Headers:").append(this.headers().toString()).append("\r\n").append("Attributes:").append(this.attrs().toString()).append("\r\n").append("Text:").append("\r\n").append(this.getText()).append("\r\n");
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Message", this.m_aMessage != null ? this.m_aMessage.getMessageID() : null).append("Data", (Object)this.m_aData).append("Text", (Object)this.m_sText).getToString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.m_sText = (String)objectInputStream.readObject();
        try {
            this.m_aData = objectInputStream.read() == 1 ? new MimeBodyPart((InputStream)objectInputStream) : null;
        }
        catch (MessagingException messagingException) {
            throw new IOException("Messaging exception", messagingException);
        }
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.m_sText);
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        try {
            if (this.m_aData != null) {
                nonBlockingByteArrayOutputStream.write(1);
                this.m_aData.writeTo((OutputStream)nonBlockingByteArrayOutputStream);
            } else {
                nonBlockingByteArrayOutputStream.write(0);
            }
            nonBlockingByteArrayOutputStream.writeTo((OutputStream)objectOutputStream);
        }
        catch (MessagingException messagingException) {
            throw new IOException("Messaging exception", messagingException);
        }
        finally {
            StreamHelper.close((AutoCloseable)nonBlockingByteArrayOutputStream);
        }
    }
}

