/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.params;

import com.helger.as2lib.message.IMessageMDN;
import com.helger.as2lib.params.AS2InvalidParameterException;
import com.helger.as2lib.params.AbstractParameterParser;
import com.helger.as2lib.params.MessageParameters;
import com.helger.commons.ValueEnforcer;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MessageMDNParameters
extends AbstractParameterParser {
    public static final String KEY_MESSAGE = "msg";
    public static final String KEY_SENDER = "sender";
    public static final String KEY_RECEIVER = "receiver";
    public static final String KEY_TEXT = "text";
    public static final String KEY_ATTRIBUTES = "attributes";
    public static final String KEY_HEADERS = "headers";
    private final IMessageMDN m_aTarget;

    public MessageMDNParameters(@Nonnull IMessageMDN iMessageMDN) {
        this.m_aTarget = (IMessageMDN)ValueEnforcer.notNull((Object)iMessageMDN, (String)"Target");
    }

    @Override
    public void setParameter(String string, String string2) throws AS2InvalidParameterException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        if (stringTokenizer.countTokens() < 2) {
            throw new AS2InvalidParameterException("Invalid key format", this, "key", string);
        }
        String string3 = stringTokenizer.nextToken();
        if (string3.equals(KEY_MESSAGE)) {
            if (stringTokenizer.countTokens() < 3) {
                throw new AS2InvalidParameterException("Invalid key format", this, "key", string);
            }
            String string4 = stringTokenizer.nextToken() + "." + stringTokenizer.nextToken();
            new MessageParameters(this.m_aTarget.getMessage()).setParameter(string4, string2);
        } else {
            String string5 = stringTokenizer.nextToken();
            if (string3.equals(KEY_TEXT)) {
                this.m_aTarget.setText(string2);
            } else if (string3.equals(KEY_ATTRIBUTES)) {
                this.m_aTarget.attrs().putIn((Object)string5, (Object)string2);
            } else if (string3.equals(KEY_HEADERS)) {
                this.m_aTarget.headers().setHeader(string5, string2);
            } else {
                throw new AS2InvalidParameterException("Invalid area in key", this, "key", string);
            }
        }
    }

    @Override
    @Nullable
    public String getParameter(String string) throws AS2InvalidParameterException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        if (stringTokenizer.countTokens() > 2) {
            stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken() + "." + stringTokenizer.nextToken();
            return new MessageParameters(this.m_aTarget.getMessage()).getParameter(string2);
        }
        if (stringTokenizer.countTokens() < 2) {
            throw new AS2InvalidParameterException("Invalid key format", this, "key", string);
        }
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        if (string3.equals(KEY_SENDER)) {
            return this.m_aTarget.partnership().getSenderID(string4);
        }
        if (string3.equals(KEY_RECEIVER)) {
            return this.m_aTarget.partnership().getReceiverID(string4);
        }
        if (string3.equals(KEY_TEXT)) {
            return this.m_aTarget.getText();
        }
        if (string3.equals(KEY_ATTRIBUTES)) {
            return this.m_aTarget.attrs().getAsString((Object)string4);
        }
        if (string3.equals(KEY_HEADERS)) {
            return this.m_aTarget.getHeader(string4);
        }
        throw new AS2InvalidParameterException("Invalid area in key", this, "key", string);
    }
}

