/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.partner.xml;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.exception.WrappedAS2Exception;
import com.helger.as2lib.params.AS2InvalidParameterException;
import com.helger.as2lib.partner.IRefreshablePartnershipFactory;
import com.helger.as2lib.partner.Partnership;
import com.helger.as2lib.partner.PartnershipMap;
import com.helger.as2lib.partner.xml.AbstractPartnershipFactoryWithPartners;
import com.helger.as2lib.partner.xml.IPartner;
import com.helger.as2lib.partner.xml.IPartnerMap;
import com.helger.as2lib.partner.xml.Partner;
import com.helger.as2lib.partner.xml.PartnerMap;
import com.helger.as2lib.session.IAS2Session;
import com.helger.as2lib.util.AS2IOHelper;
import com.helger.as2lib.util.AS2XMLHelper;
import com.helger.commons.collection.attr.IStringMap;
import com.helger.commons.collection.attr.StringMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.string.StringHelper;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.microdom.serialize.MicroWriter;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.WillClose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLPartnershipFactory
extends AbstractPartnershipFactoryWithPartners
implements IRefreshablePartnershipFactory {
    public static final String ATTR_FILENAME = "filename";
    public static final String ATTR_DISABLE_BACKUP = "disablebackup";
    private static final String ATTR_PARTNER_NAME = "name";
    private static final String ATTR_PARTNERSHIP_NAME = "name";
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLPartnershipFactory.class);

    @Nonnull
    public String getFilename() throws AS2InvalidParameterException {
        return this.getAttributeAsStringRequired(ATTR_FILENAME);
    }

    public void setFilename(String string) {
        this.attrs().putIn((Object)ATTR_FILENAME, (Object)string);
    }

    public boolean isDisableBackup() {
        return this.attrs().containsKey((Object)ATTR_DISABLE_BACKUP);
    }

    public void setDisableBackup(boolean bl) {
        if (bl) {
            this.attrs().putIn(ATTR_DISABLE_BACKUP, true);
        } else {
            this.attrs().remove((Object)ATTR_DISABLE_BACKUP);
        }
    }

    @Override
    public void initDynamicComponent(@Nonnull IAS2Session iAS2Session, @Nullable IStringMap iStringMap) throws AS2Exception {
        super.initDynamicComponent(iAS2Session, iStringMap);
        this.refreshPartnershipFactory();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void refreshPartnershipFactory() throws AS2Exception {
        try {
            File file = new File(this.getFilename());
            this.load(FileHelper.getInputStream((File)file));
        }
        catch (Exception exception) {
            throw WrappedAS2Exception.wrap(exception);
        }
    }

    protected void load(@Nullable @WillClose InputStream inputStream) throws AS2Exception {
        PartnerMap partnerMap = new PartnerMap();
        PartnershipMap partnershipMap = new PartnershipMap();
        if (inputStream != null) {
            IMicroDocument iMicroDocument = MicroReader.readMicroXML((InputStream)inputStream);
            if (iMicroDocument == null) {
                throw new AS2Exception("Failed to read the XML partnership information");
            }
            IMicroElement iMicroElement = iMicroDocument.getDocumentElement();
            for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements()) {
                Object object;
                String string = iMicroElement2.getTagName();
                if (string.equals("partner")) {
                    object = this.loadPartner(iMicroElement2);
                    partnerMap.addPartner((Partner)object);
                    continue;
                }
                if (string.equals("partnership")) {
                    object = this.loadPartnership(iMicroElement2, partnerMap);
                    if (partnershipMap.getPartnershipByName(((Partnership)object).getName()) != null) {
                        throw new AS2Exception("Partnership with name '" + ((Partnership)object).getName() + "' is defined more than once");
                    }
                    partnershipMap.addPartnership((Partnership)object);
                    continue;
                }
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("Invalid element '" + string + "' in XML partnership file");
            }
        }
        this.setPartners(partnerMap);
        this.setPartnerships(partnershipMap);
    }

    protected void loadPartnershipAttributes(@Nonnull IMicroElement iMicroElement, @Nonnull Partnership partnership) throws AS2Exception {
        ICommonsOrderedMap<String, String> iCommonsOrderedMap = AS2XMLHelper.mapAttributeNodes(iMicroElement, "attribute", "name", "value");
        partnership.addAllAttributes((Map<String, String>)iCommonsOrderedMap);
    }

    @Nonnull
    public Partner loadPartner(@Nonnull IMicroElement iMicroElement) throws AS2Exception {
        StringMap stringMap = AS2XMLHelper.getAllAttrsWithLowercaseNameWithRequired(iMicroElement, "name");
        return new Partner((IStringMap)stringMap);
    }

    protected void loadPartnerIDs(@Nonnull IMicroElement iMicroElement, @Nonnull IPartnerMap iPartnerMap, @Nonnull Partnership partnership, boolean bl) throws AS2Exception {
        String string = bl ? "sender" : "receiver";
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string);
        if (iMicroElement2 == null) {
            throw new AS2Exception("Partnership '" + partnership.getName() + "' is missing '" + string + "' child element");
        }
        StringMap stringMap = AS2XMLHelper.getAllAttrsWithLowercaseName(iMicroElement2);
        String string2 = stringMap.getAsString((Object)"name");
        if (string2 != null) {
            IPartner iPartner = iPartnerMap.getPartnerOfName(string2);
            if (iPartner == null) {
                throw new AS2Exception("Partnership '" + partnership.getName() + "' has a non-existing " + string + " partner: '" + string2 + "'");
            }
            if (bl) {
                partnership.addSenderIDs((Map<String, String>)iPartner.getAllAttributes());
            } else {
                partnership.addReceiverIDs((Map<String, String>)iPartner.getAllAttributes());
            }
        }
        if (bl) {
            partnership.addSenderIDs((Map<String, String>)stringMap);
        } else {
            partnership.addReceiverIDs((Map<String, String>)stringMap);
        }
    }

    @Nonnull
    public Partnership loadPartnership(@Nonnull IMicroElement iMicroElement, @Nonnull IPartnerMap iPartnerMap) throws AS2Exception {
        StringMap stringMap = AS2XMLHelper.getAllAttrsWithLowercaseNameWithRequired(iMicroElement, "name");
        Partnership partnership = new Partnership(stringMap.getAsString((Object)"name"));
        this.loadPartnerIDs(iMicroElement, iPartnerMap, partnership, true);
        this.loadPartnerIDs(iMicroElement, iPartnerMap, partnership, false);
        this.loadPartnershipAttributes(iMicroElement, partnership);
        return partnership;
    }

    @Nonnull
    private static File _getUniqueBackupFile(@Nonnull String string) {
        File file;
        long l = 0L;
        do {
            file = new File(string + '.' + StringHelper.getLeadingZero((long)l, (int)7));
            ++l;
        } while (file.exists());
        return file;
    }

    public void storePartnership() throws AS2Exception {
        Object object;
        Iterator iterator;
        IMicroElement iMicroElement;
        Object object2;
        File file;
        String string = this.getFilename();
        if (!this.isDisableBackup()) {
            file = XMLPartnershipFactory._getUniqueBackupFile(string);
            if (LOGGER.isWarnEnabled()) {
                LOGGER.info("backing up " + string + " to " + file.getName());
            }
            object2 = new File(string);
            AS2IOHelper.getFileOperationManager().renameFile((File)object2, file);
        }
        file = new MicroDocument();
        object2 = file.appendElement("partnerships");
        for (Object object3 : this.getAllPartners()) {
            iMicroElement = object2.appendElement("partner");
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                object = (Map.Entry)iterator.next();
                iMicroElement.setAttribute((String)object.getKey(), (String)object.getValue());
            }
        }
        for (Object object3 : this.getAllPartnerships()) {
            Iterator iterator22;
            iMicroElement = object2.appendElement("partnership");
            iMicroElement.setAttribute("name", ((Partnership)object3).getName());
            iterator = iMicroElement.appendElement("sender");
            for (Iterator iterator22 : ((Partnership)object3).getAllSenderIDs().entrySet()) {
                iterator.setAttribute((String)iterator22.getKey(), (String)iterator22.getValue());
            }
            object = iMicroElement.appendElement("receiver");
            for (Map.Entry entry : ((Partnership)object3).getAllReceiverIDs().entrySet()) {
                object.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            iterator22 = ((Partnership)object3).getAllAttributes().entrySet().iterator();
            while (iterator22.hasNext()) {
                Map.Entry entry;
                entry = (Map.Entry)iterator22.next();
                ((IMicroElement)iMicroElement.appendElement("attribute").setAttribute("name", (String)entry.getKey())).setAttribute("value", (String)entry.getValue());
            }
        }
        if (MicroWriter.writeToFile((IMicroNode)file, (File)new File(string)).isFailure()) {
            throw new AS2Exception("Failed to write to file " + string);
        }
    }
}

