/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.resender;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.exception.WrappedAS2Exception;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.params.AS2InvalidParameterException;
import com.helger.as2lib.processor.resender.AbstractActiveResenderModule;
import com.helger.as2lib.session.IAS2Session;
import com.helger.as2lib.util.AS2DateHelper;
import com.helger.as2lib.util.AS2IOHelper;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.attr.IStringMap;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.datetime.PDTFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryResenderModule
extends AbstractActiveResenderModule {
    public static final String ATTR_RESEND_DIRECTORY = "resenddir";
    public static final String ATTR_ERROR_DIRECTORY = "errordir";
    private static final String FILENAME_DATE_FORMAT = "MM-dd-uu-HH-mm-ss";
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryResenderModule.class);

    @Override
    public void initDynamicComponent(@Nonnull IAS2Session iAS2Session, @Nullable IStringMap iStringMap) throws AS2Exception {
        super.initDynamicComponent(iAS2Session, iStringMap);
        this.getAttributeAsStringRequired(ATTR_RESEND_DIRECTORY);
        this.getAttributeAsStringRequired(ATTR_ERROR_DIRECTORY);
    }

    @Override
    public boolean canHandle(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) {
        return string.equals("resend");
    }

    @Override
    public void handle(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) throws AS2Exception {
        try {
            File file = AS2IOHelper.getDirectoryFile(this.getAttributeAsStringRequired(ATTR_RESEND_DIRECTORY));
            File file2 = AS2IOHelper.getUniqueFile(file, this.getFilename());
            try (FileOutputStream fileOutputStream = new FileOutputStream(file2);
                 ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);){
                String string2;
                String string3;
                String string4 = string3 = map == null ? null : (String)map.get("resend_method");
                if (string3 == null) {
                    LOGGER.warn("The resending method is missing - default to message sending!");
                    string3 = "send";
                }
                String string5 = string2 = map == null ? null : (String)map.get("retries");
                if (string2 == null) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("The resending retry count is missing - default to 0!");
                    }
                    string2 = Integer.toString(0);
                }
                objectOutputStream.writeObject(string3);
                objectOutputStream.writeObject(string2);
                objectOutputStream.writeObject(iMessage);
            }
            LOGGER.info("Message put in resend queue" + iMessage.getLoggingText());
        }
        catch (IOException iOException) {
            throw WrappedAS2Exception.wrap(iOException);
        }
    }

    @Nonnull
    protected String getFilename() throws AS2InvalidParameterException {
        long l = this.getResendDelayMS();
        return AS2DateHelper.formatDate(FILENAME_DATE_FORMAT, PDTFactory.getCurrentZonedDateTime().plus(l, ChronoUnit.MILLIS));
    }

    protected boolean isTimeToSend(@Nonnull File file) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(file.getName(), ".", false);
            LocalDateTime localDateTime = AS2DateHelper.parseDate(FILENAME_DATE_FORMAT, stringTokenizer.nextToken());
            return localDateTime.isBefore(PDTFactory.getCurrentLocalDateTime());
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected void resendFile(@Nonnull File file) throws AS2Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing " + file.getAbsolutePath());
        }
        IMessage iMessage = null;
        try {
            try {
                String string;
                String string2;
                try (FileInputStream fileInputStream = new FileInputStream(file);
                     ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);){
                    string2 = (String)objectInputStream.readObject();
                    string = (String)objectInputStream.readObject();
                    iMessage = (IMessage)objectInputStream.readObject();
                }
                string = Integer.toString(Integer.parseInt(string) - 1);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("loaded message for resend." + iMessage.getLoggingText());
                }
                fileInputStream = new CommonsHashMap();
                fileInputStream.put("retries", string);
                this.getSession().getMessageProcessor().handle(string2, iMessage, (Map<String, Object>)((Object)fileInputStream));
                if (AS2IOHelper.getFileOperationManager().deleteFile(file).isFailure()) {
                    throw new AS2Exception("File was successfully sent but not deleted: " + file.getAbsolutePath());
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("deleted " + file.getAbsolutePath() + iMessage.getLoggingText());
                }
            }
            catch (IOException | ClassNotFoundException exception) {
                throw WrappedAS2Exception.wrap(exception);
            }
        }
        catch (AS2Exception aS2Exception) {
            aS2Exception.setSourceMsg(iMessage).setSourceFile(file).terminate();
            AS2IOHelper.handleError(file, this.getAttributeAsStringRequired(ATTR_ERROR_DIRECTORY));
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    protected ICommonsList<File> scanDirectory() throws AS2InvalidParameterException {
        File file = AS2IOHelper.getDirectoryFile(this.getAttributeAsStringRequired(ATTR_RESEND_DIRECTORY));
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new AS2InvalidParameterException("Error getting list of files in directory", this, ATTR_RESEND_DIRECTORY, file.getAbsolutePath());
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (fileArray.length > 0) {
            for (File file2 : fileArray) {
                if (!file2.exists() || !file2.isFile() || !file2.canWrite() || !this.isTimeToSend(file2)) continue;
                commonsArrayList.add((Object)file2);
            }
        }
        return commonsArrayList;
    }

    @Override
    public void resend() {
        try {
            ICommonsList<File> iCommonsList = this.scanDirectory();
            for (File file : iCommonsList) {
                this.resendFile(file);
            }
        }
        catch (AS2Exception aS2Exception) {
            aS2Exception.terminate();
            this.forceStop(aS2Exception);
        }
    }
}

