/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.resender;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.processor.resender.AbstractActiveResenderModule;
import com.helger.as2lib.processor.resender.ResendItem;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryResenderModule
extends AbstractActiveResenderModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryResenderModule.class);
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<ResendItem> m_aItems = new CommonsArrayList();

    @Override
    public boolean canHandle(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) {
        return string.equals("resend");
    }

    @Override
    public void handle(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) throws AS2Exception {
        int n;
        String string2;
        String string3;
        String string4 = string3 = map == null ? null : (String)map.get("resend_method");
        if (string3 == null) {
            LOGGER.warn("The resending action is missing - default to message sending!");
            string3 = "send";
        }
        String string5 = string2 = map == null ? null : (String)map.get("retries");
        if (string2 != null) {
            n = Integer.parseInt(string2);
        } else {
            n = 0;
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("The resending retry count is missing - default to " + n + "!");
            }
        }
        ResendItem resendItem = new ResendItem(string3, n, iMessage, this.getResendDelayMS());
        this.m_aRWLock.writeLockedBoolean(() -> this.m_aItems.add((Object)resendItem));
        LOGGER.info("Message put in resend queue" + iMessage.getLoggingText());
    }

    protected void resendItem(@Nonnull ResendItem resendItem) throws AS2Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resending item");
        }
        IMessage iMessage = null;
        try {
            String string = resendItem.getResendAction();
            String string2 = Integer.toString(resendItem.getRetries() - 1);
            iMessage = resendItem.getMessage();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Loaded message for resend" + iMessage.getLoggingText());
            }
            CommonsHashMap commonsHashMap = new CommonsHashMap();
            commonsHashMap.put((Object)"retries", (Object)string2);
            this.getSession().getMessageProcessor().handle(string, iMessage, (Map<String, Object>)commonsHashMap);
            this.m_aRWLock.writeLockedBoolean(() -> this.m_aItems.remove((Object)resendItem));
        }
        catch (AS2Exception aS2Exception) {
            throw aS2Exception.setSourceMsg(iMessage);
        }
    }

    @Override
    public void resend() {
        try {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            this.m_aRWLock.readLocked(() -> this.lambda$resend$2((ICommonsList)commonsArrayList));
            for (ResendItem resendItem : commonsArrayList) {
                this.resendItem(resendItem);
            }
        }
        catch (AS2Exception aS2Exception) {
            aS2Exception.terminate();
            this.forceStop(aS2Exception);
        }
    }

    @Nonnegative
    public int getResendItemCount() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aItems.size());
    }

    public void removeAllResendItems() {
        int n = this.getResendItemCount();
        if (n > 0) {
            this.m_aRWLock.writeLocked(() -> this.m_aItems.clear());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Removed " + n + " items from InMemoryResenderModule");
            }
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ResendItem> getAllResendItems() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aItems.getClone());
    }

    @Override
    public void doStop() throws AS2Exception {
        int n = this.getResendItemCount();
        if (n > 0 && LOGGER.isErrorEnabled()) {
            LOGGER.error("InMemoryResenderModule is stopped but " + n + " items are still contained. They are discarded and will be lost!");
        }
        super.doStop();
    }

    private /* synthetic */ void lambda$resend$2(ICommonsList iCommonsList) {
        this.m_aItems.findAll(ResendItem::isTimeToSend, arg_0 -> iCommonsList.add(arg_0));
    }
}

