/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.storage;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.exception.WrappedAS2Exception;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.message.IMessageMDN;
import com.helger.as2lib.params.AS2InvalidParameterException;
import com.helger.as2lib.params.CompositeParameters;
import com.helger.as2lib.params.DateParameters;
import com.helger.as2lib.params.MessageMDNParameters;
import com.helger.as2lib.processor.storage.AbstractStorageModule;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.system.ENewLineMode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDNFileModule
extends AbstractStorageModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(MDNFileModule.class);

    public MDNFileModule() {
        super("storemdn");
    }

    @Override
    public void handle(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) throws AS2Exception {
        if (iMessage.getMDN() == null) {
            throw new AS2Exception("Message has no MDN");
        }
        try {
            File file = this.getFile(iMessage, this.getAttributeAsStringRequired("filename"));
            InputStream inputStream = this.getMDNStream(iMessage.getMDN());
            this.store(file, inputStream);
            LOGGER.info("stored MDN to " + file.getAbsolutePath());
        }
        catch (IOException iOException) {
            throw WrappedAS2Exception.wrap(iOException);
        }
    }

    @Override
    protected String getFilename(@Nonnull IMessage iMessage, @Nullable String string) throws AS2InvalidParameterException {
        IMessageMDN iMessageMDN = iMessage.getMDN();
        CompositeParameters compositeParameters = new CompositeParameters(false).add("date", new DateParameters()).add("mdn", new MessageMDNParameters(iMessageMDN));
        return compositeParameters.format(string);
    }

    @Nonnull
    protected InputStream getMDNStream(@Nonnull IMessageMDN iMessageMDN) {
        String string = ENewLineMode.DEFAULT.getText();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MDN Headers:").append(string);
        iMessageMDN.headers().forEachHeaderLine(string2 -> stringBuilder.append((String)string2).append(string), true);
        stringBuilder.append(string);
        stringBuilder.append("MDN Attributes:").append(string);
        for (Map.Entry entry : iMessageMDN.attrs().entrySet()) {
            stringBuilder.append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append(string);
        }
        stringBuilder.append("Text:").append(string).append(iMessageMDN.getText());
        return new NonBlockingByteArrayInputStream(stringBuilder.toString().getBytes(this.getCharset()));
    }
}

