/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util.http;

import com.helger.as2lib.util.http.IAS2InputStreamProvider;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.stream.NonClosingInputStream;
import com.helger.commons.io.stream.StreamHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AS2InputStreamProviderSocket
implements IAS2InputStreamProvider {
    private final Socket m_aSocket;
    private final boolean m_bNonUpwardClosing;

    public AS2InputStreamProviderSocket(@Nonnull Socket socket) {
        ValueEnforcer.notNull((Object)socket, (String)"Socket");
        this.m_aSocket = socket;
        this.m_bNonUpwardClosing = true;
    }

    @Override
    @Nonnull
    public InputStream getInputStream() throws IOException {
        if (this.m_bNonUpwardClosing) {
            return this.getNonUpwardClosingInputStream();
        }
        return StreamHelper.getBuffered((InputStream)this.m_aSocket.getInputStream());
    }

    @Override
    @Nonnull
    public InputStream getNonUpwardClosingInputStream() throws IOException {
        return StreamHelper.getBuffered((InputStream)new NonClosingInputStream(this.m_aSocket.getInputStream()));
    }
}

