/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util.http;

import com.helger.as2lib.util.http.HTTPHelper;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedInputStream
extends FilterInputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkedInputStream.class);
    private int m_nLeft = 0;
    private final InputStream m_aIS;
    private boolean m_bAfterFirstChunk = false;

    public ChunkedInputStream(@Nonnull InputStream inputStream) {
        super(inputStream);
        this.m_aIS = inputStream;
    }

    @Override
    public final int read() throws IOException {
        if (this.m_nLeft < 0) {
            return -1;
        }
        if (this.m_nLeft == 0) {
            if (this.m_bAfterFirstChunk) {
                HTTPHelper.readTillNexLine(this.m_aIS);
            } else {
                this.m_bAfterFirstChunk = true;
            }
            this.m_nLeft = HTTPHelper.readChunkLen(this.m_aIS);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Read chunk size: " + this.m_nLeft);
            }
            if (this.m_nLeft <= 0) {
                this.m_nLeft = -1;
                return -1;
            }
        }
        --this.m_nLeft;
        return super.read();
    }

    @Override
    public final int read(@Nonnull byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (this.m_nLeft < 0) {
            return -1;
        }
        int n5 = n;
        for (n3 = 0; n2 > n3; n3 += n4) {
            if (this.m_nLeft == 0) {
                if (this.m_bAfterFirstChunk) {
                    HTTPHelper.readTillNexLine(this.m_aIS);
                } else {
                    this.m_bAfterFirstChunk = true;
                }
                this.m_nLeft = HTTPHelper.readChunkLen(this.m_aIS);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Read chunk size: " + this.m_nLeft);
                }
                if (this.m_nLeft <= 0) {
                    this.m_nLeft = -1;
                    return n3 > 0 ? n3 : -1;
                }
            }
            n4 = super.read(byArray, n5, Math.min(n2 - n3, this.m_nLeft));
            n5 += n4;
            this.m_nLeft -= n4;
        }
        return n3;
    }
}

