/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.session;

import com.helger.as2lib.IDynamicComponent;
import com.helger.as2lib.cert.ICertificateFactory;
import com.helger.as2lib.partner.IPartnershipFactory;
import com.helger.as2lib.processor.IMessageProcessor;
import com.helger.as2lib.session.AS2ComponentDuplicateException;
import com.helger.as2lib.session.AS2ComponentNotFoundException;
import com.helger.as2lib.session.IAS2Session;
import com.helger.as2lib.util.javamail.DispositionDataContentHandler;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.lang.priviledged.AccessControllerHelper;
import com.helger.commons.string.ToStringGenerator;
import jakarta.activation.CommandMap;
import jakarta.activation.MailcapCommandMap;
import java.net.Proxy;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class AS2Session
implements IAS2Session {
    public static final String COMPONENT_ID_CERTIFICATE_FACTORY = "certificatefactory";
    public static final String COMPONENT_ID_PARTNERSHIP_FACTORY = "partnershipfactory";
    public static final String COMPONENT_ID_MESSAGE_PROCESSOR = "message-processor";
    public static final boolean DEFAULT_CRYPTO_SIGN_INCLUDE_CERTIFICATE_IN_BODY_PART = true;
    public static final boolean DEFAULT_CRYPTO_VERIFY_USE_CERTIFICATE_IN_BODY_PART = true;
    private final ICommonsMap<String, IDynamicComponent> m_aComponents = new CommonsHashMap();
    private boolean m_bCryptoSignIncludeCertificateInBodyPart = true;
    private boolean m_bCryptoVerifyUseCertificateInBodyPart = true;
    private Proxy m_aHttpProxy;
    private String m_sAS2VersionID = "1.1";

    public static void makeAS2CommandMapChanges() {
        MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcapCommandMap.addMailcap("message/disposition-notification;; x-java-content-handler=" + DispositionDataContentHandler.class.getName());
        AccessControllerHelper.run(() -> {
            CommandMap.setDefaultCommandMap((CommandMap)mailcapCommandMap);
            return null;
        });
    }

    public AS2Session() {
        AS2Session.makeAS2CommandMapChanges();
    }

    @Override
    public final void addComponent(@Nonnull @Nonempty String string, @Nonnull IDynamicComponent iDynamicComponent) throws AS2ComponentDuplicateException {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ComponentID");
        ValueEnforcer.notNull((Object)iDynamicComponent, (String)"Component");
        if (this.m_aComponents.containsKey((Object)string)) {
            throw new AS2ComponentDuplicateException(string);
        }
        this.m_aComponents.put((Object)string, (Object)iDynamicComponent);
    }

    public void setCertificateFactory(@Nonnull ICertificateFactory iCertificateFactory) throws AS2ComponentDuplicateException {
        this.addComponent(COMPONENT_ID_CERTIFICATE_FACTORY, iCertificateFactory);
    }

    public void setPartnershipFactory(@Nonnull IPartnershipFactory iPartnershipFactory) throws AS2ComponentDuplicateException {
        this.addComponent(COMPONENT_ID_PARTNERSHIP_FACTORY, iPartnershipFactory);
    }

    public void setMessageProcessor(@Nonnull IMessageProcessor iMessageProcessor) throws AS2ComponentDuplicateException {
        this.addComponent(COMPONENT_ID_MESSAGE_PROCESSOR, iMessageProcessor);
    }

    @Override
    @Nonnull
    public final IDynamicComponent getComponent(@Nonnull @Nonempty String string) throws AS2ComponentNotFoundException {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ComponentID");
        IDynamicComponent iDynamicComponent = (IDynamicComponent)this.m_aComponents.get((Object)string);
        if (iDynamicComponent == null) {
            throw new AS2ComponentNotFoundException(string);
        }
        return iDynamicComponent;
    }

    @Nonnull
    @ReturnsMutableObject
    protected final ICommonsMap<String, IDynamicComponent> components() {
        return this.m_aComponents;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsMap<String, IDynamicComponent> getAllComponents() {
        return (ICommonsMap)this.m_aComponents.getClone();
    }

    @Override
    @Nonnull
    public final ICertificateFactory getCertificateFactory() throws AS2ComponentNotFoundException {
        return (ICertificateFactory)this.getComponent(COMPONENT_ID_CERTIFICATE_FACTORY);
    }

    @Override
    @Nonnull
    public final IPartnershipFactory getPartnershipFactory() throws AS2ComponentNotFoundException {
        return (IPartnershipFactory)this.getComponent(COMPONENT_ID_PARTNERSHIP_FACTORY);
    }

    @Override
    @Nonnull
    public final IMessageProcessor getMessageProcessor() throws AS2ComponentNotFoundException {
        return (IMessageProcessor)this.getComponent(COMPONENT_ID_MESSAGE_PROCESSOR);
    }

    @Override
    public final boolean isCryptoSignIncludeCertificateInBodyPart() {
        return this.m_bCryptoSignIncludeCertificateInBodyPart;
    }

    @Override
    public final void setCryptoSignIncludeCertificateInBodyPart(boolean bl) {
        this.m_bCryptoSignIncludeCertificateInBodyPart = bl;
    }

    @Override
    public final boolean isCryptoVerifyUseCertificateInBodyPart() {
        return this.m_bCryptoVerifyUseCertificateInBodyPart;
    }

    @Override
    public final void setCryptoVerifyUseCertificateInBodyPart(boolean bl) {
        this.m_bCryptoVerifyUseCertificateInBodyPart = bl;
    }

    @Override
    @Nullable
    public final Proxy getHttpProxy() {
        return this.m_aHttpProxy;
    }

    @Override
    public final void setHttpProxy(@Nullable Proxy proxy) {
        this.m_aHttpProxy = proxy;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getAS2VersionID() {
        return this.m_sAS2VersionID;
    }

    @Override
    public final void setAS2VersionID(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"AS2Version");
        this.m_sAS2VersionID = string;
    }

    @OverridingMethodsMustInvokeSuper
    public void resetToDefault() {
        this.components().clear();
        this.setCryptoSignIncludeCertificateInBodyPart(true);
        this.setCryptoVerifyUseCertificateInBodyPart(true);
        this.setHttpProxy(null);
        this.setAS2VersionID("1.1");
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Components", this.m_aComponents).append("CryptoSignIncludeCertificateInBodyPart", this.m_bCryptoSignIncludeCertificateInBodyPart).append("CryptoVerifyUseCertificateInBodyPart", this.m_bCryptoVerifyUseCertificateInBodyPart).append("HttpProxy", (Object)this.m_aHttpProxy).append("AS2VersionID", (Object)this.m_sAS2VersionID).getToString();
    }
}

