/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2servlet;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.message.AS2Message;
import com.helger.as2lib.processor.receiver.net.AS2ReceiverHandler;
import com.helger.as2lib.util.AS2HttpHelper;
import com.helger.as2lib.util.http.IAS2HttpResponseHandler;
import com.helger.as2servlet.AbstractAS2ReceiveBaseXServletHandler;
import com.helger.as2servlet.util.AS2ServletReceiverModule;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.impl.ICommonsMap;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAS2ReceiveXServletHandler
extends AbstractAS2ReceiveBaseXServletHandler {
    public static final String SERVLET_INIT_PARAM_AS2_SERVLET_CONFIG_FILENAME = "as2-servlet-config-filename";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAS2ReceiveXServletHandler.class);
    private AS2ServletReceiverModule m_aReceiver;

    @Override
    public void onServletInit(@Nonnull ICommonsMap<String, String> iCommonsMap) throws ServletException {
        super.onServletInit(iCommonsMap);
        try {
            this.m_aReceiver = (AS2ServletReceiverModule)this.getSession().getMessageProcessor().getModuleOfClass(AS2ServletReceiverModule.class);
            if (this.m_aReceiver == null) {
                throw new ServletException("Failed to retrieve 'AS2ServletReceiverModule' which is a mandatory module! Please ensure your configuration file contains at least the module '" + AS2ServletReceiverModule.class.getName() + "'");
            }
        }
        catch (AS2Exception aS2Exception) {
            throw new ServletException("Failed to init AS2 configuration", (Throwable)aS2Exception);
        }
        LOGGER.info("Successfully initialized AS2 configuration");
    }

    @Nonnull
    protected final AS2ServletReceiverModule getReceiverModule() {
        if (this.m_aReceiver == null) {
            throw new IllegalStateException("This servlet was not initialized properly! No receiver is present.");
        }
        return this.m_aReceiver;
    }

    @Override
    protected final boolean isQuoteHeaderValues() {
        return this.m_aReceiver.isQuoteHeaderValues();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void handleIncomingMessage(@Nonnull String string, @Nonnull DataSource dataSource, @Nonnull AS2Message aS2Message, @Nonnull IAS2HttpResponseHandler iAS2HttpResponseHandler) throws ServletException {
        String string2 = AS2HttpHelper.getCleanContentType((String)aS2Message.getHeader("Content-Type"));
        if (string2 == null) {
            throw new ServletException("Incoming message does not contain a valid Content-Type: '" + aS2Message.getHeader("Content-Type") + "'");
        }
        AS2ReceiverHandler aS2ReceiverHandler = this.getReceiverModule().createHandler();
        aS2ReceiverHandler.handleIncomingMessage(string, dataSource, aS2Message, iAS2HttpResponseHandler);
    }
}

