/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2servlet.mdn;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.message.AS2Message;
import com.helger.as2lib.processor.receiver.net.AS2MDNReceiverHandler;
import com.helger.as2lib.session.AS2Session;
import com.helger.as2lib.util.AS2HttpHelper;
import com.helger.as2lib.util.http.IAS2HttpResponseHandler;
import com.helger.as2servlet.AbstractAS2ReceiveBaseXServletHandler;
import com.helger.as2servlet.util.AS2ServletMDNReceiverModule;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.impl.ICommonsMap;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAS2MDNReceiveXServletHandler
extends AbstractAS2ReceiveBaseXServletHandler {
    public static final String SERVLET_INIT_PARAM_AS2_SERVLET_CONFIG_FILENAME = "as2-servlet-config-filename";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAS2MDNReceiveXServletHandler.class);
    private AS2ServletMDNReceiverModule m_aReceiver;

    @Override
    @Nonnull
    @OverrideOnDemand
    protected abstract AS2Session createAS2Session(@Nonnull ICommonsMap<String, String> var1) throws AS2Exception, ServletException;

    @Override
    public void onServletInit(@Nonnull ICommonsMap<String, String> iCommonsMap) throws ServletException {
        super.onServletInit(iCommonsMap);
        try {
            this.m_aReceiver = (AS2ServletMDNReceiverModule)this.getSession().getMessageProcessor().getModuleOfClass(AS2ServletMDNReceiverModule.class);
            if (this.m_aReceiver == null) {
                throw new ServletException("Failed to retrieve 'AS2ServletMDNReceiverModule' which is a mandatory module! Please ensure your configuration file contains at least the module '" + AS2ServletMDNReceiverModule.class.getName() + "'");
            }
        }
        catch (AS2Exception aS2Exception) {
            throw new ServletException("Failed to init AS2 configuration", (Throwable)aS2Exception);
        }
        LOGGER.info("Successfully initialized AS2 configuration");
    }

    @Nonnull
    protected final AS2ServletMDNReceiverModule getMDNReceiverModule() {
        if (this.m_aReceiver == null) {
            throw new IllegalStateException("This servlet was not initialized properly! No receiver is present.");
        }
        return this.m_aReceiver;
    }

    @Override
    protected final boolean isQuoteHeaderValues() {
        return this.m_aReceiver.isQuoteHeaderValues();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected void handleIncomingMessage(@Nonnull String string, @Nonnull DataSource dataSource, @Nonnull AS2Message aS2Message, @Nonnull IAS2HttpResponseHandler iAS2HttpResponseHandler) throws ServletException {
        String string2 = AS2HttpHelper.getCleanContentType((String)aS2Message.getHeader("Content-Type"));
        if (string2 == null) {
            throw new ServletException("Incoming message does not contain a valid Content-Type: '" + aS2Message.getHeader("Content-Type") + "'");
        }
        AS2MDNReceiverHandler aS2MDNReceiverHandler = this.getMDNReceiverModule().createHandler();
        aS2MDNReceiverHandler.handleIncomingMessage(string, dataSource, aS2Message, iAS2HttpResponseHandler);
    }
}

