/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.string;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.functional.IBooleanPredicate;
import com.helger.commons.functional.ICharPredicate;
import com.helger.commons.string.StringHelper;
import java.util.Arrays;
import java.util.function.BooleanSupplier;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ToStringGenerator {
    public static final String CONSTANT_NULL = "null";
    public static final String CONSTANT_THIS = "this";
    public static final String CONSTANT_PASSWORD = "****";
    private static final int FIRST_FIELD = 1;
    private static final int APPENDED_CLOSING_BRACKET = 2;
    private final StringBuilder m_aSB = new StringBuilder("[");
    private final Object m_aSrc;
    private int m_nIndex = 0;

    public ToStringGenerator(@Nullable Object object) {
        if (object != null) {
            String string = object.getClass().getName();
            int n = string.lastIndexOf(46);
            this.m_aSB.append(n == -1 ? string : string.substring(n + 1)).append("@0x").append(StringHelper.getHexStringLeadingZero(System.identityHashCode(object), 8));
        }
        this.m_aSrc = object;
    }

    private void _beforeAddField() {
        if ((this.m_nIndex & 1) == 0) {
            this.m_nIndex |= 1;
            if (this.m_aSB.length() > 1) {
                this.m_aSB.append(": ");
            }
        } else {
            this.m_aSB.append("; ");
        }
    }

    @Nonnull
    private ToStringGenerator _appendSuper(String string) {
        this._beforeAddField();
        this.m_aSB.append(string);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, boolean bl) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(bl);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable boolean[] blArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(blArray));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, byte by) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(by);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable byte[] byArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(byArray));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, char c) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append('\'').append(c).append('\'');
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable char[] cArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(cArray));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, double d) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(d);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable double[] dArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(dArray));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, float f) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(f);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable float[] fArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(fArray));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, int n) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(n);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable int[] nArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(nArray));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, long l) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(l);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable long[] lArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(lArray));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, short s) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(s);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable short[] sArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(Arrays.toString(sArray));
        return this;
    }

    @Nonnull
    public ToStringGenerator appendPassword(@Nonnull String string) {
        return this.append(string, CONSTANT_PASSWORD);
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable Enum<?> enum_) {
        return this.append(string, String.valueOf(enum_));
    }

    @Nonnull
    private ToStringGenerator _appendArray(@Nonnull String string, @Nonnull Object object) {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz.isPrimitive()) {
            if (clazz.equals(Byte.TYPE)) {
                return this.append(string, (byte[])object);
            }
            if (clazz.equals(Boolean.TYPE)) {
                return this.append(string, (boolean[])object);
            }
            if (clazz.equals(Character.TYPE)) {
                return this.append(string, (char[])object);
            }
            if (clazz.equals(Double.TYPE)) {
                return this.append(string, (double[])object);
            }
            if (clazz.equals(Float.TYPE)) {
                return this.append(string, (float[])object);
            }
            if (clazz.equals(Integer.TYPE)) {
                return this.append(string, (int[])object);
            }
            if (clazz.equals(Long.TYPE)) {
                return this.append(string, (long[])object);
            }
            if (clazz.equals(Short.TYPE)) {
                return this.append(string, (short[])object);
            }
        }
        return this.append(string, (Object[])object);
    }

    @Nonnull
    private String _getObjectValue(@Nullable Object object) {
        if (object == null) {
            return CONSTANT_NULL;
        }
        return EqualsHelper.identityEqual(object, this.m_aSrc) ? CONSTANT_THIS : object.toString();
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable Object object) {
        if (object != null && object.getClass().isArray()) {
            return this._appendArray(string, object);
        }
        this._beforeAddField();
        this.m_aSB.append(string).append('=').append(this._getObjectValue(object));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String string, @Nullable Object[] objectArray) {
        this._beforeAddField();
        this.m_aSB.append(string).append('=');
        if (objectArray == null) {
            this.m_aSB.append(CONSTANT_NULL);
        } else {
            int n = objectArray.length - 1;
            if (n == -1) {
                this.m_aSB.append("[]");
            } else {
                this.m_aSB.append('[');
                int n2 = 0;
                while (true) {
                    this.m_aSB.append(this._getObjectValue(objectArray[n2]));
                    if (n2 == n) break;
                    this.m_aSB.append(", ");
                    ++n2;
                }
                this.m_aSB.append(']');
            }
        }
        return this;
    }

    @Nonnull
    public ToStringGenerator appendIf(@Nonnull String string, boolean bl, @Nonnull IBooleanPredicate iBooleanPredicate) {
        return iBooleanPredicate.test(bl) ? this.append(string, bl) : this;
    }

    @Nonnull
    public ToStringGenerator appendIf(@Nonnull String string, boolean bl, @Nonnull BooleanSupplier booleanSupplier) {
        return booleanSupplier.getAsBoolean() ? this.append(string, bl) : this;
    }

    @Nonnull
    public ToStringGenerator appendIf(@Nonnull String string, char c, @Nonnull ICharPredicate iCharPredicate) {
        return iCharPredicate.test(c) ? this.append(string, c) : this;
    }

    @Nonnull
    public ToStringGenerator appendIf(@Nonnull String string, char c, @Nonnull BooleanSupplier booleanSupplier) {
        return booleanSupplier.getAsBoolean() ? this.append(string, c) : this;
    }

    @Nonnull
    public ToStringGenerator appendIf(@Nonnull String string, int n, @Nonnull IntPredicate intPredicate) {
        return intPredicate.test(n) ? this.append(string, n) : this;
    }

    @Nonnull
    public ToStringGenerator appendIf(@Nonnull String string, int n, @Nonnull BooleanSupplier booleanSupplier) {
        return booleanSupplier.getAsBoolean() ? this.append(string, n) : this;
    }

    @Nonnull
    public ToStringGenerator appendIf(@Nonnull String string, long l, @Nonnull LongPredicate longPredicate) {
        return longPredicate.test(l) ? this.append(string, l) : this;
    }

    @Nonnull
    public ToStringGenerator appendIf(@Nonnull String string, long l, @Nonnull BooleanSupplier booleanSupplier) {
        return booleanSupplier.getAsBoolean() ? this.append(string, l) : this;
    }

    @Nonnull
    public ToStringGenerator appendIf(@Nonnull String string, double d, @Nonnull DoublePredicate doublePredicate) {
        return doublePredicate.test(d) ? this.append(string, d) : this;
    }

    @Nonnull
    public ToStringGenerator appendIf(@Nonnull String string, double d, @Nonnull BooleanSupplier booleanSupplier) {
        return booleanSupplier.getAsBoolean() ? this.append(string, d) : this;
    }

    @Nonnull
    public <T> ToStringGenerator appendIf(@Nonnull String string, @Nullable T t, @Nonnull Predicate<? super T> predicate) {
        return predicate.test(t) ? this.append(string, t) : this;
    }

    @Nonnull
    public <T> ToStringGenerator appendIf(@Nonnull String string, @Nullable T t, @Nonnull BooleanSupplier booleanSupplier) {
        return booleanSupplier.getAsBoolean() ? this.append(string, t) : this;
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String string, @Nullable Object object) {
        return object == null ? this : this.append(string, object);
    }

    @Nonnull
    public ToStringGenerator appendPasswordIf(@Nonnull String string, BooleanSupplier booleanSupplier) {
        return booleanSupplier.getAsBoolean() ? this.appendPassword(string) : this;
    }

    @Nonnull
    public String getToString() {
        if ((this.m_nIndex & 2) == 0) {
            this.m_nIndex |= 2;
            this.m_aSB.append(']');
        }
        return this.m_aSB.toString();
    }

    @Nonnull
    @Deprecated(forRemoval=false)
    public String toString() {
        return this.getToString();
    }

    @Nonnull
    public static ToStringGenerator getDerived(@Nonnull String string) {
        return new ToStringGenerator(null)._appendSuper(string);
    }
}

