/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJExpressionStatement;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.IJOwnedMaybe;
import com.helger.jcodemodel.JAnonymousClass;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JTypeVar;
import com.helger.jcodemodel.JTypeVarClass;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JInvocation
implements IJExpressionStatement,
IJOwnedMaybe {
    private final JCodeModel m_aOwner;
    private final IJGenerable m_aObject;
    private final String m_sMethodName;
    private final JMethod m_aMethod;
    private final boolean m_bIsConstructor;
    private final List<IJExpression> m_aArgs = new ArrayList<IJExpression>();
    private final AbstractJType m_aConstructorType;
    private List<JTypeVar> m_aTypeVariables;

    protected JInvocation(@Nullable IJExpression iJExpression, @Nonnull String string) {
        this(null, (IJGenerable)iJExpression, string);
    }

    protected JInvocation(@Nullable IJExpression iJExpression, @Nonnull JMethod jMethod) {
        this(jMethod.owner(), (IJGenerable)iJExpression, jMethod);
    }

    protected JInvocation(@Nonnull AbstractJClass abstractJClass, @Nonnull String string) {
        this(abstractJClass.owner(), (IJGenerable)abstractJClass, string);
    }

    protected JInvocation(@Nonnull AbstractJClass abstractJClass, @Nonnull JMethod jMethod) {
        this(abstractJClass.owner(), (IJGenerable)abstractJClass, jMethod);
    }

    private JInvocation(@Nullable JCodeModel jCodeModel, @Nullable IJGenerable iJGenerable, @Nonnull String string) {
        JCValueEnforcer.notNull(string, "Name");
        JCValueEnforcer.isFalse(string.indexOf(46) >= 0, () -> "method name contains '.': " + string);
        this.m_aOwner = jCodeModel;
        this.m_aObject = iJGenerable;
        this.m_sMethodName = string;
        this.m_aMethod = null;
        this.m_bIsConstructor = false;
        this.m_aConstructorType = null;
    }

    private JInvocation(@Nonnull JCodeModel jCodeModel, @Nullable IJGenerable iJGenerable, @Nonnull JMethod jMethod) {
        JCValueEnforcer.notNull(jCodeModel, "Owner");
        JCValueEnforcer.notNull(jMethod, "Method");
        this.m_aOwner = jCodeModel;
        this.m_aObject = iJGenerable;
        this.m_sMethodName = null;
        this.m_aMethod = jMethod;
        this.m_bIsConstructor = false;
        this.m_aConstructorType = null;
    }

    protected JInvocation(@Nonnull AbstractJType abstractJType) {
        JCValueEnforcer.notNull(abstractJType, "ConstructorType");
        this.m_aOwner = abstractJType.owner();
        this.m_aObject = null;
        this.m_sMethodName = null;
        this.m_aMethod = null;
        this.m_bIsConstructor = true;
        this.m_aConstructorType = abstractJType;
    }

    @Override
    @Nullable
    public JCodeModel owner() {
        return this.m_aOwner;
    }

    public boolean isConstructor() {
        return this.m_bIsConstructor;
    }

    @Nonnull
    public JInvocation arg(@Nonnull IJExpression iJExpression) {
        JCValueEnforcer.notNull(iJExpression, "Argument");
        this.m_aArgs.add(iJExpression);
        return this;
    }

    @Nonnull
    public JInvocation arg(@Nonnull boolean bl) {
        return this.arg(JExpr.lit(bl));
    }

    @Nonnull
    public JInvocation arg(@Nonnull char c) {
        return this.arg(JExpr.lit(c));
    }

    @Nonnull
    public JInvocation arg(@Nonnull double d) {
        return this.arg(JExpr.lit(d));
    }

    @Nonnull
    public JInvocation arg(@Nonnull float f) {
        return this.arg(JExpr.lit(f));
    }

    @Nonnull
    public JInvocation arg(@Nonnull int n) {
        return this.arg(JExpr.lit(n));
    }

    @Nonnull
    public JInvocation arg(@Nonnull long l) {
        return this.arg(JExpr.lit(l));
    }

    @Nonnull
    public JInvocation arg(@Nonnull String string) {
        return this.arg(JExpr.lit(string));
    }

    @Nonnull
    @Deprecated
    public IJExpression[] listArgs() {
        return this.m_aArgs.toArray(new IJExpression[this.m_aArgs.size()]);
    }

    @Nonnull
    public List<IJExpression> args() {
        return new ArrayList<IJExpression>(this.m_aArgs);
    }

    @Nonnull
    private JCodeModel _narrowOwner() {
        JCodeModel jCodeModel = this.owner();
        if (jCodeModel == null) {
            throw new IllegalStateException("No owner is present, so this invocation cannot be generified!");
        }
        return jCodeModel;
    }

    @Nonnull
    public JInvocation narrow(@Nonnull String string) {
        JTypeVar jTypeVar = new JTypeVar(this._narrowOwner(), string);
        if (this.m_aTypeVariables == null) {
            this.m_aTypeVariables = new ArrayList<JTypeVar>(3);
        }
        this.m_aTypeVariables.add(jTypeVar);
        return this;
    }

    @Nonnull
    public JInvocation narrow(@Nonnull Class<?> clazz) {
        return this.narrow(this._narrowOwner().ref(clazz));
    }

    @Nonnull
    public JInvocation narrow(@Nonnull AbstractJClass abstractJClass) {
        JTypeVarClass jTypeVarClass = new JTypeVarClass(abstractJClass);
        if (this.m_aTypeVariables == null) {
            this.m_aTypeVariables = new ArrayList<JTypeVar>(3);
        }
        this.m_aTypeVariables.add(jTypeVarClass);
        return this;
    }

    @Nonnull
    public List<JTypeVar> typeParamList() {
        if (this.m_aTypeVariables == null) {
            return Collections.emptyList();
        }
        return new ArrayList<JTypeVar>(this.m_aTypeVariables);
    }

    private void _addTypeVars(@Nonnull JFormatter jFormatter) {
        if (this.m_aTypeVariables != null && !this.m_aTypeVariables.isEmpty()) {
            jFormatter.print('<');
            int n = 0;
            for (JTypeVar jTypeVar : this.m_aTypeVariables) {
                if (n++ > 0) {
                    jFormatter.print(',');
                }
                jFormatter.type(jTypeVar);
            }
            jFormatter.print('\uffff');
        }
    }

    @Nullable
    private String _methodName() {
        return this.m_aMethod != null ? this.m_aMethod.name() : this.m_sMethodName;
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        if (this.m_bIsConstructor) {
            if (this.m_aConstructorType.isArray()) {
                jFormatter.print("new").generable(this.m_aConstructorType);
                this._addTypeVars(jFormatter);
                jFormatter.print('{');
            } else {
                jFormatter.print("new").generable(this.m_aConstructorType);
                this._addTypeVars(jFormatter);
                jFormatter.print('(');
            }
        } else {
            String string = this._methodName();
            if (this.m_aObject != null) {
                jFormatter.generable(this.m_aObject).print('.');
                this._addTypeVars(jFormatter);
                jFormatter.print(string);
                jFormatter.print('(');
            } else {
                jFormatter.id(string).print('(');
            }
        }
        jFormatter.generable(this.m_aArgs);
        if (this.m_bIsConstructor && this.m_aConstructorType.isArray()) {
            jFormatter.print('}');
        } else {
            jFormatter.print(')');
        }
        if (this.m_aConstructorType instanceof JDefinedClass && ((JDefinedClass)this.m_aConstructorType).isAnonymous()) {
            ((JAnonymousClass)this.m_aConstructorType).declareBody(jFormatter);
        }
    }

    @Override
    public void state(@Nonnull JFormatter jFormatter) {
        jFormatter.generable(this).print(';').newline();
    }

    @Nonnull
    private String _typeFullName() {
        return this.m_aConstructorType != null ? this.m_aConstructorType.fullName() : "";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JInvocation jInvocation = (JInvocation)object;
        if (!(JCEqualsHelper.isEqual(this.m_aObject, jInvocation.m_aObject) && JCEqualsHelper.isEqual(this.m_bIsConstructor, jInvocation.m_bIsConstructor) && (this.m_bIsConstructor || JCEqualsHelper.isEqual(this._methodName(), jInvocation._methodName())) && JCEqualsHelper.isEqual(this.m_aArgs, jInvocation.m_aArgs) && JCEqualsHelper.isEqual(this._typeFullName(), jInvocation._typeFullName()))) {
            return false;
        }
        if (this.m_aTypeVariables == null) {
            return jInvocation.m_aTypeVariables == null;
        }
        if (jInvocation.m_aTypeVariables == null) {
            return false;
        }
        if (this.m_aTypeVariables.size() != jInvocation.m_aTypeVariables.size()) {
            return false;
        }
        for (int i = 0; i < this.m_aTypeVariables.size(); ++i) {
            if (JCEqualsHelper.isEqual(this.m_aTypeVariables.get(i).fullName(), jInvocation.m_aTypeVariables.get(i).fullName())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        JCHashCodeGenerator jCHashCodeGenerator = new JCHashCodeGenerator(this).append(this.m_aObject).append(this.m_bIsConstructor);
        if (!this.m_bIsConstructor) {
            jCHashCodeGenerator = jCHashCodeGenerator.append(this._methodName());
        }
        jCHashCodeGenerator = jCHashCodeGenerator.append(this.m_aArgs).append(this._typeFullName());
        if (this.m_aTypeVariables != null) {
            jCHashCodeGenerator = jCHashCodeGenerator.append(this.m_aTypeVariables.size());
            for (JTypeVar jTypeVar : this.m_aTypeVariables) {
                jCHashCodeGenerator = jCHashCodeGenerator.append(jTypeVar.fullName());
            }
        }
        return jCHashCodeGenerator.getHashCode();
    }

    @Nonnull
    public static JInvocation _super() {
        return new JInvocation(null, null, JExpr._super().what());
    }
}

