/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.stream;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.callback.exception.IExceptionCallback;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.exception.mock.IMockException;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.stream.ByteBufferInputStream;
import com.helger.commons.io.stream.ByteBufferOutputStream;
import com.helger.commons.io.stream.NonBlockingBufferedInputStream;
import com.helger.commons.io.stream.NonBlockingBufferedOutputStream;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.commons.io.stream.NonBlockingBufferedWriter;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.NonBlockingStringReader;
import com.helger.commons.io.stream.NonBlockingStringWriter;
import com.helger.commons.io.stream.WrappedInputStream;
import com.helger.commons.io.stream.WrappedOutputStream;
import com.helger.commons.io.stream.WrappedReader;
import com.helger.commons.io.stream.WrappedWriter;
import com.helger.commons.mutable.MutableLong;
import com.helger.commons.state.ESuccess;
import com.helger.commons.statistics.IMutableStatisticsHandlerSize;
import com.helger.commons.statistics.StatisticsManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class StreamHelper {
    public static final int DEFAULT_BUFSIZE = 16384;
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamHelper.class);
    private static final IMutableStatisticsHandlerSize s_aByteSizeHdl = StatisticsManager.getSizeHandler(StreamHelper.class.getName() + "$COPY");
    private static final IMutableStatisticsHandlerSize s_aCharSizeHdl = StatisticsManager.getSizeHandler(StreamHelper.class.getName() + "$COPYCHARS");
    private static final StreamHelper s_aInstance = new StreamHelper();
    public static final int END_OF_STRING_MARKER = -131075;

    private StreamHelper() {
    }

    public static boolean isKnownEOFException(@Nullable Throwable throwable) {
        return throwable != null && StreamHelper.isKnownEOFException(throwable.getClass());
    }

    public static boolean isKnownEOFException(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        String string = clazz.getName();
        return string.equals("java.io.EOFException") || string.equals("org.mortbay.jetty.EofException") || string.equals("org.eclipse.jetty.io.EofException") || string.equals("org.apache.catalina.connector.ClientAbortException");
    }

    @Nullable
    private static Exception _propagate(@Nonnull Exception exception) {
        return exception instanceof IMockException ? null : exception;
    }

    @Nonnull
    public static ESuccess closeWithoutFlush(@Nullable @WillClose AutoCloseable autoCloseable) {
        block3: {
            if (autoCloseable != null) {
                try {
                    autoCloseable.close();
                    return ESuccess.SUCCESS;
                }
                catch (Exception exception) {
                    if (StreamHelper.isKnownEOFException(exception)) break block3;
                    LOGGER.error("Failed to close object " + autoCloseable.getClass().getName(), (Throwable)StreamHelper._propagate(exception));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess close(@Nullable @WillClose AutoCloseable autoCloseable) {
        block5: {
            if (autoCloseable != null) {
                try {
                    if (autoCloseable instanceof Flushable) {
                        StreamHelper.flush((Flushable)((Object)autoCloseable));
                    }
                    autoCloseable.close();
                    return ESuccess.SUCCESS;
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (Exception exception) {
                    if (StreamHelper.isKnownEOFException(exception)) break block5;
                    LOGGER.error("Failed to close object " + autoCloseable.getClass().getName(), (Throwable)StreamHelper._propagate(exception));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess flush(@Nullable Flushable flushable) {
        block4: {
            if (flushable != null) {
                try {
                    flushable.flush();
                    return ESuccess.SUCCESS;
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (IOException iOException) {
                    if (StreamHelper.isKnownEOFException(iOException)) break block4;
                    LOGGER.error("Failed to flush object " + flushable.getClass().getName(), (Throwable)StreamHelper._propagate(iOException));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    @Nonnegative
    private static long _copyInputStreamToOutputStream(@Nonnull @WillNotClose InputStream inputStream, @Nonnull @WillNotClose OutputStream outputStream, @Nonnull byte[] byArray) throws IOException {
        int n;
        int n2 = byArray.length;
        long l = 0L;
        while ((n = inputStream.read(byArray, 0, n2)) > -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    @Nonnegative
    private static long _copyInputStreamToOutputStreamWithLimit(@Nonnull @WillNotClose InputStream inputStream, @Nonnull @WillNotClose OutputStream outputStream, @Nonnull byte[] byArray, @Nonnegative long l) throws IOException {
        int n = byArray.length;
        long l2 = l;
        long l3 = 0L;
        while (true) {
            int n2;
            int n3;
            int n4 = n3 = l2 >= (long)n ? n : (int)l2;
            if (n3 == 0 || (n2 = inputStream.read(byArray, 0, n3)) == -1) break;
            if (n2 <= 0) continue;
            outputStream.write(byArray, 0, n2);
            l3 += (long)n2;
            l2 -= (long)n2;
        }
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@Nullable InputStream inputStream, boolean bl, @Nullable OutputStream outputStream, boolean bl2, @Nonnull @Nonempty byte[] byArray, @Nullable Long l, @Nullable IExceptionCallback<IOException> iExceptionCallback, @Nullable MutableLong mutableLong) {
        try {
            ValueEnforcer.notEmpty(byArray, "Buffer");
            ValueEnforcer.isTrue(l == null || l >= 0L, () -> "Limit may not be negative: " + l);
            if (inputStream != null && outputStream != null) {
                long l2 = l == null ? StreamHelper._copyInputStreamToOutputStream(inputStream, outputStream, byArray) : StreamHelper._copyInputStreamToOutputStreamWithLimit(inputStream, outputStream, byArray, l);
                s_aByteSizeHdl.addSize(l2);
                if (mutableLong != null) {
                    mutableLong.set(l2);
                }
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
        }
        catch (IOException iOException) {
            if (iExceptionCallback != null) {
                iExceptionCallback.onException(iOException);
            } else if (!StreamHelper.isKnownEOFException(iOException)) {
                LOGGER.error("Failed to copy from InputStream to OutputStream", (Throwable)StreamHelper._propagate(iOException));
            }
        }
        finally {
            if (bl) {
                StreamHelper.close(inputStream);
            }
            if (bl2) {
                StreamHelper.close(outputStream);
            }
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] createDefaultCopyBufferBytes() {
        return new byte[16384];
    }

    @Nonnull
    @Deprecated
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream, @Nonnull @Nonempty byte[] byArray, @Nullable MutableLong mutableLong, @Nullable Long l) {
        return StreamHelper.copyInputStreamToOutputStream(inputStream, true, outputStream, false, byArray, l, null, mutableLong);
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream) {
        return StreamHelper.copyInputStreamToOutputStream(inputStream, true, outputStream, false, StreamHelper.createDefaultCopyBufferBytes(), null, null, null);
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStreamAndCloseOS(@WillClose @Nullable InputStream inputStream, @WillClose @Nullable OutputStream outputStream) {
        return StreamHelper.copyInputStreamToOutputStream(inputStream, true, outputStream, true, StreamHelper.createDefaultCopyBufferBytes(), null, null, null);
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStreamWithLimit(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream, @Nonnegative long l) {
        return StreamHelper.copyInputStreamToOutputStream(inputStream, true, outputStream, false, StreamHelper.createDefaultCopyBufferBytes(), l, null, null);
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStreamWithLimitAndCloseOS(@WillClose @Nullable InputStream inputStream, @WillClose @Nullable OutputStream outputStream, @Nonnegative long l) {
        return StreamHelper.copyInputStreamToOutputStream(inputStream, true, outputStream, true, StreamHelper.createDefaultCopyBufferBytes(), l, null, null);
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream, @Nullable MutableLong mutableLong) {
        return StreamHelper.copyInputStreamToOutputStream(inputStream, true, outputStream, false, StreamHelper.createDefaultCopyBufferBytes(), null, null, mutableLong);
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream, @Nonnull byte[] byArray) {
        return StreamHelper.copyInputStreamToOutputStream(inputStream, true, outputStream, false, byArray, null, null, null);
    }

    @Nonnull
    @Deprecated
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream, @Nonnull @Nonempty byte[] byArray, @Nullable MutableLong mutableLong) {
        return StreamHelper.copyInputStreamToOutputStream(inputStream, true, outputStream, false, byArray, null, null, mutableLong);
    }

    public static int getAvailable(@Nullable InputStream inputStream) {
        if (inputStream != null) {
            try {
                return inputStream.available();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    @Nullable
    public static NonBlockingByteArrayOutputStream getCopy(@Nonnull @WillClose InputStream inputStream) {
        int n = Math.max(16384, StreamHelper.getAvailable(inputStream));
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(n);
        if (StreamHelper.copyInputStreamToOutputStreamAndCloseOS(inputStream, nonBlockingByteArrayOutputStream).isFailure()) {
            return null;
        }
        return nonBlockingByteArrayOutputStream;
    }

    @Nullable
    public static NonBlockingByteArrayOutputStream getCopyWithLimit(@Nonnull @WillClose InputStream inputStream, @Nonnegative long l) {
        int n = Math.max(16384, StreamHelper.getAvailable(inputStream));
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(n);
        if (StreamHelper.copyInputStreamToOutputStreamWithLimitAndCloseOS(inputStream, nonBlockingByteArrayOutputStream, l).isFailure()) {
            return null;
        }
        return nonBlockingByteArrayOutputStream;
    }

    @Nullable
    public static byte[] getAllBytes(@Nullable IHasInputStream iHasInputStream) {
        if (iHasInputStream == null) {
            return null;
        }
        return StreamHelper.getAllBytes(iHasInputStream.getInputStream());
    }

    @Nullable
    public static byte[] getAllBytes(@Nullable @WillClose InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = StreamHelper.getCopy(inputStream);){
            if (nonBlockingByteArrayOutputStream == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = nonBlockingByteArrayOutputStream.getBufferOrCopy();
            return byArray;
        }
    }

    @Nullable
    public static String getAllBytesAsString(@Nullable IHasInputStream iHasInputStream, @Nonnull @Nonempty Charset charset) {
        if (iHasInputStream == null) {
            return null;
        }
        return StreamHelper.getAllBytesAsString(iHasInputStream.getInputStream(), charset);
    }

    @Nullable
    public static String getAllBytesAsString(@Nullable @WillClose InputStream inputStream, @Nonnull @Nonempty Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        if (inputStream == null) {
            return null;
        }
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = StreamHelper.getCopy(inputStream);
        if (nonBlockingByteArrayOutputStream == null) {
            return null;
        }
        return nonBlockingByteArrayOutputStream.getAsString(charset);
    }

    @Nonnegative
    private static long _copyReaderToWriter(@Nonnull @WillNotClose Reader reader, @Nonnull @WillNotClose Writer writer, @Nonnull char[] cArray) throws IOException {
        int n;
        long l = 0L;
        while ((n = reader.read(cArray, 0, cArray.length)) > -1) {
            writer.write(cArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    @Nonnegative
    private static long _copyReaderToWriterWithLimit(@Nonnull @WillNotClose Reader reader, @Nonnull @WillNotClose Writer writer, @Nonnull char[] cArray, @Nonnegative long l) throws IOException {
        long l2 = l;
        long l3 = 0L;
        while (true) {
            int n;
            int n2;
            int n3 = n2 = l2 >= (long)cArray.length ? cArray.length : (int)l2;
            if (n2 == 0 || (n = reader.read(cArray, 0, n2)) == -1) break;
            if (n <= 0) continue;
            writer.write(cArray, 0, n);
            l3 += (long)n;
            l2 -= (long)n;
        }
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess copyReaderToWriter(@Nullable Reader reader, boolean bl, @Nullable Writer writer, boolean bl2, @Nonnull @Nonempty char[] cArray, @Nullable Long l, @Nullable IExceptionCallback<IOException> iExceptionCallback, @Nullable MutableLong mutableLong) {
        try {
            ValueEnforcer.notEmpty(cArray, "Buffer");
            ValueEnforcer.isTrue(l == null || l >= 0L, () -> "Limit may not be negative: " + l);
            if (reader != null && writer != null) {
                long l2 = l == null ? StreamHelper._copyReaderToWriter(reader, writer, cArray) : StreamHelper._copyReaderToWriterWithLimit(reader, writer, cArray, l);
                s_aCharSizeHdl.addSize(l2);
                if (mutableLong != null) {
                    mutableLong.set(l2);
                }
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
        }
        catch (IOException iOException) {
            if (iExceptionCallback != null) {
                iExceptionCallback.onException(iOException);
            } else if (!StreamHelper.isKnownEOFException(iOException)) {
                LOGGER.error("Failed to copy from Reader to Writer", (Throwable)StreamHelper._propagate(iOException));
            }
        }
        finally {
            if (bl) {
                StreamHelper.close(reader);
            }
            if (bl2) {
                StreamHelper.close(writer);
            }
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static char[] createDefaultCopyBufferChars() {
        return new char[16384];
    }

    @Nonnull
    public static ESuccess copyReaderToWriter(@Nullable @WillClose Reader reader, @Nullable @WillNotClose Writer writer, @Nonnull @Nonempty char[] cArray, @Nullable MutableLong mutableLong, @Nullable Long l) {
        return StreamHelper.copyReaderToWriter(reader, true, writer, false, cArray, l, null, mutableLong);
    }

    @Nonnull
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader reader, @WillNotClose @Nullable Writer writer) {
        return StreamHelper.copyReaderToWriter(reader, true, writer, false, StreamHelper.createDefaultCopyBufferChars(), null, null, null);
    }

    @Nonnull
    public static ESuccess copyReaderToWriterAndCloseWriter(@Nullable @WillClose Reader reader, @Nullable @WillClose Writer writer) {
        return StreamHelper.copyReaderToWriter(reader, true, writer, true, StreamHelper.createDefaultCopyBufferChars(), null, null, null);
    }

    @Nonnull
    public static ESuccess copyReaderToWriterWithLimit(@WillClose @Nullable Reader reader, @WillNotClose @Nullable Writer writer, long l) {
        return StreamHelper.copyReaderToWriter(reader, true, writer, false, StreamHelper.createDefaultCopyBufferChars(), l, null, null);
    }

    @Nonnull
    public static ESuccess copyReaderToWriterWithLimitAndCloseWriter(@Nullable @WillClose Reader reader, @Nullable @WillClose Writer writer, @Nonnegative long l) {
        return StreamHelper.copyReaderToWriter(reader, true, writer, true, StreamHelper.createDefaultCopyBufferChars(), l, null, null);
    }

    @Nonnull
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader reader, @WillNotClose @Nullable Writer writer, @Nullable MutableLong mutableLong) {
        return StreamHelper.copyReaderToWriter(reader, true, writer, false, StreamHelper.createDefaultCopyBufferChars(), null, null, null);
    }

    @Nonnull
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader reader, @WillNotClose @Nullable Writer writer, @Nonnull char[] cArray) {
        return StreamHelper.copyReaderToWriter(reader, true, writer, false, cArray, null, null, null);
    }

    @Nonnull
    @Deprecated
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader reader, @WillNotClose @Nullable Writer writer, @Nonnull @Nonempty char[] cArray, @Nullable MutableLong mutableLong) {
        return StreamHelper.copyReaderToWriter(reader, true, writer, false, cArray, null, null, mutableLong);
    }

    @Nullable
    public static NonBlockingStringWriter getCopy(@Nonnull @WillClose Reader reader) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(16384);
        if (StreamHelper.copyReaderToWriterAndCloseWriter(reader, nonBlockingStringWriter).isFailure()) {
            return null;
        }
        return nonBlockingStringWriter;
    }

    @Nullable
    public static NonBlockingStringWriter getCopyWithLimit(@Nonnull @WillClose Reader reader, @Nonnegative long l) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(16384);
        if (StreamHelper.copyReaderToWriterWithLimitAndCloseWriter(reader, nonBlockingStringWriter, l).isFailure()) {
            return null;
        }
        return nonBlockingStringWriter;
    }

    @Nullable
    public static char[] getAllCharacters(@Nullable @WillClose Reader reader) {
        if (reader == null) {
            return null;
        }
        NonBlockingStringWriter nonBlockingStringWriter = StreamHelper.getCopy(reader);
        if (nonBlockingStringWriter == null) {
            return null;
        }
        return nonBlockingStringWriter.getAsCharArray();
    }

    @Nullable
    public static String getAllCharactersAsString(@Nullable @WillClose Reader reader) {
        if (reader == null) {
            return null;
        }
        NonBlockingStringWriter nonBlockingStringWriter = StreamHelper.getCopy(reader);
        if (nonBlockingStringWriter == null) {
            return null;
        }
        return nonBlockingStringWriter.getAsString();
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsList<String> readStreamLines(@Nullable IHasInputStream iHasInputStream, @Nonnull Charset charset) {
        return StreamHelper.readStreamLines(iHasInputStream, charset, 0, -1);
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsList<String> readStreamLines(@Nullable IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nonnegative int n, @CheckForSigned int n2) {
        if (iHasInputStream == null) {
            return null;
        }
        return StreamHelper.readStreamLines(iHasInputStream.getInputStream(), charset, n, n2);
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsList<String> readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull @Nonempty Charset charset) {
        return StreamHelper.readStreamLines(inputStream, charset, 0, -1);
    }

    public static void readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull Charset charset, @Nonnull List<String> list) {
        if (inputStream != null) {
            StreamHelper.readStreamLines(inputStream, charset, 0, -1, list::add);
        }
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsList<String> readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull Charset charset, @Nonnegative int n, @CheckForSigned int n2) {
        if (inputStream == null) {
            return null;
        }
        CommonsArrayList<String> commonsArrayList = new CommonsArrayList<String>();
        StreamHelper.readStreamLines(inputStream, charset, n, n2, commonsArrayList::add);
        return commonsArrayList;
    }

    public static void readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull @Nonempty Charset charset, @Nonnull Consumer<? super String> consumer) {
        if (inputStream != null) {
            StreamHelper.readStreamLines(inputStream, charset, 0, -1, consumer);
        }
    }

    private static void _readFromReader(int n, int n2, @Nonnull Consumer<? super String> consumer, boolean bl, @Nonnull NonBlockingBufferedReader nonBlockingBufferedReader) throws IOException {
        String string;
        int n3;
        for (n3 = 0; n3 < n && (string = nonBlockingBufferedReader.readLine()) != null; ++n3) {
        }
        if (bl) {
            while ((string = nonBlockingBufferedReader.readLine()) != null) {
                consumer.accept(string);
            }
        } else {
            n3 = 0;
            while ((string = nonBlockingBufferedReader.readLine()) != null) {
                consumer.accept(string);
                if (++n3 < n2) continue;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readStreamLines(@WillClose @Nullable InputStream inputStream, @Nonnull @Nonempty Charset charset, @Nonnegative int n, int n2, @Nonnull Consumer<? super String> consumer) {
        block17: {
            try {
                ValueEnforcer.notNull(charset, "Charset");
                ValueEnforcer.isGE0(n, "LinesToSkip");
                boolean bl = n2 == -1;
                ValueEnforcer.isTrue(bl || n2 >= 0, () -> "Line count may not be that negative: " + n2);
                ValueEnforcer.notNull(consumer, "LineCallback");
                if (inputStream == null || !bl && n2 <= 0) break block17;
                try (NonBlockingBufferedReader nonBlockingBufferedReader = new NonBlockingBufferedReader(StreamHelper.createReader(inputStream, charset));){
                    StreamHelper._readFromReader(n, n2, consumer, bl, nonBlockingBufferedReader);
                }
                catch (IOException iOException) {
                    LOGGER.error("Failed to read from reader", (Throwable)StreamHelper._propagate(iOException));
                }
            }
            finally {
                StreamHelper.close(inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeStream(@WillClose @Nonnull OutputStream outputStream, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        try {
            ValueEnforcer.notNull(outputStream, "OutputStream");
            ValueEnforcer.isArrayOfsLen(byArray, n, n2);
            outputStream.write(byArray, n, n2);
            outputStream.flush();
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (IOException iOException) {
            LOGGER.error("Failed to write to output stream", (Throwable)StreamHelper._propagate(iOException));
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            StreamHelper.close(outputStream);
        }
    }

    @Nonnull
    public static ESuccess writeStream(@WillClose @Nonnull OutputStream outputStream, @Nonnull byte[] byArray) {
        return StreamHelper.writeStream(outputStream, byArray, 0, byArray.length);
    }

    @Nonnull
    public static ESuccess writeStream(@WillClose @Nonnull OutputStream outputStream, @Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(string, "Content");
        ValueEnforcer.notNull(charset, "Charset");
        return StreamHelper.writeStream(outputStream, string.getBytes(charset));
    }

    @Nonnull
    public static NonBlockingStringReader createReader(@Nonnull String string) {
        return new NonBlockingStringReader(string);
    }

    @Nonnull
    public static NonBlockingStringReader createReader(@Nonnull char[] cArray) {
        return new NonBlockingStringReader(cArray);
    }

    @Nullable
    public static InputStreamReader createReader(@Nullable InputStream inputStream, @Nonnull Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        return inputStream == null ? null : new InputStreamReader(inputStream, charset);
    }

    @Nullable
    public static OutputStreamWriter createWriter(@Nullable OutputStream outputStream, @Nonnull Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        return outputStream == null ? null : new OutputStreamWriter(outputStream, charset);
    }

    public static void skipFully(@Nonnull InputStream inputStream, @Nonnegative long l) throws IOException {
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.isGE0(l, "BytesToSkip");
        long l2 = l;
        while (l2 > 0L) {
            long l3 = inputStream.skip(l2);
            if (l3 == 0L) {
                if (inputStream.read() == -1) {
                    throw new EOFException("Failed to skip a total of " + l + " bytes on input stream. Only skipped " + (l - l2) + " bytes so far!");
                }
                --l2;
                continue;
            }
            l2 -= l3;
        }
    }

    @Nonnegative
    public static int readFully(@Nonnull InputStream inputStream, @Nonnull byte[] byArray) throws IOException {
        return StreamHelper.readFully(inputStream, byArray, 0, byArray.length);
    }

    @Nonnegative
    public static int readFully(@Nonnull @WillNotClose InputStream inputStream, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        int n3;
        int n4;
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 >= 0) continue;
            throw new EOFException("Failed to read a total of " + n2 + " bytes from input stream. Only read " + n3 + " bytes so far.");
        }
        return n3;
    }

    private static void _readUntilEOF(@Nonnull @WillNotClose InputStream inputStream, @Nonnull byte[] byArray, @Nonnull ObjIntConsumer<? super byte[]> objIntConsumer) throws IOException {
        int n;
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.notNull(byArray, "Buffer");
        ValueEnforcer.notNull(objIntConsumer, "Consumer");
        while ((n = inputStream.read(byArray, 0, byArray.length)) > -1) {
            objIntConsumer.accept((byte[])byArray, n);
        }
    }

    public static void readUntilEOF(@Nonnull @WillClose InputStream inputStream, @Nonnull ObjIntConsumer<? super byte[]> objIntConsumer) throws IOException {
        StreamHelper.readUntilEOF(inputStream, StreamHelper.createDefaultCopyBufferBytes(), objIntConsumer);
    }

    public static void readUntilEOF(@Nonnull @WillClose InputStream inputStream, @Nonnull byte[] byArray, @Nonnull ObjIntConsumer<? super byte[]> objIntConsumer) throws IOException {
        try {
            ValueEnforcer.notNull(inputStream, "InputStream");
            ValueEnforcer.notNull(byArray, "Buffer");
            ValueEnforcer.notNull(objIntConsumer, "Consumer");
            StreamHelper._readUntilEOF(inputStream, byArray, objIntConsumer);
        }
        finally {
            StreamHelper.close(inputStream);
        }
    }

    private static void _readUntilEOF(@Nonnull @WillNotClose Reader reader, @Nonnull char[] cArray, @Nonnull ObjIntConsumer<? super char[]> objIntConsumer) throws IOException {
        int n;
        ValueEnforcer.notNull(reader, "Reader");
        ValueEnforcer.notNull(cArray, "Buffer");
        ValueEnforcer.notNull(objIntConsumer, "Consumer");
        while ((n = reader.read(cArray, 0, cArray.length)) > -1) {
            objIntConsumer.accept((char[])cArray, n);
        }
    }

    public static void readUntilEOF(@Nonnull @WillClose Reader reader, @Nonnull ObjIntConsumer<? super char[]> objIntConsumer) throws IOException {
        StreamHelper.readUntilEOF(reader, new char[16384], objIntConsumer);
    }

    public static void readUntilEOF(@Nonnull @WillClose Reader reader, @Nonnull char[] cArray, @Nonnull ObjIntConsumer<? super char[]> objIntConsumer) throws IOException {
        try {
            ValueEnforcer.notNull(reader, "Reader");
            ValueEnforcer.notNull(cArray, "Buffer");
            ValueEnforcer.notNull(objIntConsumer, "Consumer");
            StreamHelper._readUntilEOF(reader, cArray, objIntConsumer);
        }
        finally {
            StreamHelper.close(reader);
        }
    }

    public static boolean isBuffered(@Nullable InputStream inputStream) {
        return inputStream instanceof BufferedInputStream || inputStream instanceof NonBlockingBufferedInputStream || inputStream instanceof ByteArrayInputStream || inputStream instanceof NonBlockingByteArrayInputStream || inputStream instanceof ByteBufferInputStream || inputStream instanceof WrappedInputStream && StreamHelper.isBuffered(((WrappedInputStream)inputStream).getWrappedInputStream());
    }

    @Nullable
    public static InputStream getBuffered(@Nullable InputStream inputStream) {
        return inputStream == null || StreamHelper.isBuffered(inputStream) ? inputStream : new NonBlockingBufferedInputStream(inputStream);
    }

    public static boolean isBuffered(@Nullable OutputStream outputStream) {
        return outputStream instanceof BufferedOutputStream || outputStream instanceof NonBlockingBufferedOutputStream || outputStream instanceof ByteArrayOutputStream || outputStream instanceof NonBlockingByteArrayOutputStream || outputStream instanceof ByteBufferOutputStream || outputStream instanceof WrappedOutputStream && StreamHelper.isBuffered(((WrappedOutputStream)outputStream).getWrappedOutputStream());
    }

    @Nullable
    public static OutputStream getBuffered(@Nullable OutputStream outputStream) {
        return outputStream == null || StreamHelper.isBuffered(outputStream) ? outputStream : new NonBlockingBufferedOutputStream(outputStream);
    }

    public static boolean isBuffered(@Nullable Reader reader) {
        return reader instanceof BufferedReader || reader instanceof NonBlockingBufferedReader || reader instanceof StringReader || reader instanceof NonBlockingStringReader || reader instanceof WrappedReader && StreamHelper.isBuffered(((WrappedReader)reader).getWrappedReader());
    }

    @Nullable
    public static Reader getBuffered(@Nullable Reader reader) {
        return reader == null || StreamHelper.isBuffered(reader) ? reader : new NonBlockingBufferedReader(reader);
    }

    public static boolean isBuffered(@Nullable Writer writer) {
        return writer instanceof BufferedWriter || writer instanceof NonBlockingBufferedWriter || writer instanceof StringWriter || writer instanceof NonBlockingStringWriter || writer instanceof WrappedWriter && StreamHelper.isBuffered(((WrappedWriter)writer).getWrappedWriter());
    }

    @Nullable
    public static Writer getBuffered(@Nullable Writer writer) {
        return writer == null || StreamHelper.isBuffered(writer) ? writer : new NonBlockingBufferedWriter(writer);
    }

    @Nullable
    public static InputStream checkForInvalidFilterInputStream(@Nullable InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.markSupported();
            }
            catch (NullPointerException nullPointerException) {
                StreamHelper.close(inputStream);
                return null;
            }
        }
        return inputStream;
    }

    public static void writeSafeUTF(@Nonnull DataOutput dataOutput, @Nullable String string) throws IOException {
        ValueEnforcer.notNull(dataOutput, "DataOutput");
        if (string == null) {
            dataOutput.writeByte(0);
        } else {
            dataOutput.writeByte(2);
            byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
            dataOutput.writeInt(byArray.length);
            dataOutput.write(byArray);
            dataOutput.writeInt(-131075);
        }
    }

    @Nullable
    public static String readSafeUTF(@Nonnull DataInput dataInput) throws IOException {
        String string;
        ValueEnforcer.notNull(dataInput, "DataInput");
        byte by = dataInput.readByte();
        switch (by) {
            case 0: {
                string = null;
                break;
            }
            case 1: {
                int n = dataInput.readInt();
                byte[] byArray = new byte[n];
                dataInput.readFully(byArray);
                string = new String(byArray, StandardCharsets.UTF_8);
                break;
            }
            case 2: {
                int n = dataInput.readInt();
                byte[] byArray = new byte[n];
                dataInput.readFully(byArray);
                string = new String(byArray, StandardCharsets.UTF_8);
                int n2 = dataInput.readInt();
                if (n2 == -131075) break;
                throw new IOException("Missing end of String marker");
            }
            default: {
                throw new IOException("Unsupported string layout version " + by);
            }
        }
        return string;
    }
}

