/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.type;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.compare.IComparable;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.name.IHasName;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ObjectType
implements IComparable<ObjectType>,
IHasName {
    private final String m_sName;
    private transient int m_nHashCode = 0;

    public ObjectType(@Nonnull @Nonempty String string) {
        this.m_sName = ValueEnforcer.notEmpty(string, "Name");
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Override
    public int compareTo(@Nonnull ObjectType objectType) {
        return this.m_sName.compareTo(objectType.m_sName);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ObjectType objectType = (ObjectType)object;
        return this.m_sName.equals(objectType.m_sName);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator(this).append(this.m_sName).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator(this).append("Name", this.m_sName).getToString();
    }
}

