/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.credentials;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.security.authentication.credentials.CredentialValidationResult;
import com.helger.security.authentication.credentials.CredentialValidationResultList;
import com.helger.security.authentication.credentials.IAuthCredentialValidatorSPI;
import com.helger.security.authentication.credentials.IAuthCredentials;
import com.helger.security.authentication.credentials.ICredentialValidationResult;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class AuthCredentialValidatorManager {
    private static final ICommonsList<IAuthCredentialValidatorSPI> s_aHdlList = ServiceLoaderHelper.getAllSPIImplementations(IAuthCredentialValidatorSPI.class);

    private AuthCredentialValidatorManager() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IAuthCredentialValidatorSPI> getAllAuthCredentialValidators() {
        return (ICommonsList)s_aHdlList.getClone();
    }

    @Nonnull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public static ICredentialValidationResult validateCredentials(@Nonnull IAuthCredentials iAuthCredentials) {
        ValueEnforcer.notNull((Object)iAuthCredentials, (String)"Credentials");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (IAuthCredentialValidatorSPI iAuthCredentialValidatorSPI : s_aHdlList) {
            if (!iAuthCredentialValidatorSPI.supportsCredentials(iAuthCredentials)) continue;
            ICredentialValidationResult iCredentialValidationResult = iAuthCredentialValidatorSPI.validateCredentials(iAuthCredentials);
            if (iCredentialValidationResult == null) {
                throw new IllegalStateException("validateCredentials returned a null object from " + iAuthCredentialValidatorSPI + " for credentials " + iAuthCredentials);
            }
            if (iCredentialValidationResult.isSuccess()) {
                return iCredentialValidationResult;
            }
            commonsArrayList.add((Object)iCredentialValidationResult);
        }
        if (commonsArrayList.isEmpty()) {
            commonsArrayList.add((Object)new CredentialValidationResult("No credential validator supported the provided credentials: " + iAuthCredentials));
        }
        return new CredentialValidationResultList((Iterable<? extends ICredentialValidationResult>)commonsArrayList);
    }

    static {
        if (s_aHdlList.isEmpty()) {
            throw new InitializationException("No class implementing " + IAuthCredentialValidatorSPI.class + " was found!");
        }
    }
}

