/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.password.hash;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import com.helger.security.password.hash.AbstractPasswordHashCreator;
import com.helger.security.password.salt.IPasswordSalt;
import java.security.GeneralSecurityException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public abstract class AbstractPasswordHashCreatorPBKDF2
extends AbstractPasswordHashCreator {
    public static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA1";
    protected final int m_nIterations;
    protected final int m_nHashBytes;

    public AbstractPasswordHashCreatorPBKDF2(@Nonnull @Nonempty String string, @Nonnegative int n, @Nonnegative int n2) {
        super(string);
        this.m_nIterations = ValueEnforcer.isGT0((int)n, (String)"Iterations");
        this.m_nHashBytes = ValueEnforcer.isGT0((int)n2, (String)"Bytes");
    }

    @Override
    public final boolean requiresSalt() {
        return true;
    }

    @Nonnull
    protected static final byte[] pbkdf2(@Nonnull char[] cArray, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray, byArray, n, n2 * 8);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(PBKDF2_ALGORITHM);
            return secretKeyFactory.generateSecret(pBEKeySpec).getEncoded();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("Failed to apply PBKDF2 algorithm", generalSecurityException);
        }
    }

    @Override
    @Nonnull
    public String createPasswordHash(@Nonnull IPasswordSalt iPasswordSalt, @Nonnull String string) {
        ValueEnforcer.notNull((Object)iPasswordSalt, (String)"Salt");
        ValueEnforcer.notNull((Object)string, (String)"PlainTextPassword");
        byte[] byArray = AbstractPasswordHashCreatorPBKDF2.pbkdf2(string.toCharArray(), iPasswordSalt.getSaltBytes(), this.m_nIterations, this.m_nHashBytes);
        return StringHelper.getHexEncoded((byte[])byArray);
    }
}

