/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.password.hash;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.security.password.salt.IPasswordSalt;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PasswordHash
implements Serializable {
    private final String m_sAlgorithmName;
    private final IPasswordSalt m_aSalt;
    private final String m_sPasswordHashValue;

    public PasswordHash(@Nonnull @Nonempty String string, @Nullable IPasswordSalt iPasswordSalt, @Nonnull @Nonempty String string2) {
        this.m_sAlgorithmName = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"AlgorithmName");
        this.m_aSalt = iPasswordSalt;
        this.m_sPasswordHashValue = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"PasswordHashValue");
    }

    @Nonnull
    @Nonempty
    public String getAlgorithmName() {
        return this.m_sAlgorithmName;
    }

    public boolean hasSalt() {
        return this.m_aSalt != null;
    }

    @Nullable
    public IPasswordSalt getSalt() {
        return this.m_aSalt;
    }

    @Nullable
    public String getSaltAsString() {
        return this.m_aSalt == null ? null : this.m_aSalt.getSaltString();
    }

    @Nonnull
    @Nonempty
    public String getPasswordHashValue() {
        return this.m_sPasswordHashValue;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PasswordHash passwordHash = (PasswordHash)object;
        return this.m_sAlgorithmName.equals(passwordHash.m_sAlgorithmName) && EqualsHelper.equals((Object)this.m_aSalt, (Object)passwordHash.m_aSalt) && this.m_sPasswordHashValue.equals(passwordHash.m_sPasswordHashValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sAlgorithmName).append((Object)this.m_aSalt).append((Object)this.m_sPasswordHashValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("algorithmName", (Object)this.m_sAlgorithmName).appendIfNotNull("salt", (Object)this.m_aSalt).append("passwordHashValue", (Object)this.m_sPasswordHashValue).getToString();
    }
}

