/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.util.thread;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.string.StringHelper;
import com.helger.xml.microdom.IHasMicroNodeRepresentation;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadDescriptor
implements IHasMicroNodeRepresentation {
    public static final boolean DEFAULT_ENABLE_THREAD_INFO = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadDescriptor.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    private static final ThreadMXBean THREAD_MX = ManagementFactory.getThreadMXBean();
    private static boolean s_bEnableThreadInfo = false;
    private final long m_nID;
    private final String m_sName;
    private final Thread.State m_eState;
    private final int m_nPriority;
    private final String m_sThreadGroup;
    private final String m_sStackTrace;
    private final ThreadInfo m_aThreadInfo;

    public static void setEnableThreadInfo(boolean bl) {
        s_aRWLock.writeLocked(() -> {
            s_bEnableThreadInfo = bl;
            return s_bEnableThreadInfo;
        });
    }

    public static boolean isEnableThreadInfo() {
        return s_aRWLock.readLocked(() -> s_bEnableThreadInfo);
    }

    public ThreadDescriptor(@Nonnull Thread thread, @Nullable String string) {
        ThreadInfo threadInfo;
        block3: {
            ValueEnforcer.notNull((Object)thread, (String)"Thread");
            this.m_nID = thread.getId();
            this.m_sName = thread.getName();
            this.m_eState = thread.getState();
            this.m_nPriority = thread.getPriority();
            ThreadGroup threadGroup = thread.getThreadGroup();
            this.m_sThreadGroup = threadGroup != null ? threadGroup.getName() : "none - DIED!";
            this.m_sStackTrace = string;
            threadInfo = null;
            try {
                if (ThreadDescriptor.isEnableThreadInfo()) {
                    threadInfo = THREAD_MX.getThreadInfo(new long[]{this.m_nID}, true, true)[0];
                }
            }
            catch (Exception exception) {
                if (!LOGGER.isErrorEnabled()) break block3;
                LOGGER.error("Failed to get ThreadInfo for thread " + this.m_nID + ":", (Throwable)exception);
            }
        }
        this.m_aThreadInfo = threadInfo;
    }

    public long getThreadID() {
        return this.m_nID;
    }

    public Thread.State getThreadState() {
        return this.m_eState;
    }

    @Nonnull
    @Nonempty
    public String getDescriptor() {
        return "Thread[" + this.m_nID + "][" + this.m_sName + "][" + (Object)((Object)this.m_eState) + "][" + this.m_nPriority + "][" + this.m_sThreadGroup + "]";
    }

    @Nullable
    public String getStackTrace() {
        return this.m_sStackTrace;
    }

    @Nonnull
    @Nonempty
    public String getStackTraceNotNull() {
        return StringHelper.hasText((String)this.m_sStackTrace) ? this.m_sStackTrace : "No stack trace available\n";
    }

    @Nonnull
    public String getLockInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.m_aThreadInfo != null) {
            try {
                Object[] objectArray;
                Object[] objectArray2 = this.m_aThreadInfo.getLockedMonitors();
                if (ArrayHelper.isNotEmpty((Object[])objectArray2)) {
                    stringBuilder.append("Information on ").append(objectArray2.length).append(" monitors:\n");
                    objectArray = objectArray2;
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        Object object = objectArray[i];
                        stringBuilder.append("  monitor: ").append(((LockInfo)object).getClassName()).append('@').append(Integer.toHexString(((LockInfo)object).getIdentityHashCode())).append(" at ").append(((MonitorInfo)object).getLockedStackFrame()).append(" [").append(((MonitorInfo)object).getLockedStackDepth()).append("]\n");
                    }
                }
                if (ArrayHelper.isNotEmpty((Object[])(objectArray = this.m_aThreadInfo.getLockedSynchronizers()))) {
                    stringBuilder.append("Information on ").append(objectArray.length).append(" synchronizers:\n");
                    for (Object object : objectArray) {
                        stringBuilder.append("  lock:").append(((LockInfo)object).getClassName()).append('@').append(Integer.toHexString(((LockInfo)object).getIdentityHashCode())).append('\n');
                    }
                }
            }
            catch (Exception exception) {
                stringBuilder.append("Error retrieving infos: ").append(exception.toString());
            }
        }
        return stringBuilder.toString();
    }

    @Nonnull
    @Nonempty
    public String getAsString() {
        String string = this.getDescriptor();
        String string2 = this.getStackTraceNotNull();
        String string3 = this.getLockInfo();
        return string + "\n" + string2 + string3;
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroNode() {
        MicroElement microElement = new MicroElement("thread");
        microElement.setAttribute("id", this.m_nID);
        microElement.setAttribute("name", this.m_sName);
        if (this.m_eState != null) {
            microElement.setAttribute("state", this.m_eState.toString());
        }
        microElement.setAttribute("priority", this.m_nPriority);
        microElement.setAttribute("threadgroup", this.m_sThreadGroup);
        microElement.appendElement("stacktrace").appendText(this.getStackTraceNotNull());
        if (this.m_aThreadInfo != null) {
            IMicroElement iMicroElement = microElement.appendElement("threadinfo");
            try {
                Object[] objectArray;
                Object[] objectArray2 = this.m_aThreadInfo.getLockedMonitors();
                if (ArrayHelper.isNotEmpty((Object[])objectArray2)) {
                    objectArray = iMicroElement.appendElement("monitorinfos");
                    objectArray.setAttribute("count", objectArray2.length);
                    for (Object object : objectArray2) {
                        Object object2 = objectArray.appendElement("monitor");
                        object2.setAttribute("classname", ((LockInfo)object).getClassName());
                        object2.setAttribute("identity", Integer.toHexString(((LockInfo)object).getIdentityHashCode()));
                        if (((MonitorInfo)object).getLockedStackFrame() != null) {
                            object2.setAttribute("stackframe", ((MonitorInfo)object).getLockedStackFrame().toString());
                        }
                        if (((MonitorInfo)object).getLockedStackDepth() < 0) continue;
                        object2.setAttribute("stackdepth", ((MonitorInfo)object).getLockedStackDepth());
                    }
                }
                if (ArrayHelper.isNotEmpty((Object[])(objectArray = this.m_aThreadInfo.getLockedSynchronizers()))) {
                    Object[] objectArray3 = iMicroElement.appendElement("synchronizers");
                    objectArray3.setAttribute("count", objectArray.length);
                    for (Object object2 : objectArray) {
                        IMicroElement iMicroElement2 = objectArray3.appendElement("synchronizer");
                        iMicroElement2.setAttribute("classname", ((LockInfo)object2).getClassName());
                        iMicroElement2.setAttribute("identity", Integer.toHexString(((LockInfo)object2).getIdentityHashCode()));
                    }
                }
            }
            catch (Exception exception) {
                ((IMicroElement)iMicroElement.setAttribute("error", exception.getMessage())).appendText(StackTraceHelper.getStackAsString((Throwable)exception));
            }
        }
        return microElement;
    }

    @Nonnull
    public static ThreadDescriptor createForCurrentThread(@Nullable Throwable throwable) {
        String string = StackTraceHelper.getStackAsString((Throwable)throwable, (boolean)false);
        return new ThreadDescriptor(Thread.currentThread(), string);
    }
}

