/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.async;

import com.helger.commons.http.EHttpMethod;
import com.helger.http.EHttpVersion;
import com.helger.servlet.async.ServletAsyncSpec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.AsyncContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExtAsyncContext {
    private final AsyncContext m_aAsyncContext;
    private final EHttpVersion m_eHttpVersion;
    private final EHttpMethod m_eHttpMethod;
    private final String m_sContextPath;
    private final String m_sPathInfo;
    private final String m_sQueryString;
    private final String m_sRequestURI;
    private final String m_sServletPath;
    private boolean m_bSetAttrs = false;

    public ExtAsyncContext(@Nonnull AsyncContext asyncContext, @Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5) {
        this.m_aAsyncContext = asyncContext;
        this.m_eHttpVersion = eHttpVersion;
        this.m_eHttpMethod = eHttpMethod;
        this.m_sContextPath = string;
        this.m_sPathInfo = string2;
        this.m_sQueryString = string3;
        this.m_sRequestURI = string4;
        this.m_sServletPath = string5;
    }

    @Nonnull
    protected AsyncContext getAsyncContext() {
        return this.m_aAsyncContext;
    }

    @Nonnull
    public EHttpVersion getHTTPVersion() {
        return this.m_eHttpVersion;
    }

    @Nonnull
    public EHttpMethod getHTTPMethod() {
        return this.m_eHttpMethod;
    }

    @Nonnull
    public HttpServletRequest getRequest() {
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.m_aAsyncContext.getRequest();
        if (!this.m_bSetAttrs) {
            // empty if block
        }
        return httpServletRequest;
    }

    @Nonnull
    public HttpServletResponse getResponse() {
        return (HttpServletResponse)this.m_aAsyncContext.getResponse();
    }

    public void start(@Nonnull Runnable runnable) {
        this.m_aAsyncContext.start(runnable);
    }

    public void complete() {
        this.m_aAsyncContext.complete();
    }

    @Nonnull
    public static ExtAsyncContext create(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull ServletAsyncSpec servletAsyncSpec) {
        AsyncContext asyncContext = httpServletRequest.startAsync((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        servletAsyncSpec.applyToAsyncContext(asyncContext);
        return new ExtAsyncContext(asyncContext, eHttpVersion, eHttpMethod, httpServletRequest.getContextPath(), httpServletRequest.getPathInfo(), httpServletRequest.getQueryString(), httpServletRequest.getRequestURI(), httpServletRequest.getServletPath());
    }
}

