/*
 * Decompiled with CFR 0.152.
 */
package com.helger.useragent;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsCollection;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.string.StringHelper;
import com.helger.xml.microdom.util.XMLListHandler;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ApplicationUserAgentManager {
    private static final ICommonsSet<String> s_aSet = new CommonsHashSet();
    private static final ApplicationUserAgentManager s_aInstance;

    private ApplicationUserAgentManager() {
    }

    private static void _readList(@Nonnull @Nonempty String string) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (XMLListHandler.readList((IHasInputStream)new ClassPathResource(string), (Collection)commonsArrayList).isFailure()) {
            throw new IllegalStateException("Failed to read " + string);
        }
        s_aSet.addAll((Collection)commonsArrayList);
    }

    @Nullable
    public static String getFromUserAgent(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return (String)s_aSet.findFirst(string::contains);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsCollection<String> getAllItems() {
        return (ICommonsCollection)s_aSet.getClone();
    }

    static {
        ApplicationUserAgentManager._readList("codelists/appuseragents.xml");
        s_aInstance = new ApplicationUserAgentManager();
    }
}

