/*
 * Decompiled with CFR 0.152.
 */
package com.helger.useragent;

import com.helger.collection.pair.IPair;
import com.helger.collection.pair.Pair;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.util.StringScanner;
import com.helger.commons.url.URLProtocolRegistry;
import com.helger.useragent.IUserAgent;
import com.helger.useragent.UserAgent;
import com.helger.useragent.UserAgentElementList;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class UserAgentDecryptor {
    private static final String SKIP_PREFIX = "User-Agent: ";
    private static final UserAgentDecryptor s_aInstance = new UserAgentDecryptor();

    private UserAgentDecryptor() {
    }

    @Nonnull
    private static UserAgentElementList _decryptUserAgent(@Nonnull String string) {
        StringScanner stringScanner;
        UserAgentElementList userAgentElementList;
        block10: {
            int n;
            userAgentElementList = new UserAgentElementList();
            stringScanner = new StringScanner(string.trim());
            block6: while (true) {
                stringScanner.skipWhitespaces();
                n = stringScanner.findFirstIndex(new char[]{'/', ' ', '[', '('});
                if (n == -1) break block10;
                switch (stringScanner.getCharAtIndex(n)) {
                    case '/': {
                        String string2 = stringScanner.getUntilIndex(n);
                        Object object = stringScanner.skip(1).getUntilWhiteSpace();
                        String string3 = string2 + "/" + (String)object;
                        if (URLProtocolRegistry.getInstance().hasKnownProtocol(string3)) {
                            userAgentElementList.add(string3);
                            continue block6;
                        }
                        userAgentElementList.add((IPair<String, String>)Pair.create((Object)string2, (Object)object));
                        continue block6;
                    }
                    case ' ': {
                        String string2 = stringScanner.getUntilIndex(n).trim();
                        Object object = RegExHelper.getMatcher((String)"([^\\s]+)\\s+([0-9]+\\.[0-9]+)", (String)string2);
                        if (((Matcher)object).matches()) {
                            userAgentElementList.add((IPair<String, String>)Pair.create((Object)((Matcher)object).group(1), (Object)((Matcher)object).group(2)));
                            continue block6;
                        }
                        userAgentElementList.add(string2);
                        continue block6;
                    }
                    case '[': {
                        stringScanner.setIndex(n).skip(1);
                        userAgentElementList.add(stringScanner.getUntil(']'));
                        stringScanner.skip(1);
                        continue block6;
                    }
                    case '(': {
                        stringScanner.setIndex(n).skip(1);
                        String string2 = stringScanner.getUntilBalanced(1, '(', ')');
                        Object object = StringHelper.getExploded((char)';', (String)string2);
                        userAgentElementList.add((ICommonsList<String>)object.getAllMapped(String::trim));
                        continue block6;
                    }
                }
                break;
            }
            throw new IllegalStateException("Invalid character: " + stringScanner.getCharAtIndex(n));
        }
        String string4 = stringScanner.getRest().trim();
        if (string4.length() > 0) {
            userAgentElementList.add(string4);
        }
        return userAgentElementList;
    }

    @Nonnull
    public static IUserAgent decryptUserAgentString(@Nonnull String string) {
        char c;
        ValueEnforcer.notNull((Object)string, (String)"UserAgent");
        String string2 = string;
        if (string2.length() >= 2 && ((c = string2.charAt(0)) == '\'' || c == '\"') && StringHelper.getLastChar((CharSequence)string2) == c) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (string2.startsWith(SKIP_PREFIX)) {
            string2 = string2.substring(SKIP_PREFIX.length());
        }
        return new UserAgent(string2, UserAgentDecryptor._decryptUserAgent(string2));
    }
}

