/*
 * Decompiled with CFR 0.152.
 */
package com.helger.useragent.browser;

import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.useragent.browser.EBrowserText;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EBrowserType implements IHasID<String>,
IHasDisplayText
{
    FIREFOX("firefox", EBrowserText.FIREFOX),
    IE("ie", EBrowserText.IE),
    OPERA("opera", EBrowserText.OPERA),
    SAFARI("safari", EBrowserText.SAFARI),
    CHROME("chrome", EBrowserText.CHROME),
    LYNX("lynx", EBrowserText.LYNX),
    KONQUEROR("konqueror", EBrowserText.KONQUEROR),
    VIVALDI("vivaldi", EBrowserText.VIVALDI),
    GECKO("gecko", EBrowserText.GECKO),
    WEBKIT("webkit", EBrowserText.WEBKIT),
    MOBILE("mobile", EBrowserText.MOBILE),
    SPIDER("spider", EBrowserText.SPIDER),
    APPLICATION("generic", EBrowserText.APPLICATION);

    private final String m_sID;
    private final IHasDisplayText m_aDisplayName;

    private EBrowserType(String string2, IHasDisplayText iHasDisplayText) {
        this.m_sID = string2;
        this.m_aDisplayName = iHasDisplayText;
    }

    @Nonnull
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    public String getDisplayText(Locale locale) {
        return this.m_aDisplayName.getDisplayText(locale);
    }

    @Nullable
    public static EBrowserType getFromIDOrNull(@Nullable String string) {
        return (EBrowserType)EnumHelper.getFromIDOrNull(EBrowserType.class, (Object)string);
    }
}

