/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.attr.AttributeContainerAny;
import com.helger.commons.collection.attr.IAttributeContainerAny;
import com.helger.commons.collection.iterate.EmptyEnumeration;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.scope.AbstractScope;
import com.helger.scope.ScopeHelper;
import com.helger.servlet.ServletContextPathHolder;
import com.helger.servlet.ServletSettings;
import com.helger.servlet.request.IRequestParamMap;
import com.helger.servlet.request.RequestHelper;
import com.helger.servlet.request.RequestParamMap;
import com.helger.web.scope.IRequestParamContainer;
import com.helger.web.scope.IRequestWebScope;
import java.io.Serializable;
import java.text.Normalizer;
import java.time.LocalDateTime;
import java.util.Enumeration;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestWebScope
extends AbstractScope
implements IRequestWebScope {
    private static final long serialVersionUID = 78563987233147L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestWebScope.class);
    private static final String REQUEST_ATTR_SCOPE_INITED = "$ph-requestscope.inited";
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static IParamValueCleanser s_aParamValueCleanser = (string, n, string2) -> RequestWebScope.getWithoutForbiddenCharsAndNormalized(string2);
    private final LocalDateTime m_aCreationDT;
    protected final transient HttpServletRequest m_aHttpRequest;
    protected final transient HttpServletResponse m_aHttpResponse;
    private HttpHeaderMap m_aHeaders;
    private final ParamContainer m_aParams = new ParamContainer();
    private IRequestParamMap m_aRequestParamMap;

    @Nullable
    public static IParamValueCleanser getParamValueCleanser() {
        return (IParamValueCleanser)s_aRWLock.readLockedGet(() -> s_aParamValueCleanser);
    }

    public static void setParamValueCleanser(@Nullable IParamValueCleanser iParamValueCleanser) {
        s_aRWLock.writeLockedGet(() -> {
            s_aParamValueCleanser = iParamValueCleanser;
            return s_aParamValueCleanser;
        });
    }

    @Nonnull
    @Nonempty
    private static String _createScopeID(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        return GlobalIDFactory.getNewIntID() + "@" + RequestHelper.getRequestURIDecoded((HttpServletRequest)httpServletRequest);
    }

    public RequestWebScope(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse) {
        super(RequestWebScope._createScopeID(httpServletRequest));
        this.m_aCreationDT = PDTFactory.getCurrentLocalDateTime();
        this.m_aHttpRequest = httpServletRequest;
        this.m_aHttpResponse = (HttpServletResponse)ValueEnforcer.notNull((Object)httpServletResponse, (String)"HttpResponse");
        if (ScopeHelper.debugRequestScopeLifeCycle((Logger)LOGGER) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Created request web scope '" + super.getID() + "' of class " + ClassHelper.getClassLocalName(RequestWebScope.class), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    @Nonnull
    public final LocalDateTime getCreationDateTime() {
        return this.m_aCreationDT;
    }

    @Nonnull
    @OverrideOnDemand
    protected EChange addSpecialRequestParams() {
        return EChange.UNCHANGED;
    }

    public static boolean isForbiddenParamValueChar(char c) {
        return c >= '\u0000' && c <= '\b' || c >= '\u000b' && c <= '\f' || c >= '\u000e' && c <= '\u001f' || c == '\u007f' || c >= '\ud800' && c <= '\udfff' || c >= '\ufffe' && c <= '\uffff';
    }

    @Nullable
    public static String getWithoutForbiddenChars(@Nullable String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        for (char c : string.toCharArray()) {
            if (RequestWebScope.isForbiddenParamValueChar(c)) {
                ++n;
                continue;
            }
            stringBuilder.append(c);
        }
        if (n == 0) {
            return string;
        }
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Removed " + n + " forbidden character(s) from a request parameter value!");
        }
        return stringBuilder.toString();
    }

    @Nullable
    public static String getWithoutForbiddenCharsAndNormalized(@Nullable String string) {
        String string2 = string;
        if (string2 == null) {
            return null;
        }
        if ((string2 = RequestWebScope.getWithoutForbiddenChars(string2)) == null) {
            return null;
        }
        string2 = Normalizer.normalize(string2, Normalizer.Form.NFKC);
        return string2;
    }

    public final void initScope() {
        Enumeration enumeration;
        IAttributeContainerAny iAttributeContainerAny = this.attrs();
        if (iAttributeContainerAny.getAndSetFlag((Object)REQUEST_ATTR_SCOPE_INITED)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Scope was already inited: " + this.toString());
            }
            return;
        }
        IRequestParamContainer iRequestParamContainer = this.params();
        boolean bl = this.addSpecialRequestParams().isChanged();
        IParamValueCleanser iParamValueCleanser = RequestWebScope.getParamValueCleanser();
        try {
            enumeration = this.m_aHttpRequest.getParameterNames();
        }
        catch (Exception exception) {
            enumeration = new EmptyEnumeration();
        }
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            if (bl && iRequestParamContainer.containsKey(string)) continue;
            String[] stringArray = this.m_aHttpRequest.getParameterValues(string);
            int n = stringArray.length;
            if (n == 1) {
                object = stringArray[0];
                if (iParamValueCleanser != null) {
                    object = iParamValueCleanser.getCleanedValue(string, 0, (String)object);
                }
                iRequestParamContainer.putIn(string, object);
                continue;
            }
            object = new String[n];
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                if (iParamValueCleanser != null) {
                    string2 = iParamValueCleanser.getCleanedValue(string, i, string2);
                }
                object[i] = string2;
            }
            iRequestParamContainer.putIn(string, object);
        }
        if (ScopeHelper.debugRequestScopeLifeCycle((Logger)LOGGER) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Initialized request web scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName((Object)this), ScopeHelper.getDebugStackTrace());
        }
    }

    protected void postDestroy() {
        if (ScopeHelper.debugRequestScopeLifeCycle((Logger)LOGGER) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Destroyed request web scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName((Object)this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    @Nonnull
    public final HttpHeaderMap headers() {
        HttpHeaderMap httpHeaderMap = this.m_aHeaders;
        if (httpHeaderMap == null) {
            httpHeaderMap = this.m_aHeaders = RequestHelper.getRequestHeaderMap((HttpServletRequest)this.m_aHttpRequest);
        }
        return httpHeaderMap;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final IRequestParamContainer params() {
        return this.m_aParams;
    }

    @Override
    @Nonnull
    public final IRequestParamMap getRequestParamMap() {
        IRequestParamMap iRequestParamMap = this.m_aRequestParamMap;
        if (iRequestParamMap == null) {
            iRequestParamMap = this.m_aRequestParamMap = RequestParamMap.create((Map)((Object)this.params()));
        }
        return iRequestParamMap;
    }

    public static boolean isFileBasedRequest(@Nonnull String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return false;
        }
        int n2 = string.lastIndexOf(47);
        if (n2 < 0) {
            return true;
        }
        return n > n2;
    }

    @Override
    @Nonnull
    public String getContextPath() {
        return ServletContextPathHolder.getContextPath();
    }

    @Override
    @Nonnull
    public String getContextAndServletPath() {
        String string = this.getServletPath();
        if (RequestWebScope.isFileBasedRequest(string)) {
            return this.getContextPath() + string;
        }
        return this.getContextPath() + string + '/';
    }

    @Override
    @Nonnull
    public String getFullContextAndServletPath() {
        String string = this.getServletPath();
        if (RequestWebScope.isFileBasedRequest(string)) {
            return this.getFullContextPath() + string;
        }
        return this.getFullContextPath() + string + '/';
    }

    @Override
    @Nonnull
    public final HttpServletRequest getRequest() {
        return this.m_aHttpRequest;
    }

    @Override
    @Nonnull
    public final HttpServletResponse getResponse() {
        return this.m_aHttpResponse;
    }

    @Override
    @Nonnull
    public String encodeURL(@Nonnull String string) {
        if (ServletSettings.isEncodeURLs()) {
            return this.getResponse().encodeURL(string);
        }
        return string;
    }

    @Override
    @Nonnull
    public String encodeRedirectURL(@Nonnull String string) {
        if (ServletSettings.isEncodeURLs()) {
            return this.getResponse().encodeRedirectURL(string);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("HttpRequest", (Object)this.m_aHttpRequest).append("HttpResponse", (Object)this.m_aHttpResponse).append("Headers", (Object)this.m_aHeaders).append("Params", (Object)this.m_aParams).append("RequestParamMap", (Object)this.m_aRequestParamMap).getToString();
    }

    @FunctionalInterface
    public static interface IParamValueCleanser
    extends Serializable {
        @Nullable
        public String getCleanedValue(@Nonnull String var1, @Nonnegative int var2, @Nullable String var3);
    }

    public static class ParamContainer
    extends AttributeContainerAny<String>
    implements IRequestParamContainer {
    }
}

