/*
 * Decompiled with CFR 0.152.
 */
package com.holdenkarau.spark.testing;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.spark.sql.Row;
import scala.Serializable;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DataFrameSuiteBase$
implements Serializable {
    public static final DataFrameSuiteBase$ MODULE$;

    static {
        new DataFrameSuiteBase$();
    }

    public boolean approxEquals(Row r1, Row r2, double tol) {
        if (r1.length() != r2.length()) {
            return false;
        }
        int length = r1.length();
        for (int idx = 0; idx < length; ++idx) {
            BoxedUnit boxedUnit;
            if (r1.isNullAt(idx) != r2.isNullAt(idx)) {
                return false;
            }
            if (r1.isNullAt(idx)) continue;
            Object o1 = r1.get(idx);
            Object o2 = r2.get(idx);
            Object object = o1;
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                if (Arrays.equals(byArray, (byte[])o2)) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                return false;
            }
            if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                if (Float.isNaN(f) != Float.isNaN(BoxesRunTime.unboxToFloat((Object)o2))) {
                    return false;
                }
                if ((double)package$.MODULE$.abs(f - BoxesRunTime.unboxToFloat((Object)o2)) > tol) {
                    return false;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                if (Double.isNaN(d) != Double.isNaN(BoxesRunTime.unboxToDouble((Object)o2))) {
                    return false;
                }
                if (package$.MODULE$.abs(d - BoxesRunTime.unboxToDouble((Object)o2)) > tol) {
                    return false;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                if (bigDecimal.compareTo((BigDecimal)o2) != 0) {
                    return false;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                if ((double)package$.MODULE$.abs(timestamp.getTime() - ((Timestamp)o2).getTime()) > tol) {
                    return false;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (BoxesRunTime.equals((Object)o1, (Object)o2)) {
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            return false;
        }
        return true;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DataFrameSuiteBase$() {
        MODULE$ = this;
    }
}

